/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.cache;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.cache.impl.CachePool;
import com.sap.idm.vds.config.MVDCache;
import com.sap.idm.vds.config.MVDCacheList;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class MVDCachePool {
    public static final String GLOBAL_CACHE = "CACHE_GLOBAL";
    private static MVDCachePool pool;
    private static long cacheHit;
    private static long cacheChecks;
    public static String EXPAND_TYPE_RESULT;
    public static String EXPAND_TYPE_ENTRIES;
    public static String EXPAND_TYPE_RES_ENTRIES;
    private HashMap mDSCache;
    private Vector mAllDS;
    private boolean enabled = false;
    private boolean useglobals = false;
    private int mTtl;
    private boolean override_attrs = false;
    private boolean override_sub_attrs = false;
    private String expand_sub = EXPAND_TYPE_RES_ENTRIES;
    private boolean cache_base = false;
    private boolean cacheone_sub = false;
    private String mHeapSettings;
    private String mAvailableMemory;
    private Properties props;
    CachePool mxcpool;

    public void setHeapSettings(String s) {
        this.mHeapSettings = s;
    }

    public void setAvailableMemory(String s) {
        this.mAvailableMemory = s;
    }

    public String getHeapSettings() {
        return this.mHeapSettings;
    }

    public String getAvailableMemory() {
        return this.mAvailableMemory;
    }

    private MVDCachePool() {
        pool = this;
        this.props = new Properties();
        this.mDSCache = new HashMap();
        this.mAllDS = new Vector();
    }

    public static MVDCachePool instance() {
        if (pool == null) {
            pool = new MVDCachePool();
        }
        return pool;
    }

    public static MVDSearchResults getCacheEntryIfCacheAllowed(String dn, int dsid, int operationScope, String urlfilter, Vector requestedAttributes, Vector mandatoryAttributes) {
        if (MVDCachePool.instance().getUseGlobals() || dsid == -999) {
            String allowres = MVDCachePool.instance().allowReadGlobalCaching(operationScope, urlfilter);
            if (allowres != null) {
                return MVDCachePool.instance().getEntry(null, dn + allowres, requestedAttributes, operationScope, mandatoryAttributes);
            }
        } else {
            MVDCache conf = MVDCacheList.getCacheByDSID(dsid);
            String allowres = MVDCachePool.instance().allowReadCaching(conf, operationScope, urlfilter);
            if (allowres != null) {
                return MVDCachePool.instance().getEntry(conf, dn + allowres, requestedAttributes, operationScope, mandatoryAttributes);
            }
        }
        return null;
    }

    public MVDSearchResults getEntry(MVDCache conf, String string, Vector requestedAttributes, int operationScope, Vector mandatoryAttributes) {
        String dsname;
        MVDLogger.Log("Search cache for: " + string, 3);
        if (conf == null) {
            dsname = GLOBAL_CACHE;
        } else {
            if (!conf.cacheEnabled()) {
                return null;
            }
            dsname = (String)this.mDSCache.get(new Integer(conf.DataSource()));
        }
        ++cacheChecks;
        Object cachedentry = this.mxcpool.getEntry(dsname, string);
        if (cachedentry != null) {
            ++cacheHit;
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log("Found entry in cache: " + string, 3);
            }
            try {
                Vector distinctAttributes = new Vector(requestedAttributes);
                distinctAttributes.remove("*");
                if (mandatoryAttributes != null && mandatoryAttributes.size() > 0) {
                    distinctAttributes.removeAll(mandatoryAttributes);
                }
                if (operationScope == 0) {
                    MVDSearchResults res = new MVDSearchResults();
                    MVDSearchResultEntry entry = (MVDSearchResultEntry)cachedentry;
                    MVDSearchResultEntry entrycopy = (MVDSearchResultEntry)entry.clone();
                    HashMap h = entrycopy.getAttrAndValues();
                    int bWhatIsRequested = MVDUtil.areAllAttributesRequested(requestedAttributes);
                    if (bWhatIsRequested == 0) {
                        MVDLogger.Debug("Removing operational attributes from data set", 2);
                        MVDOpUtilities.CleanRESAttributesByVector(h, Globals.getOperationalAttributes(), false);
                    } else if (bWhatIsRequested == 1) {
                        MVDOpUtilities.CleanRESAttributesByVector(h, requestedAttributes, true);
                    } else {
                        HashMap allCachedValues = (HashMap)h.clone();
                        MVDLogger.Debug("Removing operational attributes from data set", 2);
                        MVDOpUtilities.CleanRESAttributesByVector(h, Globals.getOperationalAttributes(), false);
                        MVDOpUtilities.CleanRESAttributesByVector(allCachedValues, distinctAttributes, true);
                        h.putAll(allCachedValues);
                    }
                    res.add(entrycopy);
                    res.setOK();
                    return res;
                }
                MVDSearchResults cacheres = (MVDSearchResults)cachedentry;
                MVDSearchResults rescopy = (MVDSearchResults)cacheres.clone();
                int iWhatIsRequested = MVDUtil.areAllAttributesRequested(requestedAttributes);
                if (iWhatIsRequested == 0) {
                    MVDLogger.Debug("Removing operational attributes from data set", 2);
                    MVDOpUtilities.CleanRESEntriesAttributesByVector(rescopy, Globals.getOperationalAttributes(), false);
                } else if (iWhatIsRequested == 1) {
                    MVDOpUtilities.CleanRESEntriesAttributesByVector(rescopy, requestedAttributes, true);
                } else {
                    MVDSearchResults allCachedValues = (MVDSearchResults)rescopy.clone();
                    MVDLogger.Debug("Removing operational attributes from data set", 2);
                    MVDOpUtilities.CleanRESEntriesAttributesByVector(rescopy, Globals.getOperationalAttributes(), false);
                    MVDOpUtilities.CleanRESEntriesAttributesByVector(allCachedValues, distinctAttributes, true);
                    rescopy.join(allCachedValues);
                }
                return rescopy;
            }
            catch (Exception e) {
                MVDLogger.Log("Error fetching " + string + " from cache. (" + e.getMessage() + ")", 3);
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String ConstructCacheKeyClob(int opType, String keyDn, String keyFilter) {
        String constructedKey = "";
        if (keyDn == null || keyFilter == null) {
            return null;
        }
        constructedKey = keyDn;
        constructedKey = opType == 1 ? constructedKey + "!!one!!" : constructedKey + "!!sub!!";
        constructedKey = constructedKey + keyFilter;
        return constructedKey;
    }

    public static boolean cacheEntryIfCacheAllowed(MVDSearchResults results, int operationScope, Vector requestedAttributes, String keyDn, String keyFilter, int dsid) {
        int allowres = 999;
        MVDCache conf = null;
        if (results == null) {
            return false;
        }
        if (!results.evaluateOK()) {
            return false;
        }
        if (MVDCachePool.instance().getUseGlobals()) {
            allowres = MVDCachePool.instance().allowGlobalWriteToCache(operationScope, requestedAttributes);
        } else {
            conf = MVDCacheList.getCacheByDSID(dsid);
            allowres = MVDCachePool.allowWriteToCache(conf, operationScope, requestedAttributes);
        }
        if (allowres > 0 && results.isPartial()) {
            allowres = 4;
        }
        if (allowres == 0) {
            return false;
        }
        if (allowres == 1 || allowres == 4) {
            MVDCachePool.instance().addEntriesExpanded(conf, results);
            return true;
        }
        if (allowres > 0) {
            String constructedKey;
            if (allowres == 3) {
                MVDCachePool.instance().addEntriesExpanded(conf, results);
            }
            if ((constructedKey = MVDCachePool.ConstructCacheKeyClob(operationScope, keyDn, keyFilter)) != null) {
                MVDCachePool.instance().addEntriesClob(conf, results, constructedKey);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean getUseGlobals() {
        return this.useglobals;
    }

    public void addEntriesExpanded(MVDCache conf, MVDSearchResults results) {
        if (this.useglobals && conf == null) {
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                try {
                    MVDSearchResultEntry entry = (MVDSearchResultEntry)iter.next();
                    this.mxcpool.cacheEntry(GLOBAL_CACHE, entry.getDn(), entry.clone());
                }
                catch (Exception e) {}
            }
        } else {
            String dsname = (String)this.mDSCache.get(new Integer(conf.DataSource()));
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                try {
                    MVDSearchResultEntry entry = (MVDSearchResultEntry)iter.next();
                    this.mxcpool.cacheEntry(dsname, entry.getDn(), entry.clone());
                }
                catch (Exception e) {}
            }
        }
    }

    public void addEntriesClob(MVDCache conf, MVDSearchResults results, String keyDnConstructed) {
        if (keyDnConstructed == null) {
            return;
        }
        MVDSearchResults clonedresults = (MVDSearchResults)results.clone();
        if (this.useglobals && conf == null) {
            this.mxcpool.cacheEntry(GLOBAL_CACHE, keyDnConstructed, clonedresults);
        } else {
            String dsname = (String)this.mDSCache.get(new Integer(conf.DataSource()));
            this.mxcpool.cacheEntry(dsname, keyDnConstructed, clonedresults);
        }
    }

    private static int allowWriteToCache(MVDCache conf, int operationScope, Vector requestedAttributes) {
        if (!MVDCachePool.instance().enabled || conf == null || !conf.cacheEnabled()) {
            return 0;
        }
        if (operationScope == 0 && conf.cache_base()) {
            boolean wholeAttrSetBASEWASRequired;
            boolean bl = wholeAttrSetBASEWASRequired = conf.override_attrs() || requestedAttributes.size() == 0 || requestedAttributes.size() > 0 && requestedAttributes.elementAt(0).equals("*");
            if (!wholeAttrSetBASEWASRequired) {
                return 0;
            }
            return 1;
        }
        if ((operationScope == 1 || operationScope == 2) && conf.cacheone_sub()) {
            boolean wholeAttrSetSubWASRequired;
            boolean bl = wholeAttrSetSubWASRequired = conf.override_sub_attrs() || requestedAttributes.size() == 0 || requestedAttributes.size() > 0 && requestedAttributes.elementAt(0).equals("*");
            if (!wholeAttrSetSubWASRequired) {
                if (conf.expand_sub().equals(EXPAND_TYPE_RESULT)) {
                    return 2;
                }
                return 0;
            }
            if (conf.expand_sub().equals(EXPAND_TYPE_RES_ENTRIES)) {
                return 3;
            }
            if (conf.expand_sub().equals(EXPAND_TYPE_RESULT)) {
                return 2;
            }
            return 4;
        }
        return 0;
    }

    private int allowGlobalWriteToCache(int operationScope, Vector requestedAttributes) {
        if (!this.enabled) {
            return 0;
        }
        if (operationScope == 0 && this.cache_base) {
            boolean wholeAttrSetBASEWASRequired;
            boolean bl = wholeAttrSetBASEWASRequired = this.override_attrs || requestedAttributes.size() == 0 || requestedAttributes.size() > 0 && requestedAttributes.elementAt(0).equals("*");
            if (!wholeAttrSetBASEWASRequired) {
                return 0;
            }
            return 1;
        }
        if ((operationScope == 1 || operationScope == 2) && this.cacheone_sub) {
            boolean wholeAttrSetSubWASRequired;
            boolean bl = wholeAttrSetSubWASRequired = this.override_sub_attrs || requestedAttributes.size() == 0 || requestedAttributes.size() > 0 && requestedAttributes.elementAt(0).equals("*");
            if (!wholeAttrSetSubWASRequired) {
                if (this.expand_sub.equals(EXPAND_TYPE_RESULT)) {
                    return 2;
                }
                return 0;
            }
            if (this.expand_sub.equals(EXPAND_TYPE_RES_ENTRIES)) {
                return 3;
            }
            if (this.expand_sub.equals(EXPAND_TYPE_RESULT)) {
                return 2;
            }
            return 4;
        }
        return 0;
    }

    private String allowReadCaching(MVDCache conf, int operationScope, String urlfilter) {
        if (!MVDCachePool.instance().enabled || conf == null || !conf.cacheEnabled()) {
            return null;
        }
        if (operationScope == 1) {
            if (conf.cacheone_sub()) {
                return "!!one!!" + urlfilter.toLowerCase();
            }
            return null;
        }
        if (operationScope == 2) {
            if (conf.cacheone_sub()) {
                return "!!sub!!" + urlfilter.toLowerCase();
            }
            return null;
        }
        if (operationScope == 0) {
            boolean bDoEntryCaching;
            if (!urlfilter.replace('(', ' ').replace(')', ' ').trim().equalsIgnoreCase("objectclass=*")) {
                return null;
            }
            boolean bl = bDoEntryCaching = conf.cache_base() || conf.cacheone_sub() && !conf.expand_sub().equals(EXPAND_TYPE_RESULT);
            if (!bDoEntryCaching) {
                return null;
            }
            return "";
        }
        return null;
    }

    private String allowReadGlobalCaching(int operationScope, String urlfilter) {
        if (!this.enabled) {
            return null;
        }
        if (operationScope == 1) {
            if (this.cacheone_sub) {
                return "!!one!!" + urlfilter.toLowerCase();
            }
            return null;
        }
        if (operationScope == 2) {
            if (this.cacheone_sub) {
                return "!!sub!!" + urlfilter.toLowerCase();
            }
            return null;
        }
        if (operationScope == 0) {
            boolean bDoEntryCaching;
            if (!urlfilter.replace('(', ' ').replace(')', ' ').trim().equalsIgnoreCase("objectclass=*")) {
                return null;
            }
            boolean bl = bDoEntryCaching = this.cache_base || this.cacheone_sub && !this.expand_sub.equals(EXPAND_TYPE_RESULT);
            if (!bDoEntryCaching) {
                return null;
            }
            return "";
        }
        return null;
    }

    public void createCache(MVDCache cr) {
        int dsid = cr.DataSource();
        String dsname = dsid + "";
        if (!this.mDSCache.containsKey(new Integer(dsid))) {
            this.mDSCache.put(new Integer(dsid), dsname);
            this.mAllDS.add(new Integer(dsid));
        }
    }

    public void userCreateCache(int dsid, String cachename, int ttl) {
        this.mDSCache.put(new Integer(dsid), cachename);
        this.mxcpool.createCache(cachename, ttl);
    }

    public void setCleaninterval(int cleaninterval) {
        this.props.put("cleaninterval", cleaninterval + "");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void ready() {
        this.mxcpool = CachePool.initializePool(this.props);
        if (this.useglobals) {
            this.mxcpool.createCache(GLOBAL_CACHE, this.mTtl);
        } else {
            Iterator iter = this.mAllDS.iterator();
            while (iter.hasNext()) {
                int dsid = (Integer)iter.next();
                MVDCache conf = MVDCacheList.getCacheByDSID(dsid);
                if (conf == null || !conf.cacheEnabled()) continue;
                String dsname = (String)this.mDSCache.get(new Integer(dsid));
                this.mxcpool.createCache(dsname, conf.TTL());
            }
        }
    }

    public void reload() {
        if (this.useglobals) {
            this.mxcpool.createCache(GLOBAL_CACHE, this.mTtl);
        } else {
            this.mxcpool.removeCache(GLOBAL_CACHE);
        }
        Iterator iter = this.mAllDS.iterator();
        while (iter.hasNext()) {
            String dsname;
            int dsid = (Integer)iter.next();
            MVDCache conf = MVDCacheList.getCacheByDSID(dsid);
            if (conf != null && conf.cacheEnabled() && !this.useglobals) {
                dsname = (String)this.mDSCache.get(new Integer(dsid));
                this.mxcpool.createCache(dsname, conf.TTL());
                continue;
            }
            dsname = (String)this.mDSCache.get(new Integer(dsid));
            this.mxcpool.removeCache(dsname);
        }
        this.mxcpool.reloadProperties(this.props);
    }

    public void shutdown() {
        if (this.mxcpool != null) {
            this.mxcpool.shutdown();
            this.mxcpool = null;
        }
    }

    public void setCleanPolicy(int percentage) {
        this.props.put("cleantopercentage", percentage + "");
    }

    public void setSzLimit(int intVal) {
        this.props.put("cachesize", intVal + "");
    }

    public void setUseGlobals(boolean boolVal) {
        this.useglobals = boolVal;
        if (this.useglobals && !this.mDSCache.containsKey(new Integer(-1))) {
            this.mDSCache.put(new Integer(-1), GLOBAL_CACHE);
        }
    }

    private boolean isCacheone_sub() {
        return this.cacheone_sub;
    }

    private boolean isCacheBase() {
        return this.cache_base;
    }

    private String isExpandSub() {
        return this.expand_sub;
    }

    private boolean isOverrideSub_attrs() {
        return this.override_sub_attrs;
    }

    public void setCacheone_sub(boolean cacheone_sub) {
        this.cacheone_sub = cacheone_sub;
    }

    public boolean getCacheone_sub() {
        return this.cacheone_sub;
    }

    public void setCacheBase(boolean cachebase) {
        this.cache_base = cachebase;
    }

    public boolean getCacheBase() {
        return this.cache_base;
    }

    public void setExpandSub(String expandsub) {
        this.expand_sub = expandsub;
    }

    public String getExpandSub() {
        return this.expand_sub;
    }

    public void setGlobalTTL(int ttl) {
        this.mTtl = ttl;
    }

    public int getGlobalTTL() {
        return this.mTtl;
    }

    public void setSoftLimit(String amount) {
        amount = amount + "m";
        this.props.put("MXCACHE_MEM_SOFT_LIMIT", amount);
    }

    public String getSoftLimit() {
        String s = (String)this.props.get("MXCACHE_MEM_SOFT_LIMIT");
        s = s != null && s.length() > 0 ? s.substring(0, s.length() - 1) : "";
        return s;
    }

    public void setHardLimit(String amount) {
        amount = amount + "m";
        this.props.put("MXCACHE_MEM_HARD_LIMIT", amount);
    }

    public String getHardLimit() {
        String s = (String)this.props.get("MXCACHE_MEM_HARD_LIMIT");
        s = s != null && s.length() > 0 ? s.substring(0, s.length() - 1) : "";
        return s;
    }

    public void setMemBasedCleanPercentage(String amount) {
        this.props.put("MXCACHE_MEM_CLEAN_PERCENTAGE", amount);
    }

    public String getMemBasedCleanPercentage() {
        String s = (String)this.props.get("MXCACHE_MEM_CLEAN_PERCENTAGE");
        return s;
    }

    public void setMemBasedGCLimit(String amount) {
        this.props.put("MXCACHE_CALL_GC_CLEAN_TRESHOLD", amount);
    }

    public String getMemBasedGCLimit() {
        String s = (String)this.props.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD");
        return s;
    }

    public void setDoMemoryCaching(String bdo) {
        this.props.put("MXCACHE_DO_MEMORY_CACHING", bdo);
    }

    public boolean getDoMemoryCaching() {
        String s = (String)this.props.get("MXCACHE_DO_MEMORY_CACHING");
        return s.equalsIgnoreCase("TRUE");
    }

    public void setInitialCacheSize(String bdo) {
        this.props.put("MXCACHE_MEM_INITIAL_CACHE_SIZE", bdo);
    }

    public String getInitialCacheSize() {
        String s = (String)this.props.get("MXCACHE_MEM_INITIAL_CACHE_SIZE");
        return s;
    }

    private boolean isOverride_attrs() {
        return this.override_attrs;
    }

    public void setOverride_attrs(boolean override_attrs) {
        this.override_attrs = override_attrs;
    }

    public boolean getOverride_attrs() {
        return this.override_attrs;
    }

    public void setOverrideSub_attrs(boolean override_sub_attrs) {
        this.override_sub_attrs = override_sub_attrs;
    }

    public boolean getOverrideSub_attrs() {
        return this.override_sub_attrs;
    }

    public boolean allowChangeAttributes(int dsid) {
        if (this.useglobals) {
            return this.enabled && this.cache_base && this.override_attrs;
        }
        MVDCache cache = MVDCacheList.getCacheByDSID(dsid);
        return this.enabled && cache != null && cache.cacheEnabled() && cache.cache_base() && cache.override_attrs();
    }

    public boolean allowChangeAttributesSublevel(int dsid) {
        if (this.useglobals) {
            return this.enabled && this.cacheone_sub && this.override_sub_attrs;
        }
        MVDCache cache = MVDCacheList.getCacheByDSID(dsid);
        return this.enabled && cache != null && cache.cacheEnabled() && cache.cacheone_sub() && cache.override_sub_attrs();
    }

    public boolean isCacheEnabled() {
        return this.enabled;
    }

    public void deleteFromCache(String dn, int ds) {
        if (this.useglobals && ds > -2) {
            ds = -1;
        }
        String dsname = (String)this.mDSCache.get(new Integer(ds));
        this.mxcpool.deleteFromCache(dsname, dn);
    }

    public int getCacheSize() {
        return this.mxcpool.getCacheSize();
    }

    public long getCacheHits() {
        return this.mxcpool.getCacheHits();
    }

    public long getCacheReadOperations() {
        return this.mxcpool.getCacheReadOperations();
    }

    public long getCacheWrites() {
        return this.mxcpool.getCacheWrites();
    }

    public boolean cleanAllEntries(int ds) {
        String dsname = (String)this.mDSCache.get(new Integer(ds));
        return this.mxcpool.cleanAllEntries(dsname);
    }

    public void remove(MVDCache cache) {
        this.mDSCache.remove(new Integer(cache.DataSource()));
        Iterator iter = this.mAllDS.iterator();
        while (iter.hasNext()) {
            Integer element = (Integer)iter.next();
            if (element.intValue() != cache.DataSource()) continue;
            iter.remove();
            break;
        }
    }

    public void userRemoveCache(int cacheid) {
        this.mDSCache.remove(new Integer(cacheid));
    }

    public void runGarbageCollector() {
        if (this.mxcpool != null) {
            this.mxcpool.runGarbageCollector();
        }
    }

    public long getRejected() {
        return this.mxcpool.getRejected();
    }

    public long getTotalCleaned() {
        return this.mxcpool.getTotalCleaned();
    }

    public HashMap getConfigurationParameters() {
        HashMap<Object, Object> cfg = new HashMap<Object, Object>(this.props);
        cfg.put("TTL", this.mTtl + "");
        return cfg;
    }

    static {
        cacheHit = 0L;
        cacheChecks = 0L;
        EXPAND_TYPE_RESULT = "RESULT";
        EXPAND_TYPE_ENTRIES = "ENTRIES";
        EXPAND_TYPE_RES_ENTRIES = "RES_ENTRIES";
    }
}

