/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1.util;

import com.sap.idm.vds.asn1.util.Comparable;
import com.sap.idm.vds.asn1.util.Constants;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public final class BitString
implements Comparable,
Constants,
Serializable {
    public static final BitString EMPTY = new BitString(0, 0, new int[0]);
    public static final BitString ZERO = new BitString(0, 0, 1);
    public static final BitString ONE = new BitString(1, 0, 1);
    private int[] bits;
    private int begBit;
    private int nBits;

    private final long getSomeBits(int i, int i_0_) {
        if (i_0_ == 0) {
            return 0L;
        }
        int i_1_ = (i += this.begBit) / 32;
        int i_2_ = i % 32;
        long l = ((long)this.bits[i_1_] & 0xFFFFFFFFL) >>> i_2_;
        for (int i_3_ = 32 - i_2_; i_3_ < i_0_; i_3_ += 32) {
            l |= ((long)this.bits[++i_1_] & 0xFFFFFFFFL) << i_3_;
        }
        if (i_0_ < 64) {
            l &= (1L << i_0_) - 1L;
        }
        return l;
    }

    private final void checkIndices(int i, int i_4_, int i_5_) {
        if (i < 0 || i_4_ < 0 || i_4_ > i_5_ || i_4_ > this.nBits) {
            throw new IllegalArgumentException("Invalid index");
        }
    }

    public int length() {
        return this.nBits;
    }

    public int toInt(int i, int i_6_) {
        if (i + i_6_ > this.nBits) {
            i_6_ = this.nBits - i;
        }
        this.checkIndices(i, i_6_, 32);
        return (int)this.getSomeBits(i, i_6_);
    }

    public long toLong(int i, int i_7_) {
        if (i + i_7_ > this.nBits) {
            i_7_ = this.nBits - i;
        }
        this.checkIndices(i, i_7_, 64);
        return this.getSomeBits(i, i_7_);
    }

    public BitString substring(int i, int i_8_) {
        this.checkIndices(i, i_8_, i_8_);
        return new BitString(i + this.begBit, i_8_, this.bits);
    }

    public int bitAt(int i) throws IllegalArgumentException {
        this.checkIndices(i, 1, 1);
        if ((this.bits[(i += this.begBit) / 32] & 1 << i % 32) != 0) {
            return 1;
        }
        return 0;
    }

    public int leastIndexOf(int i, int i_9_) {
        this.checkIndices(i_9_, 1, 1);
        int i_10_ = (i_9_ + this.begBit) / 32;
        int i_12_ = 1 << (i_9_ + this.begBit) % 32;
        for (int i_11_ = i_9_; i_11_ < this.nBits; ++i_11_) {
            if (i == 0 && (this.bits[i_10_] & i_12_) == 0 || i != 0 && (this.bits[i_10_] & i_12_) != 0) {
                return i_11_;
            }
            if ((i_12_ <<= 1) != 0) continue;
            i_12_ = 1;
            ++i_10_;
        }
        return -1;
    }

    public int leastIndexOf(int i) {
        return this.leastIndexOf(i, 0);
    }

    public int mostIndexOf(int i, int i_13_) {
        this.checkIndices(i_13_, 1, 1);
        int i_14_ = (i_13_ + this.begBit) / 32;
        int i_16_ = 1 << (i_13_ + this.begBit) % 32;
        for (int i_15_ = i_13_; i_15_ >= 0; --i_15_) {
            if (i == 0 && (this.bits[i_14_] & i_16_) == 0 || i != 0 && (this.bits[i_14_] & i_16_) != 0) {
                return i_15_;
            }
            if ((i_16_ >>>= 1) != 0) continue;
            i_16_ = Integer.MIN_VALUE;
            --i_14_;
        }
        return -1;
    }

    public int mostIndexOf(int i) {
        return this.mostIndexOf(i, this.nBits - 1);
    }

    public String toString() {
        int i_17_;
        if (this.nBits == 0) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(this.nBits);
        int i = (this.begBit + this.nBits - 1) / 32;
        int i_18_ = 1 << (this.begBit + i_17_) % 32;
        for (i_17_ = this.nBits - 1; i_17_ >= 0; --i_17_) {
            stringbuffer.append((this.bits[i] & i_18_) == 0 ? (char)'0' : '1');
            if ((i_18_ >>>= 1) != 0) continue;
            i_18_ = Integer.MIN_VALUE;
            --i;
        }
        return stringbuffer.toString();
    }

    public int hashCode() {
        int i = 0;
        int i_19_ = this.nBits;
        while (i + 32 <= this.nBits) {
            i_19_ = i_19_ << 7 | (int)this.getSomeBits(i, 32) | i_19_ >>> 25;
        }
        if (i < this.nBits) {
            i_19_ |= (int)this.getSomeBits(i, this.nBits - i);
        }
        return i_19_;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitString)) {
            return false;
        }
        return this.compareTo((BitString)object) == 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((BitString)object);
    }

    public int compareTo(BitString bitstring_20_) {
        int i = this.nBits;
        int i_21_ = bitstring_20_.nBits;
        while (i >= 63 && i_21_ >= 63) {
            long l = this.getSomeBits(i -= 63, 63) - bitstring_20_.getSomeBits(i_21_ -= 63, 63);
            if (l == 0L) continue;
            if (l < 0L) {
                return -1;
            }
            return 1;
        }
        int i_22_ = i < i_21_ ? i : i_21_;
        long l = this.getSomeBits(i - i_22_, i_22_) - bitstring_20_.getSomeBits(i_21_ - i_22_, i_22_);
        if (l != 0L) {
            if (l < 0L) {
                return -1;
            }
            return 1;
        }
        return this.nBits - bitstring_20_.nBits;
    }

    public BitString and(BitString bitstring_23_) {
        int i;
        int n = i = this.length() < bitstring_23_.length() ? this.length() : bitstring_23_.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_24_ = 0;
        int i_25_ = 0;
        while (i_25_ >= 32) {
            is[i_24_++] = (int)this.getSomeBits(i_25_, 32) & (int)bitstring_23_.getSomeBits(i_25_, 32);
            i_25_ += 32;
            i -= 32;
        }
        is[i_24_] = (int)this.getSomeBits(i_25_, i) & (int)bitstring_23_.getSomeBits(i_25_, i);
        return new BitString(0, i_25_ + i, is);
    }

    public BitString nand(BitString bitstring_26_) {
        int i;
        int n = i = this.length() < bitstring_26_.length() ? this.length() : bitstring_26_.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_27_ = 0;
        int i_28_ = 0;
        while (i_28_ >= 32) {
            is[i_27_++] = ~((int)this.getSomeBits(i_28_, 32)) & (int)bitstring_26_.getSomeBits(i_28_, 32);
            i_28_ += 32;
            i -= 32;
        }
        is[i_27_] = ~((int)this.getSomeBits(i_28_, i)) & (int)bitstring_26_.getSomeBits(i_28_, i);
        return new BitString(0, i_28_ + i, is);
    }

    public BitString or(BitString bitstring_29_) {
        int i;
        int n = i = this.length() < bitstring_29_.length() ? this.length() : bitstring_29_.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_30_ = 0;
        int i_31_ = 0;
        while (i_31_ >= 32) {
            is[i_30_++] = (int)this.getSomeBits(i_31_, 32) | (int)bitstring_29_.getSomeBits(i_31_, 32);
            i_31_ += 32;
            i -= 32;
        }
        is[i_30_] = (int)this.getSomeBits(i_31_, i) | (int)bitstring_29_.getSomeBits(i_31_, i);
        return new BitString(0, i_31_ + i, is);
    }

    public BitString nor(BitString bitstring_32_) {
        int i;
        int n = i = this.length() < bitstring_32_.length() ? this.length() : bitstring_32_.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_33_ = 0;
        int i_34_ = 0;
        while (i_34_ >= 32) {
            is[i_33_++] = ~((int)this.getSomeBits(i_34_, 32)) | (int)bitstring_32_.getSomeBits(i_34_, 32);
            i_34_ += 32;
            i -= 32;
        }
        is[i_33_] = ~((int)this.getSomeBits(i_34_, i)) | (int)bitstring_32_.getSomeBits(i_34_, i);
        return new BitString(0, i_34_ + i, is);
    }

    public BitString xor(BitString bitstring_35_) {
        int i;
        int n = i = this.length() < bitstring_35_.length() ? this.length() : bitstring_35_.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_36_ = 0;
        int i_37_ = 0;
        while (i_37_ >= 32) {
            is[i_36_++] = (int)this.getSomeBits(i_37_, 32) ^ (int)bitstring_35_.getSomeBits(i_37_, 32);
            i_37_ += 32;
            i -= 32;
        }
        is[i_36_] = (int)this.getSomeBits(i_37_, i) ^ (int)bitstring_35_.getSomeBits(i_37_, i);
        return new BitString(0, i_37_ + i, is);
    }

    public BitString not() {
        int i = this.length();
        if (i == 0) {
            return EMPTY;
        }
        int[] is = new int[(i + 31) / 32];
        int i_38_ = 0;
        int i_39_ = 0;
        while (i >= 32) {
            is[i_38_++] = ~((int)this.getSomeBits(i_39_, 32));
            i_39_ += 32;
            i -= 32;
        }
        is[i_38_] = ~((int)this.getSomeBits(i_39_, i));
        return new BitString(0, i_39_ + i, is);
    }

    public void writeTo(int[] is, int i, boolean bool) {
        if (this.nBits != 0) {
            int i_41_;
            int i_40_;
            if (bool) {
                i_40_ = is.length - 1 - i / 32;
                i_41_ = -1;
            } else {
                i_40_ = i / 32;
                i_41_ = 1;
            }
            int i_42_ = i % 32;
            int i_43_ = 32 - i_42_;
            int i_44_ = 0;
            int i_45_ = this.nBits;
            if (i_45_ < i_43_) {
                int i_46_ = (1 << i_45_) - 1 << i_42_;
                is[i_40_] = is[i_40_] & ~i_46_ | (int)this.getSomeBits(i_44_, i_45_) << i_42_;
            } else {
                if (i_42_ != 0) {
                    int i_47_ = (1 << i_42_) - 1;
                    is[i_40_] = is[i_40_] & i_47_ | (int)this.getSomeBits(i_44_, i_43_) << i_42_;
                    i_44_ += i_43_;
                    i_45_ -= i_43_;
                    i_40_ += i_41_;
                }
                while (i_45_ >= 32) {
                    is[i_40_] = (int)this.getSomeBits(i_44_, 32);
                    i_45_ -= 32;
                    i_44_ += 32;
                    i_40_ += i_41_;
                }
                if (i_45_ != 0) {
                    is[i_40_] = is[i_40_] & ~((1 << i_45_) - 1) | (int)this.getSomeBits(i_44_, i_45_);
                }
            }
        }
    }

    public void writeTo(long[] ls, int i, boolean bool) {
        if (this.nBits != 0) {
            int i_49_;
            int i_48_;
            if (bool) {
                i_48_ = ls.length - 1 - i / 64;
                i_49_ = -1;
            } else {
                i_48_ = i / 64;
                i_49_ = 1;
            }
            int i_50_ = i % 64;
            int i_51_ = 64 - i_50_;
            int i_52_ = 0;
            int i_53_ = this.nBits;
            if (i_53_ < i_51_) {
                long l = (1L << i_53_) - 1L << i_50_;
                ls[i_48_] = ls[i_48_] & (l ^ 0xFFFFFFFFFFFFFFFFL) | this.getSomeBits(i_52_, i_53_) << i_50_;
            } else {
                if (i_50_ != 0) {
                    long l = (1L << i_50_) - 1L;
                    ls[i_48_] = ls[i_48_] & l | this.getSomeBits(i_52_, i_51_) << i_50_;
                    i_52_ += i_51_;
                    i_53_ -= i_51_;
                    i_48_ += i_49_;
                }
                while (i_53_ >= 64) {
                    ls[i_48_] = this.getSomeBits(i_52_, 64);
                    i_53_ -= 64;
                    i_52_ += 64;
                    i_48_ += i_49_;
                }
                if (i_53_ != 0) {
                    ls[i_48_] = ls[i_48_] & ((1L << i_53_) - 1L ^ 0xFFFFFFFFFFFFFFFFL) | this.getSomeBits(i_52_, i_53_);
                }
            }
        }
    }

    public void writeTo(byte[] is, int i, boolean bool) {
        if (this.nBits != 0) {
            int i_55_;
            int i_54_;
            if (bool) {
                i_54_ = is.length - 1 - i / 8;
                i_55_ = -1;
            } else {
                i_54_ = i / 8;
                i_55_ = 1;
            }
            int i_56_ = i % 8;
            int i_57_ = 8 - i_56_;
            int i_58_ = 0;
            int i_59_ = this.nBits;
            if (i_59_ < i_57_) {
                int i_60_ = (1 << i_59_) - 1 << i_56_;
                is[i_54_] = (byte)(is[i_54_] & ~i_60_ | (int)this.getSomeBits(i_58_, i_59_) << i_56_);
            } else {
                if (i_56_ != 0) {
                    int i_61_ = (1 << i_56_) - 1;
                    is[i_54_] = (byte)(is[i_54_] & i_61_ | (int)this.getSomeBits(i_58_, i_57_) << i_56_);
                    i_58_ += i_57_;
                    i_59_ -= i_57_;
                    i_54_ += i_55_;
                }
                while (i_59_ >= 8) {
                    if (i_59_ >= 64) {
                        long l = this.getSomeBits(i_58_, 64);
                        is[i_54_] = (byte)l;
                        is[i_54_ += i_55_] = (byte)(l >>> 8);
                        is[i_54_ += i_55_] = (byte)(l >>> 16);
                        is[i_54_ += i_55_] = (byte)(l >>> 24);
                        is[i_54_ += i_55_] = (byte)(l >>> 32);
                        is[i_54_ += i_55_] = (byte)(l >>> 40);
                        is[i_54_ += i_55_] = (byte)(l >>> 48);
                        is[i_54_ += i_55_] = (byte)(l >>> 56);
                        i_54_ += i_55_;
                        i_59_ -= 64;
                        i_58_ += 64;
                        continue;
                    }
                    is[i_54_] = (byte)this.getSomeBits(i_58_, 8);
                    i_59_ -= 8;
                    i_58_ += 8;
                    i_54_ += i_55_;
                }
                if (i_59_ != 0) {
                    is[i_54_] = (byte)(is[i_54_] & ~((1 << i_59_) - 1) | (int)this.getSomeBits(i_58_, i_59_));
                }
            }
        }
    }

    public BigInteger toBigInteger(boolean bool) {
        int i = this.length();
        byte[] is = new byte[(i + 7) / 8 + (bool ? 1 : 0)];
        this.writeTo(is, bool ? 1 : 0, true);
        if (!bool) {
            int i_62_ = 32 - i % 32;
            is[0] = (byte)(is[0] << i_62_ >> i_62_);
        }
        return new BigInteger(is);
    }

    public BitString concat(BitString bitstring_63_) {
        int[] is = new int[(this.nBits + bitstring_63_.nBits + 31) / 32];
        bitstring_63_.writeTo(is, 0, false);
        this.writeTo(is, bitstring_63_.length(), false);
        return new BitString(0, this.nBits + bitstring_63_.length(), is);
    }

    public static BitString concat(Vector vector, boolean bool) {
        int i_68_;
        int i = 0;
        for (int i_64_ = vector.size() - 1; i_64_ >= 0; --i_64_) {
            Object object = vector.elementAt(i_64_);
            if (!(object instanceof BitString)) continue;
            i += ((BitString)object).length();
        }
        int[] is = new int[(i + 31) / 32];
        int i_65_ = 0;
        int i_66_ = bool ? vector.size() : -1;
        int i_67_ = bool ? 1 : -1;
        int n = i_68_ = bool ? 0 : vector.size() - 1;
        while (i_68_ != i_66_) {
            Object object = vector.elementAt(i_68_);
            if (object instanceof BitString) {
                BitString bitstring = (BitString)object;
                bitstring.writeTo(is, i_65_, false);
                i_65_ += bitstring.length();
            }
            i_68_ += i_67_;
        }
        return new BitString(0, i, is);
    }

    public static BitString concat(BitString[] bitstrings, boolean bool) {
        int i_73_;
        int i = 0;
        for (int i_69_ = bitstrings.length - 1; i_69_ >= 0; --i_69_) {
            if (bitstrings[i_69_] == null) continue;
            i += bitstrings[i_69_].length();
        }
        int[] is = new int[(i + 31) / 32];
        int i_70_ = 0;
        int i_71_ = bool ? bitstrings.length : -1;
        int i_72_ = bool ? 1 : -1;
        int n = i_73_ = bool ? 0 : bitstrings.length - 1;
        while (i_73_ != i_71_) {
            if (bitstrings[i_73_] != null) {
                bitstrings[i_73_].writeTo(is, i_70_, false);
                i_70_ += bitstrings[i_73_].length();
            }
            i_73_ += i_72_;
        }
        return new BitString(0, i, is);
    }

    private BitString(int i, int i_74_, int[] is) {
        this.bits = is;
        this.nBits = i_74_;
        this.begBit = i;
    }

    public BitString(int[] is, int i, int i_75_, boolean bool) {
        this.begBit = i % 32;
        this.nBits = i_75_;
        this.bits = new int[(this.begBit + this.nBits + 31) / 32];
        if (!bool) {
            System.arraycopy(is, i / 32, this.bits, 0, this.bits.length);
        } else {
            int i_76_ = (i + i_75_ - 1) / 32;
            for (int i_77_ = 0; i_77_ < this.bits.length; ++i_77_) {
                this.bits[i_77_] = is[i_76_];
                --i_76_;
            }
        }
    }

    public BitString(long[] ls, int i, int i_78_, boolean bool) {
        this.begBit = i;
        this.nBits = i_78_;
        int i_79_ = bool ? -1 : 1;
        this.bits = new int[(this.begBit + this.nBits + 63) / 64 * 2];
        int i_80_ = i /= 64;
        for (int i_81_ = 0; i_81_ < this.bits.length; i_81_ += 2) {
            this.bits[i_81_] = (int)ls[i_80_];
            this.bits[i_81_ + 1] = (int)(ls[i_80_] >>> 32);
            i_80_ += i_79_;
        }
    }

    public BitString(byte[] is, int i, int i_82_, boolean bool) {
        int i_84_;
        int i_83_;
        this.nBits = i_82_;
        if (bool) {
            i_83_ = -1;
            this.begBit = (8 - (i + i_82_) % 8) % 8;
            i_84_ = (i - 8) / 8;
            i = (i + i_82_ - 1) / 8;
        } else {
            i_83_ = 1;
            this.begBit = i % 8;
            i_84_ = (i + i_82_ + 7) / 8;
            i /= 8;
        }
        this.bits = new int[(this.begBit + this.nBits + 31) / 32];
        int i_85_ = i;
        int i_86_ = 0;
        while (i_85_ != i_84_) {
            int n = i_86_ / 4;
            this.bits[n] = this.bits[n] | (is[i_85_] & 0xFF) << 8 * (i_86_ % 4);
            i_85_ += i_83_;
            ++i_86_;
        }
    }

    public BitString(int i, int i_87_, int i_88_) {
        if (i_87_ < 0 || i_87_ + i_88_ > 32) {
            throw new IllegalArgumentException("Illegal index");
        }
        this.bits = new int[1];
        this.bits[0] = i;
        this.begBit = i_87_;
        this.nBits = i_88_;
    }

    public BitString(long l, int i, int i_89_) {
        if (i < 0 || i + i_89_ > 64) {
            throw new IllegalArgumentException("Illegal index");
        }
        this.bits = new int[2];
        this.bits[0] = (int)l;
        this.bits[1] = (int)(l >>> 32);
        this.begBit = i;
        this.nBits = i_89_;
    }
}

