/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1;

import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.ASN1OID;
import com.sap.idm.vds.asn1.ASN1Tag;
import com.sap.idm.vds.asn1.BERConstants;
import com.sap.idm.vds.asn1.util.BitString;
import java.math.BigInteger;
import java.util.Calendar;

public abstract class BaseBEREncoder
extends ASN1Encoder
implements BERConstants {
    protected boolean specialTag;
    protected int implicitTag;

    protected abstract void putOctet(int var1) throws ASN1Exception;

    protected abstract void putOctets(byte[] var1, int var2, int var3) throws ASN1Exception;

    protected void encodeTagAndLength(boolean bool, int i, int i_1_) throws ASN1Exception {
        this.encodeTag(bool, i);
        this.encodeLength(i_1_);
    }

    protected int encodeTag(boolean bool, int i) throws ASN1Exception {
        if (this.specialTag) {
            i = this.implicitTag;
            this.specialTag = false;
        }
        int i_2_ = ASN1Tag.getTagNumber(i);
        int i_3_ = bool ? 32 : 0;
        switch (ASN1Tag.getTagClass(i)) {
            case 0: {
                i_3_ |= 0;
                break;
            }
            case 1: {
                i_3_ |= 0x40;
                break;
            }
            case 2: {
                i_3_ |= 0x80;
                break;
            }
            case 3: {
                i_3_ |= 0xC0;
            }
        }
        if (i_2_ > 30) {
            this.putOctet(i_3_ | 0x1F);
            if (i_2_ >= 0x10000000) {
                this.putOctet(i_2_ >>> 28 | 0x80);
            }
            if (i_2_ >= 0x200000) {
                this.putOctet(i_2_ >>> 21 | 0x80);
            }
            if (i_2_ >= 16384) {
                this.putOctet(i_2_ >>> 14 | 0x80);
            }
            if (i_2_ >= 128) {
                this.putOctet(i_2_ >>> 7 | 0x80);
            }
            this.putOctet(i_2_ & 0x7F);
        } else {
            this.putOctet(i_3_ | i_2_);
        }
        return 0;
    }

    protected void encodeLength(int i) throws ASN1Exception {
        if (i >= 128) {
            int i_4_ = i >= 0x1000000 ? 4 : (i >= 65536 ? 3 : (i >= 256 ? 2 : 1));
            this.putOctet(0x80 | i_4_);
            for (int i_5_ = (i_4_ - 1) * 8; i_5_ >= 0; i_5_ -= 8) {
                this.putOctet(i >> i_5_);
            }
        } else {
            this.putOctet(i);
        }
    }

    public void encodeBoolean(boolean bool) throws ASN1Exception {
        this.encodeTagAndLength(false, 1, 1);
        this.putOctet(bool ? 255 : 0);
    }

    public void encodeInteger(int i) throws ASN1Exception {
        int i_6_ = i >= 0 ? (i >= 0x800000 ? 4 : (i >= 32768 ? 3 : (i >= 128 ? 2 : 1))) : (i < -8388608 ? 4 : (i < Short.MIN_VALUE ? 3 : (i < -128 ? 2 : 1)));
        this.encodeTag(false, 2);
        this.encodeLength(i_6_);
        for (int i_7_ = (i_6_ - 1) * 8; i_7_ >= 0; i_7_ -= 8) {
            this.putOctet((byte)(i >> i_7_));
        }
    }

    public void encodeInteger(long l) throws ASN1Exception {
        int i = l >= 0L ? (l >= 0x80000000000000L ? 8 : (l >= 0x800000000000L ? 7 : (l >= 0x8000000000L ? 6 : (l >= 0x80000000L ? 5 : (l >= 0x800000L ? 4 : (l >= 32768L ? 3 : (l >= 128L ? 2 : 1))))))) : (l < -36028797018963968L ? 8 : (l < -140737488355328L ? 7 : (l < -549755813888L ? 6 : (l < Integer.MIN_VALUE ? 5 : (l < -8388608L ? 4 : (l < -32768L ? 3 : (l < -128L ? 2 : 1)))))));
        this.encodeTag(false, 2);
        this.encodeLength(i);
        for (int i_8_ = (i - 1) * 8; i_8_ >= 0; i_8_ -= 8) {
            this.putOctet((byte)(l >> i_8_));
        }
    }

    public void encodeInteger(BigInteger biginteger) throws ASN1Exception {
        byte[] is = biginteger.toByteArray();
        this.encodeTag(false, 2);
        this.encodeLength(is.length);
        this.putOctets(is, 0, is.length);
    }

    public void encodeEnumeration(int i) throws ASN1Exception {
        this.nextIsImplicit(10);
        this.encodeInteger(i);
    }

    public void encodeReal(double d) throws ASN1Exception {
        throw new Error("Real encoding, not implemented");
    }

    public void encodeNull() throws ASN1Exception {
        this.encodeTag(false, 5);
        this.encodeLength(0);
    }

    protected void encodeStringValue(String string) throws ASN1Exception {
        int i_9_ = string.length();
        for (int i = 0; i < i_9_; ++i) {
            this.putOctet(string.charAt(i));
        }
    }

    public void encodeUTCTime(String string) throws ASN1Exception {
        this.encodeTag(false, 23);
        this.encodeLength(string.length());
        this.encodeStringValue(string);
    }

    private final void encode2DecimalDigits(int i) throws ASN1Exception {
        this.putOctet(i / 10 % 10 + 48);
        this.putOctet(i % 10 + 48);
    }

    public void encodeUTCTime(Calendar calendar) throws ASN1Exception {
        this.encodeTag(false, 23);
        int i = calendar.get(15) / 1000;
        if (i != 0) {
            this.encodeLength(17);
        } else {
            this.encodeLength(13);
        }
        int i_10_ = calendar.get(1);
        this.encode2DecimalDigits(i_10_ >= 2000 ? i_10_ - 2000 : i_10_ - 1900);
        this.encode2DecimalDigits(calendar.get(2) + 1);
        this.encode2DecimalDigits(calendar.get(5));
        this.encode2DecimalDigits(calendar.get(11));
        this.encode2DecimalDigits(calendar.get(12));
        this.encode2DecimalDigits(calendar.get(13));
        if (i == 0) {
            this.putOctet(90);
        } else if (i < 0) {
            this.putOctet(45);
            this.encode2DecimalDigits(-i / 60);
            this.encode2DecimalDigits(-i % 60);
        } else {
            this.putOctet(43);
            this.encode2DecimalDigits(i / 60);
            this.encode2DecimalDigits(i % 60);
        }
    }

    public void encodeGeneralizedTime(Calendar calendar) throws ASN1Exception {
        int i = calendar.get(14);
        int i_11_ = calendar.get(15) / 1000;
        int i_12_ = 14 + (i == 0 ? 0 : (i < 10 ? 2 : (i < 100 ? 3 : 4))) + (i_11_ != 0 ? 5 : 1);
        this.encodeTag(false, 24);
        this.encodeLength(i_12_);
        int i_13_ = calendar.get(1);
        this.encode2DecimalDigits(i_13_ / 100);
        this.encode2DecimalDigits(i_13_ % 100);
        this.encode2DecimalDigits(calendar.get(2) + 1);
        this.encode2DecimalDigits(calendar.get(5));
        this.encode2DecimalDigits(calendar.get(11));
        this.encode2DecimalDigits(calendar.get(12));
        this.encode2DecimalDigits(calendar.get(13));
        if (i != 0) {
            this.putOctet(46);
            switch (i_12_) {
                case 19: {
                    this.putOctet(i / 100 % 10 + 48);
                }
                case 18: {
                    this.putOctet(i / 10 % 10 + 48);
                }
                case 17: {
                    this.putOctet(i % 10 + 48);
                }
            }
        }
        if (i_11_ == 0) {
            this.putOctet(90);
        } else if (i_11_ > 0) {
            this.putOctet(43);
            this.encode2DecimalDigits(i_11_ / 60);
            this.encode2DecimalDigits(i_11_ % 60);
        } else {
            this.putOctet(45);
            this.encode2DecimalDigits(-i_11_ / 60);
            this.encode2DecimalDigits(-i_11_ % 60);
        }
    }

    public void encodeGeneralizedTime(String string) throws ASN1Exception {
        this.encodeTag(false, 24);
        this.encodeLength(string.length());
        this.encodeStringValue(string);
    }

    public void encodeObjectIdentifier(ASN1OID asn1oid) throws ASN1Exception {
        int i_14_;
        int i = 1;
        int i_15_ = asn1oid.level();
        for (i_14_ = 2; i_14_ < i_15_; ++i_14_) {
            int i_16_ = asn1oid.nthComponent(i_14_);
            if (i_16_ >= 0x10000000) {
                i += 5;
                continue;
            }
            if (i_16_ >= 0x200000) {
                i += 4;
                continue;
            }
            if (i_16_ >= 16384) {
                i += 3;
                continue;
            }
            if (i_16_ >= 128) {
                i += 2;
                continue;
            }
            ++i;
        }
        this.encodeTagAndLength(false, 6, i);
        this.encodeLength(asn1oid.nthComponent(0) * 40 + asn1oid.nthComponent(1));
        int i_17_ = asn1oid.level();
        for (i_14_ = 2; i_14_ < i_17_; ++i_14_) {
            int i_18_ = asn1oid.nthComponent(i_14_);
            if (i_18_ >= 0x10000000) {
                this.putOctet(i_18_ >>> 28 | 0x80);
            }
            if (i_18_ >= 0x200000) {
                this.putOctet(i_18_ >>> 21 | 0x80);
            }
            if (i_18_ >= 16384) {
                this.putOctet(i_18_ >>> 14 | 0x80);
            }
            if (i_18_ >= 128) {
                this.putOctet(i_18_ >>> 7 | 0x80);
            }
            this.putOctet(i_18_ & 0x7F);
        }
    }

    public void encodeOctetString(byte[] is, int i, int i_19_) throws ASN1Exception {
        this.encodeTagAndLength(false, 4, i_19_);
        for (int i_20_ = 0; i_20_ < i_19_; ++i_20_) {
            this.putOctet(is[i_20_]);
        }
    }

    public void encodeBitString(BitString bitstring) throws ASN1Exception {
        int i = bitstring.length();
        int i_21_ = 8 - (i & 7) & 7;
        this.encodeTagAndLength(false, 3, i + 15 >> 3);
        this.putOctet(i_21_);
        i -= 8;
        while (i >= 0) {
            this.putOctet(bitstring.toInt(i, 8));
            i -= 8;
        }
        if (i != -8) {
            this.putOctet((byte)(bitstring.toInt(0, 8 - i_21_) << i_21_));
        }
    }

    public void encodePrintableString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 19, i);
        this.encodeStringValue(string);
    }

    public void encodeT61String(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 20, i);
        this.encodeStringValue(string);
    }

    public void encodeVideotexString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 21, i);
        this.encodeStringValue(string);
    }

    public void encodeIA5String(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 22, i);
        this.encodeStringValue(string);
    }

    public void encodeNumericString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 18, i);
        this.encodeStringValue(string);
    }

    public void encodeGraphicString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 25, i);
        this.encodeStringValue(string);
    }

    public void encodeVisibleString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 26, i);
        this.encodeStringValue(string);
    }

    public void encodeGeneralString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 27, i);
        this.encodeStringValue(string);
    }

    public void encodeBMPString(String string) throws ASN1Exception {
        int i = string.length();
        this.encodeTagAndLength(false, 30, 2 * i);
        for (int i_22_ = 0; i_22_ < i; ++i_22_) {
            char i_23_ = string.charAt(i_22_);
            this.putOctet(i_23_ >> 8);
            this.putOctet(i_23_);
        }
    }

    public int encodeSequenceOf() throws ASN1Exception {
        return this.encodeSequence();
    }

    public int encodeSetOf() throws ASN1Exception {
        return this.encodeSet();
    }

    public void encodeChoice(int i, int[] is) {
    }

    public void nextIsImplicit(int i) {
        this.specialTag = true;
        this.implicitTag = i;
    }

    public boolean encodeDefault() {
        return true;
    }

    public void nextHasSizeConstraints(long l, long l_24_) {
    }

    public void nextHasAlphabetConstraint(String string) {
    }
}

