/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1;

import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.BaseBEREncoder;
import com.sap.idm.vds.asn1.EncBuf;
import com.sap.idm.vds.asn1.EncPos;
import com.sap.idm.vds.asn1.EncPosTable;
import java.io.IOException;
import java.io.OutputStream;

public class BEREncoder
extends BaseBEREncoder {
    public static final String RULES_NAME = "BER";
    protected EncBuf firstBuf;
    protected EncBuf currBuf;
    protected int currBufPos;
    protected int offset;
    protected EncPosTable firstTable;
    protected EncPosTable currTable;
    protected EncPos currPos;
    protected EncPos parentPos;
    protected int tableIndex;

    protected void setToPos(int i) {
        int i_0_;
        boolean bool = false;
        if (this.offset > i) {
            this.currBuf = this.firstBuf;
            i_0_ = 0;
            this.currBufPos = 0;
        } else {
            i_0_ = this.offset - this.currBufPos;
        }
        while (true) {
            int i_1_;
            if (i_0_ + (i_1_ = this.currBuf.data.length) > i) break;
            i_0_ += i_1_;
            this.currBuf = this.currBuf.next;
        }
        this.currBufPos = i - i_0_;
        this.offset = i;
    }

    protected int writeBlock(OutputStream outputstream, byte[] is, int i, int i_2_, int i_3_) throws IOException {
        this.setToPos(i_2_);
        while (i_3_ > 0) {
            int i_4_ = this.currBuf.data.length - this.currBufPos;
            if (i_4_ > i_3_) {
                i_4_ = i_3_;
            }
            if (outputstream != null) {
                outputstream.write(this.currBuf.data, this.currBufPos, i_4_);
            } else {
                System.arraycopy(this.currBuf.data, this.currBufPos, is, i, i_4_);
                i += i_4_;
            }
            if ((this.currBufPos += i_4_) >= this.currBuf.data.length) {
                this.currBufPos = 0;
                this.currBuf = this.currBuf.next;
            }
            i_3_ -= i_4_;
            this.offset += i_4_;
        }
        return i;
    }

    protected int nContiguousBytes(int i) {
        int i_5_ = this.currBuf.data.length - this.currBufPos;
        if (i > i_5_) {
            this.offset += i_5_;
            if (this.currBuf.next == null) {
                this.currBuf.next = new EncBuf(this.currBuf);
            }
            this.currBuf = this.currBuf.next;
            this.currBufPos = 0;
        }
        this.currBufPos += i;
        this.offset += i;
        return this.offset - i;
    }

    protected void putOctet(int i) {
        if (this.currBufPos >= this.currBuf.data.length) {
            if (this.currBuf.next == null) {
                this.currBuf.next = new EncBuf(this.currBuf);
            }
            this.currBuf = this.currBuf.next;
            this.currBufPos = 0;
        }
        this.currBuf.data[this.currBufPos++] = (byte)i;
        ++this.offset;
    }

    protected void putOctets(byte[] is, int i, int i_6_) {
        int i_8_;
        int i_7_ = this.currBuf.data.length - this.currBufPos;
        this.offset += i_6_;
        int n = i_8_ = i_6_ > i_7_ ? i_7_ : i_6_;
        while (i_6_ > i_7_) {
            System.arraycopy(is, i, this.currBuf.data, this.currBufPos, i_7_);
            i_6_ -= i_7_;
            i += i_7_;
            if (this.currBuf.next == null) {
                this.currBuf.next = new EncBuf(this.currBuf);
            }
            this.currBuf = this.currBuf.next;
            this.currBufPos = 0;
            i_7_ = this.currBuf.data.length;
        }
        if (i_6_ > 0) {
            System.arraycopy(is, i, this.currBuf.data, this.currBufPos, i_6_);
            this.currBufPos += i_6_;
        }
    }

    private void newCurrPos() {
        if (this.tableIndex >= this.currTable.table.length) {
            if (this.currTable.next == null) {
                EncPosTable encpostable = new EncPosTable();
                encpostable.table = new EncPos[this.currTable.table.length];
                this.currTable.next = encpostable;
            }
            this.currTable = this.currTable.next;
            this.tableIndex = 0;
        }
        if ((this.currPos = this.currTable.table[this.tableIndex++]) == null) {
            EncPos encPos = new EncPos();
            this.currTable.table[this.tableIndex - 1] = encPos;
            this.currPos = encPos;
        } else {
            this.currPos.init();
        }
    }

    protected int encodeTag(boolean bool, int i) throws ASN1Exception {
        this.parentPos.oneMoreChild();
        if (this.currPos.isPrimitive() && this.currPos.length == 0) {
            this.currPos.length = this.offset - this.currPos.offset;
            this.parentPos.length += this.currPos.length;
        }
        this.newCurrPos();
        this.currPos.parent = this.parentPos;
        this.currPos.setTag(i, this.specialTag ? this.implicitTag : -1);
        if (bool) {
            this.currPos.offset = this.nContiguousBytes(10);
            this.specialTag = false;
            this.parentPos = this.currPos;
        } else {
            this.currPos.offset = this.offset;
            this.currPos.setPrimitive();
            if (i != 0) {
                super.encodeTag(false, i);
            }
        }
        return this.currPos.offset;
    }

    protected void endOfConstructed(int i) throws ASN1Exception {
        if (this.parentPos == this.firstTable.table[0] || i != this.parentPos.offset) {
            throw new ASN1Exception("Mismatch of terminations");
        }
        if (this.currPos.isPrimitive() && this.currPos.length == 0) {
            this.currPos.length = this.offset - this.currPos.offset;
            this.parentPos.length += this.currPos.length;
        }
        EncBuf encbuf = this.currBuf;
        int i_9_ = this.currBufPos;
        int i_10_ = this.offset;
        this.setToPos(this.parentPos.offset);
        super.encodeTag(true, this.parentPos.getEncodedTag());
        super.encodeLength(this.parentPos.length);
        int i_11_ = this.offset - this.parentPos.offset;
        this.parentPos.setTLLength(i_11_);
        this.parentPos.parent.length += i_11_ + this.parentPos.length;
        this.parentPos = this.parentPos.parent;
        this.currBuf = encbuf;
        this.currBufPos = i_9_;
        this.offset = i_10_;
    }

    public void init() {
        this.parentPos = this.firstTable.table[0];
        this.parentPos.offset = 0;
        this.parentPos.parent = null;
        this.currPos = this.parentPos;
        this.currBuf = this.firstBuf;
        this.currTable = this.firstTable;
        this.tableIndex = 1;
        this.offset = 0;
        this.currBufPos = 0;
        this.specialTag = false;
    }

    public String toString() {
        return RULES_NAME;
    }

    public BEREncoder() {
        this(1024, 64);
    }

    public BEREncoder(int i, int i_12_) {
        if (i < 32) {
            i = 32;
        }
        if (i_12_ < 16) {
            i_12_ = 16;
        }
        this.firstTable = new EncPosTable();
        this.firstTable.table = new EncPos[i_12_];
        this.firstBuf = new EncBuf(i);
        this.firstTable.table[0] = new EncPos();
        this.init();
    }

    public void finish() throws ASN1Exception {
        if (this.parentPos != this.firstTable.table[0]) {
            throw new ASN1Exception("finish encodings");
        }
        if (this.currPos.isPrimitive() && this.currPos.length == 0) {
            this.currPos.length = this.offset - this.currPos.offset;
            this.parentPos.length += this.currPos.length;
        }
    }

    public int codeLength() {
        return this.firstTable.table[0].length;
    }

    public byte[] toByteArray() throws ASN1Exception {
        try {
            this.finish();
            byte[] is = new byte[this.firstTable.table[0].length];
            this.writeTo(null, is, 0);
            return is;
        }
        catch (IOException ioexception) {
            throw new Error("Failed constructing byte array");
        }
    }

    public int toByteArray(byte[] is, int i) throws ASN1Exception {
        try {
            return this.writeTo(null, is, i) - i;
        }
        catch (IOException ioexception) {
            throw new Error("Failed constructing byte_array");
        }
    }

    public int writeTo(OutputStream outputstream) throws ASN1Exception, IOException {
        return this.writeTo(outputstream, null, 0);
    }

    protected int writeTo(OutputStream outputstream, byte[] is, int i) throws ASN1Exception, IOException {
        this.finish();
        EncPosTable encpostable = this.currTable;
        int i_13_ = this.tableIndex;
        this.currTable = this.firstTable;
        this.tableIndex = 0;
        while (++this.tableIndex < i_13_ || this.currTable != encpostable) {
            if (this.tableIndex >= this.currTable.table.length) {
                this.currTable = this.currTable.next;
                this.tableIndex = -1;
                continue;
            }
            EncPos encpos = this.currTable.table[this.tableIndex];
            if (encpos.isPrimitive()) {
                i = this.writeBlock(outputstream, is, i, encpos.offset, encpos.length);
                continue;
            }
            i = this.writeBlock(outputstream, is, i, encpos.offset, encpos.getTLLength());
        }
        return i;
    }

    public void encodeAny(byte[] is, int i, int i_14_) throws ASN1Exception {
        this.encodeTag(false, 0);
        this.putOctets(is, i, i_14_);
    }

    public int encodeExplicit(int i) throws ASN1Exception {
        return this.encodeTag(true, i);
    }

    public int encodeConstructedString(int i) throws ASN1Exception {
        return this.encodeTag(true, i);
    }

    public int encodeSequence() throws ASN1Exception {
        return this.encodeTag(true, 16);
    }

    public int encodeSet() throws ASN1Exception {
        return this.encodeTag(true, 17);
    }

    public void endOf(int i) throws ASN1Exception {
        this.endOfConstructed(i);
    }

    public void debug() {
        System.err.println("currBuf:    " + this.currBuf);
        System.err.println("currBufPos: " + this.currBufPos);
        System.err.println("offset:     " + this.offset);
        System.err.println("currTable:  " + this.currTable);
        System.err.println("currPos:    " + this.currPos);
        System.err.println("parentPos:  " + this.parentPos);
        System.err.println("tableIndex: " + this.tableIndex);
    }
}

