/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.asn1;

import com.sap.idm.vds.asn1.ASN1Any;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.ASN1OID;
import com.sap.idm.vds.asn1.ASN1Tag;
import com.sap.idm.vds.asn1.BERAny;
import com.sap.idm.vds.asn1.BERConstants;
import com.sap.idm.vds.asn1.DecStack;
import com.sap.idm.vds.asn1.util.BitString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class BERDecoder
extends ASN1Decoder
implements BERConstants {
    protected InputStream input;
    protected DecStack currStack;
    protected int stackIndex;
    protected int stackPos;
    protected int readOctets;
    protected boolean pushedBack;
    protected int implicitTag;
    protected int tag;
    protected boolean constructed;
    protected int valueLength;
    protected int tlbIndex;
    protected byte[] tagLenBuf;
    private static final TimeZone GMT_ZONE = new SimpleTimeZone(0, "GMT");
    private int[] idlist = new int[64];
    private int octetStringLength;
    private byte[] octetStringByteArray;

    protected void throwASN1Exception(String string) throws ASN1Exception {
        throw new ASN1Exception(string + " (offset " + this.readOctets + ")");
    }

    protected int getOctet() throws ASN1Exception {
        try {
            int i = this.input.read();
            if (i < 0) {
                throw new ASN1Exception("Unexpected end of input");
            }
            ++this.readOctets;
            return i;
        }
        catch (IOException ioexception) {
            throw new ASN1Exception(" (VDS interrupted) " + ioexception.getMessage());
        }
    }

    protected final void pushBack() {
        this.pushedBack = true;
    }

    protected boolean decodeTagAndLength() throws ASN1Exception {
        long l;
        if (this.pushedBack) {
            this.pushedBack = false;
            return true;
        }
        int i = this.currStack.stack[this.stackIndex];
        if (i >= 0 && this.readOctets >= i || this.tag == 0) {
            return false;
        }
        int i_0_ = 0;
        int i_1_ = this.getOctet();
        this.constructed = (i_1_ & 0x20) != 0;
        this.tlbIndex = 1;
        this.tagLenBuf[0] = (byte)i_1_;
        switch (i_1_ & 0xC0) {
            case 0: {
                i_0_ = 0;
                break;
            }
            case 64: {
                i_0_ = 1;
                break;
            }
            case 128: {
                i_0_ = 2;
                break;
            }
            case 192: {
                i_0_ = 3;
            }
        }
        this.tag = i_1_ & 0x1F;
        if (this.tag == 31) {
            l = 0L;
            do {
                i_1_ = this.getOctet();
                this.tagLenBuf[this.tlbIndex++] = (byte)i_1_;
                if ((l = (l << 7) + (long)(i_1_ & 0x7F)) <= 0x3FFFFFFFL) continue;
                this.throwASN1Exception("Invalid tag number");
            } while ((i_1_ & 0x80) != 0);
            this.tag = (int)l;
        }
        this.tag = ASN1Tag.makeTag(i_0_, this.tag);
        this.valueLength = this.getOctet();
        this.tagLenBuf[this.tlbIndex++] = (byte)this.valueLength;
        if (this.valueLength >= 128) {
            if (this.valueLength == 128) {
                this.valueLength = -1;
                return true;
            }
            l = 0L;
            for (int i_2_ = this.valueLength & 0x7F; i_2_ > 0; --i_2_) {
                i_1_ = this.getOctet();
                this.tagLenBuf[this.tlbIndex++] = (byte)i_1_;
                if ((l = l << 8 | (long)i_1_) < 0x80000000L) continue;
                this.throwASN1Exception("Invalid length");
            }
            this.valueLength = (int)l;
        }
        return this.tag != 0;
    }

    protected void push(int i) {
        if ((this.stackIndex += 2) >= this.currStack.stack.length) {
            if (this.currStack.next == null) {
                DecStack decstack = this.currStack.next = new DecStack();
                decstack.prev = this.currStack;
                decstack.next = null;
                decstack.stack = new int[this.currStack.stack.length];
            }
            this.currStack = this.currStack.next;
            this.stackIndex = 0;
        }
        this.currStack.stack[this.stackIndex] = this.valueLength >= 0 ? this.readOctets + this.valueLength : -1;
        this.currStack.stack[this.stackIndex + 1] = i;
        ++this.stackPos;
    }

    protected void pop() throws ASN1Exception {
        int i = this.currStack.stack[this.stackIndex];
        if (i >= 0 && i != this.readOctets || i < 0 && this.tag != 0) {
            this.throwASN1Exception("Unable to consume octet");
        }
        if ((this.stackIndex -= 2) < 0) {
            this.currStack = this.currStack.prev;
            this.stackIndex = this.currStack.stack.length - 2;
        }
        this.tag = -1;
        --this.stackPos;
    }

    public InputStream setInputStream(InputStream inputstream) {
        InputStream inputstream_3_ = this.input;
        this.input = inputstream;
        this.pushedBack = false;
        this.readOctets = 0;
        while (this.currStack.prev != null) {
            this.currStack = this.currStack.prev;
        }
        this.currStack.stack[0] = -1;
        this.currStack.stack[1] = 16;
        this.stackPos = 0;
        this.stackIndex = 0;
        this.tag = 16;
        this.implicitTag = 0;
        return inputstream_3_;
    }

    public String toString() {
        return "BER";
    }

    public BERDecoder(byte[] is, int i, int i_4_) {
        this(new ByteArrayInputStream(is, i, i_4_));
    }

    public BERDecoder(byte[] is) {
        this(new ByteArrayInputStream(is));
    }

    public BERDecoder(InputStream inputstream) {
        this(inputstream, 32);
    }

    public BERDecoder(InputStream inputstream, int i) {
        this.currStack = new DecStack();
        this.currStack.next = null;
        this.currStack.prev = null;
        this.currStack.stack = new int[2 * i];
        this.tagLenBuf = new byte[32];
        this.setInputStream(inputstream);
    }

    private final int expectedTag() {
        if (this.implicitTag != 0) {
            return this.implicitTag;
        }
        return this.tag;
    }

    protected void checkNextTag(int i) throws ASN1Exception {
        if (!this.decodeTagAndLength()) {
            this.throwASN1Exception("Expected more tags");
        }
        if (this.implicitTag != 0) {
            if (this.implicitTag != this.tag) {
                this.throwASN1Exception("Read tag " + ASN1Tag.tagToString(this.tag) + " but expected (implicit) " + ASN1Tag.tagToString(this.implicitTag) + " / original data tag " + ASN1Tag.tagToString(i));
            }
        } else if (this.tag != i) {
            this.throwASN1Exception("Read tag " + ASN1Tag.tagToString(this.tag) + " but expected " + ASN1Tag.tagToString(i));
        }
        if (!this.constructed || ASN1Tag.getTagClass(i) == 0 && !ASN1Tag.isUniversalStringTag(i)) {
            this.implicitTag = 0;
        }
        if (this.constructed) {
            this.push(i);
        }
    }

    protected void decodeStringContents(StringBuffer stringbuffer, int i, boolean bool) throws ASN1Exception {
        int i_5_;
        if (this.constructed) {
            while (this.decodeTagAndLength()) {
                if (this.constructed) {
                    this.push(this.tag);
                }
                this.decodeStringContents(stringbuffer, i, bool);
            }
            this.pop();
        } else if (bool) {
            for (i_5_ = this.valueLength; i_5_ >= 2; i_5_ -= 2) {
                stringbuffer.append((char)(this.getOctet() << 8 | this.getOctet() & 0xFF));
            }
            if (i_5_ > 0) {
                this.getOctet();
            }
        } else {
            while (i_5_-- > 0) {
                stringbuffer.append((char)this.getOctet());
            }
        }
    }

    protected String decodeString(boolean bool) throws ASN1Exception {
        StringBuffer stringbuffer = this.valueLength > 0 ? new StringBuffer(this.valueLength / (bool ? 2 : 1)) : new StringBuffer();
        this.decodeStringContents(stringbuffer, this.expectedTag(), bool);
        return stringbuffer.toString();
    }

    public int getTLVOffset() throws ASN1Exception {
        this.peekNextTag();
        return this.readOctets - this.tlbIndex;
    }

    public int getTLVLength() throws ASN1Exception {
        this.peekNextTag();
        return this.tlbIndex + this.valueLength;
    }

    public int getValueOffset() throws ASN1Exception {
        this.peekNextTag();
        return this.readOctets;
    }

    public int getValueLength() throws ASN1Exception {
        this.peekNextTag();
        return this.valueLength;
    }

    public int getTLLength() throws ASN1Exception {
        this.peekNextTag();
        return this.tlbIndex;
    }

    public int peekNextTag() throws ASN1Exception {
        if (!this.decodeTagAndLength()) {
            return 0;
        }
        this.pushBack();
        return this.tag;
    }

    public int peekNextValueLength() throws ASN1Exception {
        if (this.pushedBack) {
            return this.valueLength;
        }
        if (!this.decodeTagAndLength()) {
            return -1;
        }
        this.pushBack();
        return this.valueLength;
    }

    public boolean nextTagConstructed() throws ASN1Exception {
        if (!this.decodeTagAndLength()) {
            return false;
        }
        this.pushBack();
        return this.constructed;
    }

    public void nextIsImplicit(int i) {
        this.implicitTag = i;
    }

    public int decodeExplicit(int i) throws ASN1Exception {
        this.checkNextTag(i);
        return this.stackPos;
    }

    public boolean decodeBoolean() throws ASN1Exception {
        this.checkNextTag(1);
        return this.getOctet() != 0;
    }

    public int decodeIntegerAsInt() throws ASN1Exception {
        this.checkNextTag(2);
        int i = this.valueLength;
        int i_6_ = (4 - i) * 8;
        int i_7_ = 0;
        while (i-- > 0) {
            i_7_ = (i_7_ << 8) + this.getOctet();
        }
        if (i_6_ < 0) {
            i_6_ = 0;
        }
        return i_7_ << i_6_ >> i_6_;
    }

    public long decodeIntegerAsLong() throws ASN1Exception {
        this.checkNextTag(2);
        int i = this.valueLength;
        int i_8_ = (8 - i) * 8;
        long l = 0L;
        while (i-- > 0) {
            l = (l << 8) + (long)this.getOctet();
        }
        if (i_8_ < 0) {
            i_8_ = 0;
        }
        return l << i_8_ >> i_8_;
    }

    public BigInteger decodeInteger() throws ASN1Exception {
        this.checkNextTag(2);
        byte[] is = new byte[this.valueLength];
        for (int i = 0; i < this.valueLength; ++i) {
            is[i] = (byte)this.getOctet();
        }
        return new BigInteger(is);
    }

    public int decodeEnumeration() throws ASN1Exception {
        this.nextIsImplicit(10);
        return this.decodeIntegerAsInt();
    }

    public double decodeReal() throws ASN1Exception {
        throw new Error("Real decoding, not implemented");
    }

    public void decodeNull() throws ASN1Exception {
        this.checkNextTag(5);
        while (this.valueLength-- > 0) {
            this.getOctet();
        }
    }

    private final int get2AsciiDigits(String string, int i) throws ASN1Exception {
        char c = '\u0000';
        char c_9_ = '\u0000';
        if (i + 2 <= string.length()) {
            c = string.charAt(i);
            c_9_ = string.charAt(i + 1);
        }
        if (c < '0' || c > '9' || c_9_ < '0' || c_9_ > '9') {
            this.throwASN1Exception("Invalid time format, expected digits but got " + c + c_9_);
        }
        return (c - 48) * 10 + (c_9_ - 48);
    }

    private static TimeZone makeTimeZone(int i) {
        TimeZone timezone;
        Object object = null;
        String[] strings = TimeZone.getAvailableIDs(i);
        if (strings == null || strings.length == 0 || !(timezone = TimeZone.getTimeZone(strings[0])).getID().equals(strings[0])) {
            timezone = i == 0 ? GMT_ZONE : new SimpleTimeZone(i, "???");
        }
        return timezone;
    }

    public Calendar decodeGeneralizedTime() throws ASN1Exception {
        int i = 0;
        int i_10_ = 0;
        int i_11_ = 14;
        this.checkNextTag(24);
        String string = this.decodeString(false);
        int i_12_ = this.get2AsciiDigits(string, 0) * 100 + this.get2AsciiDigits(string, 2);
        int i_13_ = this.get2AsciiDigits(string, 4);
        int i_14_ = this.get2AsciiDigits(string, 6);
        int i_15_ = this.get2AsciiDigits(string, 8);
        int i_16_ = this.get2AsciiDigits(string, 10);
        int i_17_ = this.get2AsciiDigits(string, 12);
        if (string.charAt(14) == '.' || string.charAt(14) == ',') {
            char i_18_;
            while ((i_18_ = string.charAt(i_11_)) >= '0' && i_18_ <= '9') {
                i_10_ = i_10_ * 10 + i_18_ - 48;
                ++i_11_;
            }
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        if (string.length() > i_11_) {
            char c = string.charAt(i_11_);
            if (string.length() == i_11_ + 1 && c == 'Z') {
                i = 0;
            } else if (c == '-' || c == '+') {
                int i_19_ = c == '-' ? -1 : 1;
                i = this.get2AsciiDigits(string, i_11_ + 1) * i_19_ * 60 + this.get2AsciiDigits(string, i_11_ + 3) * i_19_ * 1000;
            } else {
                throw new ASN1Exception("Invalid GeneralizedTime - missing Z or time zone");
            }
        }
        gregoriancalendar.set(i_12_, i_13_ - 1, i_14_, i_15_, i_16_, i_17_);
        gregoriancalendar.set(14, i_10_);
        gregoriancalendar.setTimeZone(BERDecoder.makeTimeZone(i));
        return gregoriancalendar;
    }

    public Calendar decodeUTCTime() throws ASN1Exception {
        int i = 0;
        int i_20_ = 0;
        int i_21_ = 10;
        this.checkNextTag(23);
        String string = this.decodeString(false);
        int i_22_ = this.get2AsciiDigits(string, 0);
        int i_23_ = this.get2AsciiDigits(string, 2);
        int i_24_ = this.get2AsciiDigits(string, 4);
        int i_25_ = this.get2AsciiDigits(string, 6);
        int i_26_ = this.get2AsciiDigits(string, 8);
        i_22_ = i_22_ < 50 ? 2000 + i_22_ : 1900 + i_22_;
        char c = string.charAt(10);
        if (c >= '0' && c <= '9') {
            i_20_ = this.get2AsciiDigits(string, 10);
            i_21_ = 12;
        }
        if ((c = string.charAt(i_21_)) == '+' || c == '-') {
            int i_27_ = c == '-' ? -1 : 1;
            i = this.get2AsciiDigits(string, i_21_ + 1) * i_27_ * 60 + this.get2AsciiDigits(string, i_21_ + 3) * i_27_ * 1000;
        } else if (c != 'Z') {
            this.throwASN1Exception("UTC time fail, no trailing Z");
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar(i_22_, i_23_ - 1, i_24_, i_25_, i_26_, i_20_);
        gregoriancalendar.setTimeZone(BERDecoder.makeTimeZone(i));
        return gregoriancalendar;
    }

    protected int decodeBitStringContents(int i, byte[] is, int i_28_) throws ASN1Exception {
        if (this.constructed) {
            while (this.decodeTagAndLength()) {
                if (this.constructed) {
                    this.push(this.tag);
                }
                i_28_ = this.decodeBitStringContents(i, is, i_28_);
            }
            this.pop();
        } else {
            int i_29_ = this.valueLength * 8 - 8 - this.getOctet();
            int i_30_ = i_28_ / 8;
            int i_31_ = is[i_30_];
            int i_32_ = i_28_ % 8;
            while (i_29_ > 0) {
                i_31_ = i_31_ << 8 | this.getOctet();
                i_32_ += i_29_ > 8 ? 8 : i_29_;
                i_29_ -= 8;
                while (i_32_ >= 8) {
                    is[i_30_++] = (byte)(i_31_ >> i_32_ - 8);
                    i_32_ -= 8;
                }
            }
            if (i_32_ > 0) {
                is[i_30_] = (byte)i_31_;
            }
            i_28_ = i_30_ * 8 + i_32_;
        }
        return i_28_;
    }

    public BitString decodeBitString() throws ASN1Exception {
        this.checkNextTag(3);
        byte[] is = new byte[Math.max(0, this.valueLength * 8)];
        int i = this.decodeBitStringContents(this.expectedTag(), is, 0);
        return new BitString(is, 0, i, true);
    }

    public ASN1OID decodeObjectIdentifier() throws ASN1Exception {
        this.checkNextTag(6);
        int i = this.getOctet();
        this.idlist[0] = i / 40;
        this.idlist[1] = i % 40;
        int i_33_ = 2;
        int i_34_ = 0;
        while (--this.valueLength > 0) {
            i = this.getOctet();
            if (i_34_ >= 0x10000000) {
                this.throwASN1Exception("int overflow");
            }
            i_34_ = (i_34_ << 7) + (i & 0x7F);
            if ((i & 0x80) != 0) continue;
            if (i_33_ >= this.idlist.length) {
                this.throwASN1Exception("Component overflow");
            }
            this.idlist[i_33_++] = i_34_;
            i_34_ = 0;
        }
        return new ASN1OID(null, this.idlist, 0, i_33_);
    }

    public String decodePrintableString() throws ASN1Exception {
        this.checkNextTag(19);
        return this.decodeString(false);
    }

    public String decodeT61String() throws ASN1Exception {
        this.checkNextTag(20);
        return this.decodeString(false);
    }

    public String decodeVideotexString() throws ASN1Exception {
        this.checkNextTag(21);
        return this.decodeString(false);
    }

    public String decodeIA5String() throws ASN1Exception {
        this.checkNextTag(22);
        return this.decodeString(false);
    }

    public String decodeNumericString() throws ASN1Exception {
        this.checkNextTag(18);
        return this.decodeString(false);
    }

    public String decodeGraphicString() throws ASN1Exception {
        this.checkNextTag(25);
        return this.decodeString(false);
    }

    public String decodeVisibleString() throws ASN1Exception {
        this.checkNextTag(26);
        return this.decodeString(false);
    }

    public String decodeGeneralString() throws ASN1Exception {
        this.checkNextTag(27);
        return this.decodeString(false);
    }

    public String decodeBMPString() throws ASN1Exception {
        this.checkNextTag(30);
        return this.decodeString(true);
    }

    private synchronized void decodeOctetStringContents(int i) throws ASN1Exception {
        if (this.constructed) {
            while (this.decodeTagAndLength()) {
                if (this.constructed) {
                    this.push(this.tag);
                }
                this.decodeOctetStringContents(i);
            }
            this.pop();
        } else {
            int i_35_ = this.valueLength;
            if (this.octetStringLength + i_35_ > this.octetStringByteArray.length) {
                byte[] is = new byte[this.octetStringLength + i_35_];
                if (this.octetStringLength > 0) {
                    System.arraycopy(this.octetStringByteArray, 0, is, 0, this.octetStringLength);
                }
                this.octetStringByteArray = is;
            }
            while (i_35_-- > 0) {
                this.octetStringByteArray[this.octetStringLength++] = (byte)this.getOctet();
            }
        }
    }

    public byte[] decodeOctetString() throws ASN1Exception {
        this.checkNextTag(4);
        this.octetStringLength = 0;
        this.octetStringByteArray = new byte[Math.max(0, this.valueLength)];
        this.decodeOctetStringContents(this.expectedTag());
        if (this.octetStringLength == this.octetStringByteArray.length) {
            return this.octetStringByteArray;
        }
        byte[] is = new byte[this.octetStringLength];
        System.arraycopy(this.octetStringByteArray, 0, is, 0, this.octetStringLength);
        return is;
    }

    public int decodeOctetString(byte[] is, int i) throws ASN1Exception {
        this.checkNextTag(4);
        this.octetStringLength = i;
        this.octetStringByteArray = is;
        this.decodeOctetStringContents(this.expectedTag());
        if (is != this.octetStringByteArray) {
            throw new ArrayIndexOutOfBoundsException("Octet byte[]");
        }
        return this.octetStringLength;
    }

    public ASN1Any decodeOctetStringAsAny() throws ASN1Exception {
        this.checkNextTag(4);
        this.octetStringLength = 0;
        this.octetStringByteArray = new byte[Math.max(0, this.valueLength)];
        this.decodeOctetStringContents(this.expectedTag());
        BERAny berany = new BERAny();
        berany.tag = 4;
        berany.data = this.octetStringByteArray;
        berany.valueBegin = 0;
        berany.begin = 0;
        berany.length = this.octetStringLength;
        return berany;
    }

    private void copyInto(ASN1Any asn1any, byte[] is, int i, int i_36_) {
        if (asn1any.length + i_36_ >= asn1any.data.length) {
            byte[] is_37_ = new byte[Math.max(asn1any.data.length + 512, asn1any.length + i_36_)];
            if (asn1any.data != null && asn1any.length > 0) {
                System.arraycopy(asn1any.data, 0, is_37_, 0, asn1any.length);
            }
            asn1any.data = is_37_;
        }
        if (is != null) {
            System.arraycopy(is, i, asn1any.data, asn1any.length, i_36_);
            asn1any.length += i_36_;
        }
    }

    private boolean decodeAny(ASN1Any asn1any) throws ASN1Exception {
        this.copyInto(asn1any, this.tagLenBuf, 0, this.tlbIndex);
        if (this.valueLength >= 0) {
            int i;
            this.copyInto(asn1any, null, 0, this.valueLength);
            int i_38_ = asn1any.length + this.valueLength;
            for (i = asn1any.length; i < i_38_; ++i) {
                asn1any.data[i] = (byte)this.getOctet();
            }
            asn1any.length = i;
        } else {
            this.push(this.tag);
            while (this.decodeTagAndLength()) {
                this.decodeAny(asn1any);
            }
            this.pop();
            this.copyInto(asn1any, null, 0, 2);
            asn1any.data[asn1any.length++] = 0;
            asn1any.data[asn1any.length++] = 0;
        }
        return true;
    }

    public ASN1Any decodeAny() throws ASN1Exception {
        if (!this.decodeTagAndLength()) {
            this.throwASN1Exception("Unable to decode tag");
        }
        BERAny berany = new BERAny();
        berany.tag = this.tag;
        berany.data = new byte[16];
        berany.length = 0;
        berany.begin = 0;
        berany.valueBegin = this.tlbIndex;
        this.decodeAny(berany);
        return berany;
    }

    public byte[] decodeAnyAsByteArray() throws ASN1Exception {
        ASN1Any asn1any = this.decodeAny();
        if (asn1any.begin == 0 && asn1any.length == asn1any.data.length) {
            return asn1any.data;
        }
        byte[] is = new byte[asn1any.length];
        System.arraycopy(asn1any.data, asn1any.begin, is, 0, asn1any.length);
        return is;
    }

    public void skipNext() throws ASN1Exception {
        if (!this.decodeTagAndLength()) {
            this.throwASN1Exception("Unable to skip next");
        }
        if (this.valueLength >= 0) {
            int i = this.valueLength;
            while (i-- > 0) {
                this.getOctet();
            }
        } else {
            int i = 0;
            this.push(this.tag);
            while (this.stackPos > i) {
                while (this.decodeTagAndLength()) {
                    if (this.valueLength < 0) {
                        this.push(this.tag);
                    }
                    int i_39_ = this.valueLength;
                    while (i_39_-- > 0) {
                        this.getOctet();
                    }
                }
                this.pop();
            }
        }
    }

    public int decodeSequence() throws ASN1Exception {
        this.checkNextTag(16);
        return this.stackPos;
    }

    public int decodeSequenceOf() throws ASN1Exception {
        this.checkNextTag(16);
        return this.stackPos;
    }

    public int decodeSet() throws ASN1Exception {
        this.checkNextTag(17);
        return this.stackPos;
    }

    public int decodeSetOf() throws ASN1Exception {
        this.checkNextTag(17);
        return this.stackPos;
    }

    public int decodeChoice(int[] is) throws ASN1Exception {
        return this.peekNextTag();
    }

    public boolean endOf(int i) throws ASN1Exception {
        if (i != this.stackPos) {
            this.throwASN1Exception("Termination mismatch");
        }
        if (this.decodeTagAndLength()) {
            this.pushBack();
            return false;
        }
        this.pop();
        return true;
    }

    public boolean nextIsDefault(int i) throws ASN1Exception {
        return this.peekNextTag() != i;
    }

    public boolean nextIsOptional(int i) throws ASN1Exception {
        return this.peekNextTag() != i;
    }

    public void nextHasSizeConstraints(long l, long l_40_) throws ASN1Exception {
    }

    public void nextHasAlphabetConstraints(String string) throws ASN1Exception {
    }

    public void debug() {
        System.out.println("readOctets:  0x" + Integer.toString(this.readOctets, 16) + "/" + this.readOctets);
        System.out.println("implicitTag: " + ASN1Tag.tagToString(this.implicitTag));
        System.out.println("tag:         " + ASN1Tag.tagToString(this.tag));
        System.out.println("constructed: " + this.constructed);
        System.out.println("valueLength: " + this.valueLength);
        System.out.println("stackPos:    " + this.stackPos);
        System.out.println("pushedBack:  " + this.pushedBack);
        System.out.println("stack:");
        System.out.println("  rest:" + this.currStack.stack[this.stackIndex]);
        System.out.println("  tag: " + this.currStack.stack[this.stackIndex + 1]);
    }
}

