/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.operations.MVDNodeSearchList;
import com.sap.idm.vds.operations.MVDNodeSearchOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.Vector;

public class PartialResultCallbackHandler {
    private Engine mEngine;

    public void setEngine(Engine aEngine) {
        this.mEngine = aEngine;
    }

    public boolean sendResults(MVDSearchResults aRes, String aRealSp, String aVirtsp, int aScope, Vector aReqAttrs) {
        aRes.fixStartingPoint(aVirtsp, aRealSp);
        MVDNodeSearchOperation node = MVDNodeSearchList.getOperation(this);
        aRes.setPartialResult();
        if (node != null) {
            int dsid = node.DataSource().IID();
            aRes = node.PostNodeProcessSingleCallbackResult(aRes);
            this.addEntriesToCache(dsid, aScope, aRes, aReqAttrs);
            Vector v = node.SearchParent().OriginalRequest().getRequestedAttributes();
            if (v != null && v.size() > 0 && !v.elementAt(0).equals("*")) {
                MVDOpUtilities.CleanRESEntriesAttributesByVector(aRes, v, true);
            }
        }
        return this.mEngine.sendPartialResult(aRes, node.SearchParent().OriginalRequest());
    }

    private void addEntriesToCache(int aDSid, int aScope, MVDSearchResults aResults, Vector aRequestedAttrs) {
        if (MVDCachePool.instance().isCacheEnabled()) {
            MVDCachePool.cacheEntryIfCacheAllowed(aResults, aScope, aRequestedAttrs, null, null, aDSid);
        }
    }
}

