/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDCacheUtil;
import com.sap.idm.vds.MVDGlobalStatistics;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDStatisticsInformation;
import com.sap.idm.vds.MVDStatisticsInterface;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.queue.MVDEngineCounter;
import com.sap.idm.vds.queue.MVDPriorityQueue;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class MVDStatistics
extends Thread {
    private boolean mPrintCacheStatistics;
    private boolean mDontPrintEqualStats;
    private boolean mPrintQueueStatistics;
    private boolean mEnabled;
    private boolean mDoCollect;
    private String mClassFilename;
    private boolean mDoLogUsingClass;
    private String mLogFileName;
    private String mLastLogFile;
    private boolean mDoStatLDAPOpCnt;
    private boolean mDoPerDNStat;
    private boolean mDoPrintCacheConfig;
    private Vector mStatDNs;
    private int mWriteFrequency;
    private boolean running = false;
    private static Location mStatLogger;
    private static String mLoggerName;
    private static MVDStatistics instance;
    private static String lineSeparator;
    private MVDStatisticsInformation mLastStatistic;

    private MVDStatistics() {
        super("Stat");
    }

    public static void setLoggerName(String aLoggerName) {
        mLoggerName = aLoggerName;
        String wa = Globals.getWorkArea();
        String propf = wa + "\\standalonelog.prop";
        boolean bStandalone = true;
        String aLoc = "";
        HashMap standaloneProps = MVDUtil.readPropertyFile(propf);
        if (standaloneProps == null) {
            bStandalone = false;
        } else {
            bStandalone = true;
            aLoc = (String)standaloneProps.get("STATLOGLOCATION");
            if (aLoc == null) {
                aLoc = wa + "\\logs\\statistics.trc";
            }
        }
        if (mStatLogger == null && (mStatLogger = Location.getLocation(aLoggerName)) == null) {
            System.out.println("Can not create SAP Logging Location ... ");
            return;
        }
        if (bStandalone) {
            mStatLogger.setEffectiveSeverity(300);
            Collection c = mStatLogger.getLogs();
            if (c.size() > 0) {
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    FileLog fl = (FileLog)iterator.next();
                    fl.close();
                    fl = new FileLog(aLoc);
                }
            } else {
                mStatLogger.addLog(new FileLog(aLoc));
            }
        }
    }

    public static String getLoggerName() {
        return mLoggerName;
    }

    public static MVDStatistics getInstance() {
        if (instance == null) {
            instance = new MVDStatistics();
        }
        return instance;
    }

    public void setClassFilename(String filename) {
        this.mClassFilename = filename == null || filename.equalsIgnoreCase("None") || filename.equalsIgnoreCase("Default") ? null : filename;
    }

    public String getClassFilename() {
        return this.mClassFilename;
    }

    public void setDoLogUsingClass(boolean boolVal) {
        this.mDoLogUsingClass = boolVal;
    }

    public void setPrintEqualStats(boolean boolVal) {
        this.mDontPrintEqualStats = boolVal;
    }

    public void setWriteFrequency(int writeFrequency) {
        this.mWriteFrequency = writeFrequency;
    }

    public void setDoPrintCacheConfig(boolean boolVal) {
        this.mDoPrintCacheConfig = boolVal;
    }

    public void setDoStatLDAPOpCnt(boolean boolVal) {
        this.mDoStatLDAPOpCnt = boolVal;
    }

    public void setPerDNStat(boolean boolVal) {
        this.mDoPerDNStat = boolVal;
    }

    public boolean getPerDNStat() {
        return this.mDoPerDNStat;
    }

    public void setStatDNs(String strVal) {
        this.mStatDNs = MVDUtil.splitString(strVal.toLowerCase(), "[$]");
    }

    public Vector getStatDNs() {
        return this.mStatDNs;
    }

    public void startStatisticsCollection() {
        if (!this.running) {
            this.running = true;
            this.start();
        }
    }

    public void stopStatisticsCollection() {
        if (this.running) {
            this.running = false;
            this.interrupt();
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            try {
                MVDStatistics.sleep(this.mWriteFrequency * 1000);
                this.printStatistics();
            }
            catch (Exception exception) {}
        }
    }

    public static String padMe(int width, String start) {
        StringBuffer sb = new StringBuffer(width);
        for (int x = 0; x < width; ++x) {
            sb.replace(0, 0, " ");
        }
        sb.replace(0, start.length(), start);
        return sb.toString();
    }

    public void printStatistics() {
        try {
            MVDStatisticsInformation statistic = this.createStatisticsAsObject();
            boolean printStatistics = true;
            if (this.mDontPrintEqualStats) {
                printStatistics = false;
                if (this.mLastStatistic != null && this.mLastStatistic.size() == statistic.size()) {
                    Iterator it = this.mLastStatistic.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = (Map.Entry)it.next();
                        Object key = entry.getKey();
                        Object val1 = entry.getValue();
                        Object val2 = statistic.get(key);
                        if (val2 != null && val1.equals(val2)) continue;
                        printStatistics = true;
                        break;
                    }
                } else {
                    printStatistics = true;
                }
            }
            if (!printStatistics) {
                return;
            }
            this.mLastStatistic = statistic;
            mStatLogger.logT(300, statistic.toString());
            if (this.mDoLogUsingClass && this.mClassFilename != null && printStatistics) {
                try {
                    Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                    Object o = c.newInstance();
                    MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                    mvds.log(statistic);
                }
                catch (Exception e) {
                    MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
                }
            }
        }
        catch (Exception e) {
            MVDLogger.Log("Error writing to statistics file: " + this.mLogFileName, 7, e);
        }
    }

    public String createStatistics() {
        StringBuffer cacheStatistic = new StringBuffer();
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        if (this.mPrintCacheStatistics && MVDCachePool.instance().getEnabled()) {
            cacheStatistic.append("Cache Statistics:");
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_HITS                      :");
            cacheStatistic.append(MVDCacheUtil.getCacheHits());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_WRITES                    :");
            cacheStatistic.append(MVDCacheUtil.getCacheWrites());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_READS                     :");
            cacheStatistic.append(MVDCacheUtil.getCacheReadOperations());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_HITRATIO                  :");
            cacheStatistic.append((int)((double)MVDCacheUtil.getCacheHits() / (double)MVDCacheUtil.getCacheReadOperations() * 100.0));
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_SIZE                      :");
            cacheStatistic.append(MVDCacheUtil.getCacheSize());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_REJECTED                  :");
            cacheStatistic.append(MVDCachePool.instance().getRejected());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("CACHE_TOTALCLEANED              :");
            cacheStatistic.append(MVDCachePool.instance().getTotalCleaned());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("FREE MEMORY                     :");
            cacheStatistic.append(free);
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("TOTAL MEMORY                    :");
            cacheStatistic.append(total);
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("MAX MEMORY                      :");
            cacheStatistic.append(max);
            cacheStatistic.append(lineSeparator);
        }
        String tmpStr = (String)MVDGlobalStatistics.getVariable("PRINT_CACHE_CONFIG");
        boolean bPrintConfiguration = false;
        if (tmpStr != null) {
            bPrintConfiguration = Boolean.valueOf(tmpStr);
        }
        if (bPrintConfiguration || this.mDoPrintCacheConfig) {
            if (MVDCachePool.instance().getEnabled()) {
                HashMap conf_params = MVDCachePool.instance().getConfigurationParameters();
                cacheStatistic.append("Cache Configuration:");
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("CACHE_MAX_SIZE                  :");
                cacheStatistic.append(conf_params.get("cachesize"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("CACHE_REMOVE_PERCENT            :");
                cacheStatistic.append(conf_params.get("cleantopercentage"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("CACHE_CLEAN_INTERVAL            :");
                cacheStatistic.append(conf_params.get("cleaninterval"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("CACHE_TTL                       :");
                cacheStatistic.append(conf_params.get("TTL"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("MEMBASED_ENABLED                :");
                cacheStatistic.append(conf_params.get("MXCACHE_DO_MEMORY_CACHING"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("MEM_HARD_LIMIT                  :");
                cacheStatistic.append(conf_params.get("MXCACHE_MEM_HARD_LIMIT"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("MEM_SOFT_LIMIT                  :");
                cacheStatistic.append(conf_params.get("MXCACHE_MEM_SOFT_LIMIT"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("GC_THRESHOLD                    :");
                cacheStatistic.append(conf_params.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("MEMBASED_INITIAL_SIZE           :");
                cacheStatistic.append(conf_params.get("MXCACHE_MEM_INITIAL_CACHE_SIZE"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append("MEMBASED_REMOVE_PERCENT         :");
                cacheStatistic.append(conf_params.get("MXCACHE_MEM_CLEAN_PERCENTAGE"));
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append(lineSeparator);
            } else {
                cacheStatistic.append("CACHE_ENABLED                   :FALSE");
                cacheStatistic.append(lineSeparator);
                cacheStatistic.append(lineSeparator);
            }
        }
        if (this.mDoStatLDAPOpCnt) {
            cacheStatistic.append("Number Of Operations:");
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_BIND                       :");
            cacheStatistic.append(Engine.getBindCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_SEARCH                     :");
            cacheStatistic.append(Engine.getSearchCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_ADD                        :");
            cacheStatistic.append(Engine.getAddCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_MODIFY                     :");
            cacheStatistic.append(Engine.getModifyCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_DELETE                     :");
            cacheStatistic.append(Engine.getDeleteCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("LDAP_COMPARE                    :");
            cacheStatistic.append(Engine.getCompareCounter());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("REQUEST_ERRORS (timeout/others) :");
            cacheStatistic.append(Globals.TimeOutErrorReqCount() + "/" + Globals.ErrorReqCount());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("VDS_ENGINES (free/busy)         :");
            cacheStatistic.append(EnginePool.getFreeEnginesCount() + "/" + EnginePool.getBusyEnginesCount());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append(lineSeparator);
        }
        if (this.mPrintQueueStatistics) {
            cacheStatistic.append("Priority Queue:");
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("Processed requests              :");
            cacheStatistic.append(MVDPriorityQueue.getNumberOfRequests());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("MaxNumberOfRequestsInQueue      :");
            cacheStatistic.append(MVDPriorityQueue.getMaxNumberOfElementsInQueue());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("MaxNumberOfEngines              :");
            cacheStatistic.append(MVDEngineCounter.getMaxNumberOfEngines());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("NumberOfDirectExecutions        :");
            cacheStatistic.append(MVDPriorityQueue.getNumberOfDirectExecutions());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("NumberOfWaits_FullQueue         :");
            cacheStatistic.append(MVDPriorityQueue.getFullQueueWaits());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("NumberOfWaits_ProcessingLimit   :");
            cacheStatistic.append(MVDPriorityQueue.getEngineWaits());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("Rejections_FullQueue  \t\t   :");
            cacheStatistic.append(MVDPriorityQueue.getWaitForQueueRejections());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append("Rejections_WaitForExecute       :");
            cacheStatistic.append(MVDPriorityQueue.getNumberOfRejectionsWaitForExecute());
            cacheStatistic.append(lineSeparator);
            cacheStatistic.append(lineSeparator);
        }
        cacheStatistic.append("DN based statistics:");
        cacheStatistic.append(lineSeparator);
        Iterator iter = MVDGlobalStatistics.getDNs().keySet().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Integer aVal = (Integer)MVDGlobalStatistics.getDNs().get(element);
            cacheStatistic.append(MVDStatistics.padMe(50, element));
            cacheStatistic.append(":");
            cacheStatistic.append(aVal);
            cacheStatistic.append(lineSeparator);
        }
        cacheStatistic.append(lineSeparator);
        if (this.mDoCollect && this.mClassFilename != null) {
            try {
                Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                Object o = c.newInstance();
                MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                mvds.doInit();
                mvds.collect();
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (NoClassDefFoundError e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (Exception e) {
                MVDLogger.Log("Exception in external statisticsclass: " + this.mClassFilename + lineSeparator + "Exception is: " + e.getMessage(), 7, e);
                System.err.println();
            }
        }
        String statistic = cacheStatistic.toString();
        HashMap map = MVDGlobalStatistics.getExports();
        String dummyspaces = "                                ";
        if (map != null) {
            Set keys = map.keySet();
            Iterator iter2 = keys.iterator();
            while (iter2.hasNext()) {
                String key = (String)iter2.next();
                String line = key + dummyspaces;
                statistic = statistic + line.substring(0, 32) + ":" + map.get(key) + lineSeparator;
            }
            if (keys.size() > 0) {
                statistic = statistic + lineSeparator;
            }
        }
        return statistic;
    }

    public String createOldStatistics() {
        String cacheStatistic = "";
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        if (this.mPrintCacheStatistics && MVDCachePool.instance().getEnabled()) {
            cacheStatistic = cacheStatistic + "Cache Statistics:" + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_HITS                      :" + MVDCacheUtil.getCacheHits() + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_WRITES                    :" + MVDCacheUtil.getCacheWrites() + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_READS                     :" + MVDCacheUtil.getCacheReadOperations() + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_HITRATIO                  :" + (int)((double)MVDCacheUtil.getCacheHits() / (double)MVDCacheUtil.getCacheReadOperations() * 100.0) + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_SIZE                      :" + MVDCacheUtil.getCacheSize() + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_REJECTED                  :" + MVDCachePool.instance().getRejected() + lineSeparator;
            cacheStatistic = cacheStatistic + "CACHE_TOTALCLEANED              :" + MVDCachePool.instance().getTotalCleaned() + lineSeparator;
            cacheStatistic = cacheStatistic + lineSeparator;
            cacheStatistic = cacheStatistic + "FREE MEMORY                     :" + free + lineSeparator;
            cacheStatistic = cacheStatistic + "TOTAL MEMORY                    :" + total + lineSeparator;
            cacheStatistic = cacheStatistic + "MAX MEMORY                      :" + max + lineSeparator;
        }
        String tmpStr = (String)MVDGlobalStatistics.getVariable("PRINT_CACHE_CONFIG");
        boolean bPrintConfiguration = false;
        if (tmpStr != null) {
            bPrintConfiguration = Boolean.valueOf(tmpStr);
        }
        if (bPrintConfiguration || this.mDoPrintCacheConfig) {
            if (MVDCachePool.instance().getEnabled()) {
                HashMap conf_params = MVDCachePool.instance().getConfigurationParameters();
                cacheStatistic = cacheStatistic + "Cache Configuration:" + lineSeparator;
                cacheStatistic = cacheStatistic + "CACHE_MAX_SIZE                  :" + conf_params.get("cachesize") + lineSeparator;
                cacheStatistic = cacheStatistic + "CACHE_REMOVE_PERCENT            :" + conf_params.get("cleantopercentage") + lineSeparator;
                cacheStatistic = cacheStatistic + "CACHE_CLEAN_INTERVAL            :" + conf_params.get("cleaninterval") + lineSeparator;
                cacheStatistic = cacheStatistic + "CACHE_TTL                       :" + conf_params.get("TTL") + lineSeparator;
                cacheStatistic = cacheStatistic + "MEMBASED_ENABLED                :" + conf_params.get("MXCACHE_DO_MEMORY_CACHING") + lineSeparator;
                cacheStatistic = cacheStatistic + "MEM_HARD_LIMIT                  :" + conf_params.get("MXCACHE_MEM_HARD_LIMIT") + lineSeparator;
                cacheStatistic = cacheStatistic + "MEM_SOFT_LIMIT                  :" + conf_params.get("MXCACHE_MEM_SOFT_LIMIT") + lineSeparator;
                cacheStatistic = cacheStatistic + "GC_THRESHOLD                    :" + conf_params.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD") + lineSeparator;
                cacheStatistic = cacheStatistic + "MEMBASED_INITIAL_SIZE           :" + conf_params.get("MXCACHE_MEM_INITIAL_CACHE_SIZE") + lineSeparator;
                cacheStatistic = cacheStatistic + "MEMBASED_REMOVE_PERCENT         :" + conf_params.get("MXCACHE_MEM_CLEAN_PERCENTAGE") + lineSeparator;
                cacheStatistic = cacheStatistic + lineSeparator;
            } else {
                cacheStatistic = cacheStatistic + "CACHE_ENABLED                   :FALSE" + lineSeparator;
                cacheStatistic = cacheStatistic + lineSeparator;
            }
        }
        if (this.mDoStatLDAPOpCnt) {
            cacheStatistic = cacheStatistic + "Number Of Operations:" + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_BIND                       :" + Engine.getBindCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_SEARCH                     :" + Engine.getSearchCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_ADD                        :" + Engine.getAddCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_MODIFY                     :" + Engine.getModifyCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_DELETE                     :" + Engine.getDeleteCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "LDAP_COMPARE                    :" + Engine.getCompareCounter() + lineSeparator;
            cacheStatistic = cacheStatistic + "REQUEST_ERRORS (timeout/others) :" + Globals.TimeOutErrorReqCount() + "/" + Globals.ErrorReqCount() + lineSeparator;
            cacheStatistic = cacheStatistic + "VDS_ENGINES (free/busy)         :" + EnginePool.getFreeEnginesCount() + "/" + EnginePool.getBusyEnginesCount() + lineSeparator;
            cacheStatistic = cacheStatistic + lineSeparator;
        }
        if (this.mPrintQueueStatistics) {
            cacheStatistic = cacheStatistic + "Priority Queue:" + lineSeparator;
            cacheStatistic = cacheStatistic + "Processed requests              :" + MVDPriorityQueue.getNumberOfRequests() + lineSeparator;
            cacheStatistic = cacheStatistic + "MaxNumberOfRequestsInQueue      :" + MVDPriorityQueue.getMaxNumberOfElementsInQueue() + lineSeparator;
            cacheStatistic = cacheStatistic + "MaxNumberOfEngines              :" + MVDEngineCounter.getMaxNumberOfEngines() + lineSeparator;
            cacheStatistic = cacheStatistic + "NumberOfDirectExecutions        :" + MVDPriorityQueue.getNumberOfDirectExecutions() + lineSeparator;
            cacheStatistic = cacheStatistic + "NumberOfWaits_FullQueue         :" + MVDPriorityQueue.getFullQueueWaits() + lineSeparator;
            cacheStatistic = cacheStatistic + "NumberOfWaits_ProcessingLimit   :" + MVDPriorityQueue.getEngineWaits() + lineSeparator;
            cacheStatistic = cacheStatistic + "Rejections_FullQueue  \t\t   :" + MVDPriorityQueue.getWaitForQueueRejections() + lineSeparator;
            cacheStatistic = cacheStatistic + "Rejections_WaitForExecute       :" + MVDPriorityQueue.getNumberOfRejectionsWaitForExecute() + lineSeparator;
            cacheStatistic = cacheStatistic + lineSeparator;
        }
        cacheStatistic = cacheStatistic + "DN based statistics:" + lineSeparator;
        Iterator iter = MVDGlobalStatistics.getDNs().keySet().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Integer aVal = (Integer)MVDGlobalStatistics.getDNs().get(element);
            cacheStatistic = cacheStatistic + MVDStatistics.padMe(50, element) + ":" + aVal + lineSeparator;
        }
        cacheStatistic = cacheStatistic + lineSeparator;
        if (this.mDoCollect && this.mClassFilename != null) {
            try {
                Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                Object o = c.newInstance();
                MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                mvds.doInit();
                mvds.collect();
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (NoClassDefFoundError e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (Exception e) {
                MVDLogger.Log("Exception in external statisticsclass: " + this.mClassFilename + lineSeparator + "Exception is: " + e.getMessage(), 7, e);
                System.err.println();
            }
        }
        String statistic = "";
        statistic = statistic + cacheStatistic;
        HashMap map = MVDGlobalStatistics.getExports();
        String dummyspaces = "                                ";
        if (map != null) {
            Set keys = map.keySet();
            Iterator iter2 = keys.iterator();
            while (iter2.hasNext()) {
                String key = (String)iter2.next();
                String line = key + dummyspaces;
                statistic = statistic + line.substring(0, 32) + ":" + map.get(key) + lineSeparator;
            }
            if (keys.size() > 0) {
                statistic = statistic + lineSeparator;
            }
        }
        return statistic;
    }

    public MVDSearchResults fetchStatistics() {
        MVDSearchResultEntry entry = new MVDSearchResultEntry();
        if (this.mPrintCacheStatistics && MVDCachePool.instance().getEnabled()) {
            entry.setAttrValue("CACHE_HITS", false, "" + MVDCacheUtil.getCacheHits());
            entry.setAttrValue("CACHE_WRITES", false, "" + MVDCacheUtil.getCacheWrites());
            entry.setAttrValue("CACHE_READS", false, "" + MVDCacheUtil.getCacheReadOperations());
            entry.setAttrValue("CACHE_HITRATIO", false, "" + (int)((double)MVDCacheUtil.getCacheHits() / (double)MVDCacheUtil.getCacheReadOperations() * 100.0));
            entry.setAttrValue("CACHE_SIZE", false, "" + MVDCacheUtil.getCacheSize());
            entry.setAttrValue("CACHE_REJECTED", false, "" + MVDCachePool.instance().getRejected());
            entry.setAttrValue("CACHE_TOTALCLEANED", false, "" + MVDCachePool.instance().getTotalCleaned());
        }
        String tmpStr = (String)MVDGlobalStatistics.getVariable("PRINT_CACHE_CONFIG");
        boolean bPrintConfiguration = false;
        if (tmpStr != null) {
            bPrintConfiguration = Boolean.valueOf(tmpStr);
        }
        if (bPrintConfiguration || this.mDoPrintCacheConfig) {
            if (MVDCachePool.instance().getEnabled()) {
                HashMap conf_params = MVDCachePool.instance().getConfigurationParameters();
                entry.setAttrValue("CACHE_MAX_SIZE", false, "" + conf_params.get("cachesize"));
                entry.setAttrValue("CACHE_REMOVE_PROCENT", false, "" + conf_params.get("cleantopercentage"));
                entry.setAttrValue("CACHE_CLEAN_INTERVAL", false, "" + conf_params.get("cleaninterval"));
                entry.setAttrValue("CACHE_TTL", false, "" + conf_params.get("TTL"));
                entry.setAttrValue("MEMBASED_ENABLED", false, (String)conf_params.get("MXCACHE_DO_MEMORY_CACHING"));
                entry.setAttrValue("MEM_HARD_LIMIT", false, (String)conf_params.get("MXCACHE_MEM_HARD_LIMIT"));
                entry.setAttrValue("MEM_SOFT_LIMIT", false, (String)conf_params.get("MXCACHE_MEM_SOFT_LIMIT"));
                entry.setAttrValue("GC_TRESHOLD", false, (String)conf_params.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD"));
                entry.setAttrValue("MEMBASED_INITIAL_SIZE", false, (String)conf_params.get("MXCACHE_MEM_INITIAL_CACHE_SIZE"));
                entry.setAttrValue("MEMBASED_CLEAN_PERCENT", false, (String)conf_params.get("MXCACHE_MEM_CLEAN_PERCENTAGE"));
            } else {
                entry.setAttrValue("CACHE_ENABLED", false, "FALSE");
            }
        }
        if (this.mDoStatLDAPOpCnt) {
            entry.setAttrValue("LDAP_BIND", false, "" + Engine.getBindCounter());
            entry.setAttrValue("LDAP_SEARCH", false, "" + Engine.getSearchCounter());
            entry.setAttrValue("LDAP_ADD", false, "" + Engine.getAddCounter());
            entry.setAttrValue("LDAP_MODIFY", false, "" + Engine.getModifyCounter());
            entry.setAttrValue("LDAP_DELETE", false, "" + Engine.getDeleteCounter());
            entry.setAttrValue("LDAP_COMPARE", false, "" + Engine.getCompareCounter());
            entry.setAttrValue("REQUEST_ERRORS (timeout/others)", false, Globals.TimeOutErrorReqCount() + "/" + Globals.ErrorReqCount());
            entry.setAttrValue("VDS_ENGINES (free/busy)", false, EnginePool.getFreeEnginesCount() + "/" + EnginePool.getBusyEnginesCount());
        }
        if (this.mPrintQueueStatistics) {
            entry.setAttrValue("Processed requests", false, "" + MVDPriorityQueue.getNumberOfRequests());
            entry.setAttrValue("MaxNumberOfRequestsInQueue", false, "" + MVDPriorityQueue.getMaxNumberOfElementsInQueue());
            entry.setAttrValue("MaxNumberOfEngines", false, "" + MVDEngineCounter.getMaxNumberOfEngines());
            entry.setAttrValue("NumberOfDirectExecutions", false, "" + MVDPriorityQueue.getNumberOfDirectExecutions());
            entry.setAttrValue("NumberOfWaits_FullQueue", false, "" + MVDPriorityQueue.getFullQueueWaits());
            entry.setAttrValue("NumberOfWaits_ProcessingLimit", false, "" + MVDPriorityQueue.getEngineWaits());
            entry.setAttrValue("Rejections_FullQueue", false, "" + MVDPriorityQueue.getWaitForQueueRejections());
            entry.setAttrValue("Rejections_WaitForExecute", false, "" + MVDPriorityQueue.getNumberOfRejectionsWaitForExecute());
        }
        if (this.mDoCollect && this.mClassFilename != null) {
            try {
                Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                Object o = c.newInstance();
                MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                mvds.collect();
            }
            catch (Exception e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
        }
        HashMap map = MVDGlobalStatistics.getExports();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)map.get(key);
            entry.setAttrValue(key, false, value);
        }
        entry.setDn("o=mvdstat");
        MVDSearchResults res = new MVDSearchResults();
        res.add(entry);
        res.setOK();
        return res;
    }

    public void setDoCollect(boolean boolval) {
        this.mDoCollect = boolval;
    }

    public void setPrintCacheStatistics(boolean printCacheStatistics) {
        this.mPrintCacheStatistics = printCacheStatistics;
    }

    public void setPrintQueueStatistics(boolean printQueueStatistics) {
        this.mPrintQueueStatistics = printQueueStatistics;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public void configReloadFinished() {
        if (this.mEnabled) {
            this.initialize();
            this.startStatisticsCollection();
        } else {
            this.stopStatisticsCollection();
        }
    }

    public Properties createStatisticsAsProperties() {
        Properties props = new Properties();
        if (this.mPrintCacheStatistics && MVDCachePool.instance().getEnabled()) {
            props.put("CACHE_HITS", MVDCacheUtil.getCacheHits() + "");
            props.put("CACHE_WRITES", MVDCacheUtil.getCacheWrites() + "");
            props.put("CACHE_READS", MVDCacheUtil.getCacheReadOperations() + "");
            props.put("CACHE_HITRATIO", (int)((double)MVDCacheUtil.getCacheHits() / (double)MVDCacheUtil.getCacheReadOperations() * 100.0) + "");
            props.put("CACHE_SIZE", MVDCacheUtil.getCacheSize() + "");
            props.put("CACHE_REJECTED", MVDCachePool.instance().getRejected() + "");
            props.put("CACHE_TOTALCLEANED", MVDCachePool.instance().getTotalCleaned() + "");
        }
        String tmpStr = (String)MVDGlobalStatistics.getVariable("PRINT_CACHE_CONFIG");
        boolean bPrintConfiguration = false;
        if (tmpStr != null) {
            bPrintConfiguration = Boolean.valueOf(tmpStr);
        }
        if (bPrintConfiguration || this.mDoPrintCacheConfig) {
            if (MVDCachePool.instance().getEnabled()) {
                HashMap conf_params = MVDCachePool.instance().getConfigurationParameters();
                props.put("CACHE_MAX_SIZE", conf_params.get("cachesize"));
                props.put("CACHE_REMOVE_PROCENT", conf_params.get("cleantopercentage"));
                props.put("CACHE_CLEAN_INTERVAL", conf_params.get("cleaninterval"));
                props.put("CACHE_TTL", conf_params.get("TTL"));
                props.put("MEMBASED_ENABLED", (String)conf_params.get("MXCACHE_DO_MEMORY_CACHING"));
                props.put("MEM_HARD_LIMIT", (String)conf_params.get("MXCACHE_MEM_HARD_LIMIT"));
                props.put("MEM_SOFT_LIMIT", (String)conf_params.get("MXCACHE_MEM_SOFT_LIMIT"));
                props.put("GC_TRESHOLD", (String)conf_params.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD"));
                props.put("MEMBASED_INITIAL_SIZE", (String)conf_params.get("MXCACHE_MEM_INITIAL_CACHE_SIZE"));
                props.put("MEMBASED_CLEAN_PERCENT", (String)conf_params.get("MXCACHE_MEM_CLEAN_PERCENTAGE"));
            } else {
                props.put("CACHE_ENABLED", "FALSE");
            }
        }
        if (this.mDoStatLDAPOpCnt) {
            props.put("LDAP_BIND", Engine.getBindCounter() + "");
            props.put("LDAP_SEARCH", Engine.getSearchCounter() + "");
            props.put("LDAP_ADD", Engine.getAddCounter() + "");
            props.put("LDAP_MODIFY", Engine.getModifyCounter() + "");
            props.put("LDAP_DELETE", Engine.getDeleteCounter() + "");
            props.put("LDAP_COMPARE", Engine.getCompareCounter() + "");
            props.put("REQUEST_ERRORS (timeout/others)", Globals.TimeOutErrorReqCount() + "/" + Globals.ErrorReqCount());
            props.put("VDS_ENGINES (free/busy)", EnginePool.getFreeEnginesCount() + "/" + EnginePool.getBusyEnginesCount());
        }
        if (this.mPrintQueueStatistics) {
            props.put("Processed requests", MVDPriorityQueue.getNumberOfRequests() + "");
            props.put("MaxNumberOfRequestsInQueue", MVDPriorityQueue.getMaxNumberOfElementsInQueue() + "");
            props.put("MaxNumberOfEngines", MVDEngineCounter.getMaxNumberOfEngines() + "");
            props.put("NumberOfDirectExecutions", MVDPriorityQueue.getNumberOfDirectExecutions() + "");
            props.put("NumberOfWaits_FullQueue", MVDPriorityQueue.getFullQueueWaits() + "");
            props.put("NumberOfWaits_ProcessingLimit", MVDPriorityQueue.getEngineWaits() + "");
            props.put("Rejections_FullQueue", MVDPriorityQueue.getWaitForQueueRejections() + "");
            props.put("Rejections_WaitForExecute", MVDPriorityQueue.getNumberOfRejectionsWaitForExecute() + "");
        }
        HashMap map = MVDGlobalStatistics.getExports();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)map.get(key);
            props.put(key, value);
        }
        return props;
    }

    public MVDStatisticsInformation createStatisticsAsObject() {
        MVDStatisticsInformation props = new MVDStatisticsInformation();
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        props.put("FREE MEMORY", free + "");
        props.put("TOTAL MEMORY", total + "");
        props.put("MAX MEMORY", max + "");
        if (this.mPrintCacheStatistics && MVDCachePool.instance().getEnabled()) {
            props.put("CACHE_HITS", MVDCacheUtil.getCacheHits() + "");
            props.put("CACHE_WRITES", MVDCacheUtil.getCacheWrites() + "");
            props.put("CACHE_READS", MVDCacheUtil.getCacheReadOperations() + "");
            props.put("CACHE_HITRATIO", (int)((double)MVDCacheUtil.getCacheHits() / (double)MVDCacheUtil.getCacheReadOperations() * 100.0) + "");
            props.put("CACHE_SIZE", MVDCacheUtil.getCacheSize() + "");
            props.put("CACHE_REJECTED", MVDCachePool.instance().getRejected() + "");
            props.put("CACHE_TOTALCLEANED", MVDCachePool.instance().getTotalCleaned() + "");
        }
        String tmpStr = (String)MVDGlobalStatistics.getVariable("PRINT_CACHE_CONFIG");
        boolean bPrintConfiguration = false;
        if (tmpStr != null) {
            bPrintConfiguration = Boolean.valueOf(tmpStr);
        }
        if (bPrintConfiguration || this.mDoPrintCacheConfig) {
            if (MVDCachePool.instance().getEnabled()) {
                HashMap conf_params = MVDCachePool.instance().getConfigurationParameters();
                props.put("CACHE_MAX_SIZE", conf_params.get("cachesize"));
                props.put("CACHE_REMOVE_PROCENT", conf_params.get("cleantopercentage"));
                props.put("CACHE_CLEAN_INTERVAL", conf_params.get("cleaninterval"));
                props.put("CACHE_TTL", conf_params.get("TTL"));
                props.put("MEMBASED_ENABLED", (String)conf_params.get("MXCACHE_DO_MEMORY_CACHING"));
                props.put("MEM_HARD_LIMIT", (String)conf_params.get("MXCACHE_MEM_HARD_LIMIT"));
                props.put("MEM_SOFT_LIMIT", (String)conf_params.get("MXCACHE_MEM_SOFT_LIMIT"));
                props.put("GC_TRESHOLD", (String)conf_params.get("MXCACHE_CALL_GC_CLEAN_TRESHOLD"));
                props.put("MEMBASED_INITIAL_SIZE", (String)conf_params.get("MXCACHE_MEM_INITIAL_CACHE_SIZE"));
                props.put("MEMBASED_CLEAN_PERCENT", (String)conf_params.get("MXCACHE_MEM_CLEAN_PERCENTAGE"));
            } else {
                props.put("CACHE_ENABLED", "FALSE");
            }
        }
        if (this.mDoStatLDAPOpCnt) {
            props.put("LDAP_BIND", Engine.getBindCounter() + "");
            props.put("LDAP_SEARCH", Engine.getSearchCounter() + "");
            props.put("LDAP_ADD", Engine.getAddCounter() + "");
            props.put("LDAP_MODIFY", Engine.getModifyCounter() + "");
            props.put("LDAP_DELETE", Engine.getDeleteCounter() + "");
            props.put("LDAP_COMPARE", Engine.getCompareCounter() + "");
            props.put("REQUEST_ERRORS (timeout/others)", Globals.TimeOutErrorReqCount() + "/" + Globals.ErrorReqCount());
            props.put("VDS_ENGINES (free/busy)", EnginePool.getFreeEnginesCount() + "/" + EnginePool.getBusyEnginesCount());
        }
        if (this.mPrintQueueStatistics) {
            props.put("Processed requests", MVDPriorityQueue.getNumberOfRequests() + "");
            props.put("MaxNumberOfRequestsInQueue", MVDPriorityQueue.getMaxNumberOfElementsInQueue() + "");
            props.put("MaxNumberOfEngines", MVDEngineCounter.getMaxNumberOfEngines() + "");
            props.put("NumberOfDirectExecutions", MVDPriorityQueue.getNumberOfDirectExecutions() + "");
            props.put("NumberOfWaits_FullQueue", MVDPriorityQueue.getFullQueueWaits() + "");
            props.put("NumberOfWaits_ProcessingLimit", MVDPriorityQueue.getEngineWaits() + "");
            props.put("Rejections_FullQueue", MVDPriorityQueue.getWaitForQueueRejections() + "");
            props.put("Rejections_WaitForExecute", MVDPriorityQueue.getNumberOfRejectionsWaitForExecute() + "");
        }
        Iterator iter = MVDGlobalStatistics.getDNs().keySet().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Integer aVal = (Integer)MVDGlobalStatistics.getDNs().get(element);
            props.put(element, aVal);
        }
        if (this.mDoCollect && this.mClassFilename != null) {
            try {
                Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                Object o = c.newInstance();
                MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                mvds.doInit();
                mvds.collect();
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (NoClassDefFoundError e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (Exception e) {
                MVDLogger.Log("Exception in external statisticsclass: " + this.mClassFilename + lineSeparator + "Exception is: " + e.getMessage(), 7, e);
                System.err.println();
            }
        }
        HashMap map = MVDGlobalStatistics.getExports();
        Iterator iter2 = map.keySet().iterator();
        while (iter2.hasNext()) {
            String key = (String)iter2.next();
            String value = (String)map.get(key);
            props.put(key, value);
        }
        return props;
    }

    public void initialize() {
        if (this.mDoCollect && this.mClassFilename != null) {
            try {
                Class c = (Class)Globals.GetExternalClass(this.mClassFilename);
                Object o = c.newInstance();
                MVDStatisticsInterface mvds = (MVDStatisticsInterface)o;
                mvds.doInit();
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (InstantiationException e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (NoClassDefFoundError e) {
                MVDLogger.Log("Unable to find external statisticsclass: " + this.mClassFilename, 7, e);
            }
            catch (Exception e) {
                MVDLogger.Log("Exception in external statisticsclass: " + this.mClassFilename + lineSeparator + "Exception is: " + e.getMessage(), 7, e);
                System.err.println();
            }
        }
    }

    static {
        mLoggerName = "";
        lineSeparator = System.getProperty("line.separator", "\n");
    }
}

