/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;

public class MVDOrderedHashMap
extends HashMap {
    private VectorSet order = new VectorSet();

    public MVDOrderedHashMap() {
    }

    public MVDOrderedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public MVDOrderedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MVDOrderedHashMap(Map m) {
        super(m);
    }

    public Set keySet() {
        return this.order;
    }

    public Object put(Object key, Object value) {
        Object o = super.put(key, value);
        this.order.add(key);
        return o;
    }

    public void putAll(Map m) {
        super.putAll(m);
    }

    public Object remove(Object key) {
        Object o = super.remove(key);
        this.order.remove(key);
        return o;
    }

    public Object keyElementAt(int aIndex) {
        return this.order.elementAt(aIndex);
    }

    private class VectorSet
    implements SortedSet {
        private Vector v;

        public VectorSet() {
            this.v = new Vector();
        }

        public VectorSet(Vector v) {
            this.v = v;
        }

        public Object first() {
            if (this.v == null) {
                return null;
            }
            return this.v.firstElement();
        }

        public Object last() {
            if (this.v == null) {
                return null;
            }
            return this.v.lastElement();
        }

        public Comparator comparator() {
            return null;
        }

        public SortedSet headSet(Object toElement) {
            Vector subset = new Vector(this.v);
            boolean removerest = false;
            Iterator iter = subset.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element.equals(toElement)) {
                    removerest = true;
                }
                if (!removerest) continue;
                iter.remove();
            }
            return new VectorSet(subset);
        }

        public SortedSet tailSet(Object fromElement) {
            Object element;
            Vector subset = new Vector(this.v);
            Iterator iter = subset.iterator();
            while (iter.hasNext() && !(element = iter.next()).equals(fromElement)) {
                iter.remove();
            }
            return new VectorSet(subset);
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            Object element;
            Vector subset = new Vector(this.v);
            Iterator iter = subset.iterator();
            while (iter.hasNext() && !(element = iter.next()).equals(fromElement)) {
                iter.remove();
            }
            boolean removerest = false;
            Iterator iter2 = subset.iterator();
            while (iter2.hasNext()) {
                Object element2 = iter2.next();
                if (element2.equals(toElement)) {
                    removerest = true;
                }
                if (!removerest) continue;
                iter2.remove();
            }
            return new VectorSet(subset);
        }

        public int size() {
            return this.v == null ? 0 : this.v.size();
        }

        public void clear() {
            this.v.clear();
        }

        public boolean isEmpty() {
            return this.v == null || this.v.size() <= 0;
        }

        public Object[] toArray() {
            return this.v.toArray();
        }

        public boolean add(Object o) {
            if (!this.v.contains(o)) {
                return this.v.add(o);
            }
            return false;
        }

        public boolean contains(Object o) {
            return this.v.contains(o);
        }

        public boolean remove(Object o) {
            return this.v != null && this.v.remove(o);
        }

        public boolean addAll(Collection c) {
            return this.v.addAll(c);
        }

        public boolean containsAll(Collection c) {
            return this.v.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            return this.v.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.v.retainAll(c);
        }

        public Iterator iterator() {
            return this.v.iterator();
        }

        public Object[] toArray(Object[] a) {
            return this.v.toArray(a);
        }

        public Object elementAt(int aIndex) {
            return this.v.elementAt(aIndex);
        }
    }
}

