/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDServer;
import com.sap.idm.vds.MVDSnmpSettings;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.snmp.SNMPTrap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDLogger {
    private static String mCategoryName = "none";
    private static Category mCat = null;
    private static HashMap mOperLoggers = new HashMap();
    private static HashMap mExtensionLoggers = new HashMap();
    private static SNMPTrap trapSender;
    private static boolean mWriteASNFiles;
    private static int mMaskFilter;
    private static String mMaskValue;
    private static boolean mAvoidEmptyLog;
    private static Vector mEmptyLogStrings;
    private static long mAsnDumpCounter;
    public static final int NOOF_LOG_LEVELS = 9;
    public static final int LEVEL_NONE = 8;
    public static final int LEVEL_ERROR = 7;
    public static final int LEVEL_WARN = 6;
    public static final int LEVEL_MINIMAL = 5;
    public static final int LEVEL_COMPACT = 4;
    public static final int LEVEL_NORMAL = 3;
    public static final int LEVEL_EXTENDED = 2;
    public static final int LEVEL_TRACE = 1;
    public static final int LEVEL_FULL = 0;
    public static final int SNMPLEVEL_INFORMATION = 3;
    public static final int SNMPLEVEL_WARNING = 2;
    public static final int SNMPLEVEL_ERROR = 1;
    public static final int SNMPLEVEL_NONE = 0;
    private static int[] mMapMVDLoglevels2SapSeverity;
    private static HashMap mLocationMapping;

    public static void setMaskFilter(String s) {
        mMaskValue = "";
        if (s == null) {
            mMaskFilter = 0;
            return;
        }
        try {
            mMaskFilter = Integer.parseInt(s);
        }
        catch (Exception e) {
            mMaskFilter = 0;
        }
        for (int x = 0; x < mMaskFilter; ++x) {
            mMaskValue = mMaskValue + "x";
        }
    }

    public static int getMaskFilter() {
        return mMaskFilter;
    }

    public static void setAvoidEmptyLog(String s) {
        if (s == null) {
            mAvoidEmptyLog = false;
            return;
        }
        mAvoidEmptyLog = s.equalsIgnoreCase("true");
    }

    public static boolean getAvoidEmptyLog() {
        return mAvoidEmptyLog;
    }

    public static void setWriteASNFiles(boolean aBoolVal) {
        mWriteASNFiles = aBoolVal;
    }

    public static boolean isWriteASNFiles() {
        return mWriteASNFiles;
    }

    public static Vector getEmptyLogStrings() {
        return mEmptyLogStrings;
    }

    public MVDLogger(Vector aLoggerKeys) {
        MVDLogger.addLoggers(aLoggerKeys);
    }

    public static int Str2Level(String aStr) {
        if (aStr == null) {
            return 500;
        }
        if ((aStr = aStr.toLowerCase()).equals("none")) {
            return 701;
        }
        if (aStr.equals("fatal")) {
            return 600;
        }
        if (aStr.equals("error")) {
            return 500;
        }
        if (aStr.equals("warning")) {
            return 400;
        }
        if (aStr.equals("info")) {
            return 300;
        }
        if (aStr.equals("debug")) {
            return 100;
        }
        if (aStr.equals("all")) {
            return 0;
        }
        return 500;
    }

    public static void addLoggers(Vector aLoggerKeys) {
        for (int i = 0; i < aLoggerKeys.size(); ++i) {
            String s = (String)aLoggerKeys.elementAt(i);
            String extension = "";
            if (s.equals(MVDGlobals.getMainGroupName())) {
                extension = "admin";
            } else if (s.startsWith("LDAP Sessions:")) {
                extension = s.substring("LDAP Sessions:".length());
            } else {
                if (!s.startsWith("Web Service:")) continue;
                extension = s.substring("Web Service:".length());
            }
            String wa = Globals.getWorkArea();
            String propf = wa + "\\standalonelog.prop";
            boolean bStandalone = true;
            int oLevel = -1;
            int eLevel = -1;
            String aLoc = "";
            HashMap standaloneProps = MVDUtil.readPropertyFile(propf);
            if (standaloneProps == null) {
                bStandalone = false;
            } else {
                bStandalone = true;
                String stroLevel = (String)standaloneProps.get("LEVEL");
                oLevel = MVDLogger.Str2Level(stroLevel);
                String streLevel = (String)standaloneProps.get("EXTENSIONLEVEL");
                eLevel = MVDLogger.Str2Level(streLevel);
                aLoc = (String)standaloneProps.get("OPERLOGLOCATION");
                if (aLoc == null) {
                    aLoc = wa + "\\logs\\operation.trc";
                }
            }
            mLocationMapping.put(s, extension);
            String sc = MVDGlobals.getConfigurationName();
            Location aoperlocation = (Location)mOperLoggers.get(s);
            if (aoperlocation == null) {
                aoperlocation = Location.getLocation("com.sap.idm.vds." + sc + ".oper." + extension);
            }
            if (aoperlocation == null) {
                System.out.println("Can not create SAP Logging Location ... ");
                return;
            }
            if (bStandalone) {
                aoperlocation.setEffectiveSeverity(oLevel);
                Collection c = aoperlocation.getLogs();
                if (c.size() > 0) {
                    Iterator iterator = c.iterator();
                    while (iterator.hasNext()) {
                        FileLog fl = (FileLog)iterator.next();
                        fl.close();
                        fl = new FileLog(aLoc);
                    }
                } else {
                    aoperlocation.addLog(new FileLog(aLoc));
                }
            }
            mOperLoggers.put(s, aoperlocation);
            Location aextensionlocation = (Location)mExtensionLoggers.get(s);
            if (aextensionlocation == null) {
                aextensionlocation = Location.getLocation("com.sap.idm.vds." + sc + ".extension." + extension);
            }
            if (aextensionlocation == null) {
                System.out.println("Can not create SAP Logging Location ... ");
                return;
            }
            if (bStandalone) {
                aextensionlocation.setEffectiveSeverity(eLevel);
                Collection c = aextensionlocation.getLogs();
                if (c.size() > 0) {
                    Iterator iterator = c.iterator();
                    while (iterator.hasNext()) {
                        FileLog fl = (FileLog)iterator.next();
                        fl.close();
                        fl = new FileLog(aLoc);
                    }
                } else {
                    aextensionlocation.addLog(new FileLog(aLoc));
                }
            }
            mExtensionLoggers.put(s, aextensionlocation);
            if (mCat != null) continue;
            mCat = Category.getCategory(Category.APPLICATIONS, mCategoryName);
            mCat.setEffectiveSeverity(0);
            if (!bStandalone) continue;
            mCat.addLog(new FileLog(aLoc));
        }
    }

    public static void removeLoggers(Vector aLoggerKeys) {
        for (int i = 0; i < aLoggerKeys.size(); ++i) {
            String s = (String)aLoggerKeys.elementAt(i);
            mOperLoggers.remove(s);
            mExtensionLoggers.remove(s);
            mLocationMapping.remove(s);
        }
    }

    public static void initSNMP(String aDestination, int aPort) {
        try {
            trapSender = new SNMPTrap(aDestination, aPort);
        }
        catch (Exception e) {
            MVDLogger.Log("Could not locate SNMP trap receiver: " + e, 6);
        }
    }

    public static void LogDataToFile(String prefix, String message) {
        MVDLogger.LogDataToFile(prefix, message.getBytes());
    }

    public static void LogDataToFile(String prefix, byte[] message) {
        boolean successDelete;
        if (!MVDLogger.isWriteASNFiles()) {
            return;
        }
        String FileName = prefix + "_" + ++mAsnDumpCounter + ".asn";
        File f = new File(FileName);
        if (!f.isAbsolute()) {
            String conffile = MVDGlobals.getConfigurationFile();
            File workarea = new File(conffile).getParentFile();
            File logsdir = new File(workarea, "asn");
            if (!logsdir.exists()) {
                try {
                    logsdir.mkdir();
                }
                catch (Exception e) {
                    MVDLogger.Log("Unable to create directory for asn files", 7);
                }
            }
            f = new File(logsdir, FileName);
        }
        if (f.exists() && !(successDelete = f.delete())) {
            return;
        }
        FileOutputStream writeFile = null;
        try {
            writeFile = new FileOutputStream(f);
            writeFile.write(message, 0, message.length);
            writeFile.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static boolean IsLogging(int level) {
        String loggerKey = "";
        loggerKey = MVDServer.getMVDProtocol() == 0 ? Thread.currentThread().getThreadGroup().getName() : "Web Service:" + MVDServer.getUniqueInstanceID();
        Location mOperLogger = (Location)mOperLoggers.get(loggerKey);
        if (mOperLogger == null) {
            System.err.println("Oper logger for " + loggerKey + " not defined");
            return false;
        }
        switch (mMapMVDLoglevels2SapSeverity[level]) {
            case 701: {
                return false;
            }
            case 500: {
                return mOperLogger.beError();
            }
            case 400: {
                return mOperLogger.beWarning();
            }
            case 300: {
                return mOperLogger.beInfo();
            }
            case 600: {
                return mOperLogger.beFatal();
            }
            case 100: {
                return mOperLogger.beDebug();
            }
            case 0: {
                return true;
            }
        }
        return true;
    }

    private static void logToSap(String loggerName, String aMsg, Throwable ta, int severity, int logType) {
        if (severity == -1) {
            severity = 400;
            aMsg = aMsg + " (Couldn't identify severity of log4j logging event)";
        }
        Location aLoc = null;
        aLoc = logType == 0 ? (Location)mOperLoggers.get(loggerName) : (Location)mExtensionLoggers.get(loggerName);
        if (severity <= 400) {
            if (mAvoidEmptyLog) {
                if (aLoc.getEffectiveSeverity() == 300) {
                    for (int x = 0; x < mEmptyLogStrings.size(); ++x) {
                        String s = (String)mEmptyLogStrings.elementAt(x);
                        if (!s.equalsIgnoreCase(aMsg)) continue;
                        return;
                    }
                }
                if (mMaskFilter > 0 && aMsg.startsWith("Search request: ")) {
                    aMsg = "Search request: " + mMaskValue + aMsg.substring(16 + mMaskFilter);
                }
            }
            if (ta == null) {
                aLoc.logT(severity, aMsg);
            } else {
                aLoc.traceThrowableT(severity, aMsg, ta);
            }
        } else if (severity != 701) {
            if (ta == null) {
                mCat.logT(severity, aLoc, aMsg);
            } else {
                mCat.logThrowableT(severity, aLoc, aMsg, ta);
            }
        }
    }

    private static void logToSapCat(String loggerName, String aMsg, int severity) {
        Location aLoc = (Location)mOperLoggers.get(loggerName);
        if (severity != 701) {
            mCat.logT(severity, aLoc, aMsg);
        }
    }

    public static void Log(String message, int level, Throwable aThrowable) {
        String loggerKey = "";
        loggerKey = MVDServer.getMVDProtocol() == 0 ? Thread.currentThread().getThreadGroup().getName() : "Web Service:" + MVDServer.getUniqueInstanceID();
        MVDLogger.logToSap(loggerKey, message, null, mMapMVDLoglevels2SapSeverity[level], 0);
    }

    public static void Debug(String message, int level, Throwable aThrowable) {
        String loggerKey = "";
        loggerKey = MVDServer.getMVDProtocol() == 0 ? Thread.currentThread().getThreadGroup().getName() : "Web Service:" + MVDServer.getUniqueInstanceID();
        String extension = (String)mLocationMapping.get(loggerKey);
        if (extension == null) {
            extension = "unknown";
        }
        MVDLogger.logToSap(loggerKey, message, null, mMapMVDLoglevels2SapSeverity[level], 1);
    }

    public static void Log(String message, int level) {
        MVDLogger.Log(message, level, null);
    }

    public static void LogCat(String message) {
        Location aLoc = (Location)mOperLoggers.get("main");
        mCat.logT(300, aLoc, message);
    }

    public static void Debug(String message, int level) {
        MVDLogger.Debug(message, level, null);
    }

    public static void Debug(String message) {
        MVDLogger.Debug(message, 2, null);
    }

    public static boolean sendTrap(int aMessageType, String aMessage, int aLogLevel) {
        if (aLogLevel > MVDSnmpSettings.SnmpTrapLevel()) {
            return true;
        }
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(aMessageType, aMessage);
    }

    public static boolean sendTrap(HashMap OIDMessagePairs, int aLogLevel) {
        if (aLogLevel > MVDSnmpSettings.SnmpTrapLevel()) {
            return true;
        }
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(OIDMessagePairs);
    }

    public static boolean sendTrap(int aMessageType, String aMessage) {
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(aMessageType, aMessage);
    }

    public static boolean sendTrap(HashMap OIDMessagePairs) {
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(OIDMessagePairs);
    }

    public static boolean sendTrap(String aEnterpriseOID, int aGenericType, int aSpecificType, String aMessageOID, String aMessage) {
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(aEnterpriseOID, aGenericType, aSpecificType, aMessageOID, aMessage);
    }

    public static boolean sendTrap(String aEnterpriseOID, int aGenericType, int aSpecificType, HashMap OIDMessagePairs) {
        if (trapSender == null || !MVDSnmpSettings.EnableSnmpTraps()) {
            return false;
        }
        return trapSender.sendTrap(aEnterpriseOID, aGenericType, aSpecificType, OIDMessagePairs);
    }

    public static boolean sendTrap(String aDestination, int aPort, String aCommunity, String aEnterpriseOID, int aGenericType, int aSpecificType, String aMessageOID, String aMessage) {
        try {
            SNMPTrap trapSend = new SNMPTrap(aDestination, aPort);
            trapSend.setCommunity(aCommunity);
            return trapSend.sendTrap(aEnterpriseOID, aGenericType, aSpecificType, aMessageOID, aMessage);
        }
        catch (Exception e) {
            MVDLogger.Log("Failed sending trap: " + e, 4);
            return false;
        }
    }

    public static boolean sendTrap(String aDestination, int aPort, String aCommunity, String aEnterpriseOID, int aGenericType, int aSpecificType, HashMap OIDMessagePairs) {
        try {
            SNMPTrap trapSend = new SNMPTrap(aDestination, aPort);
            trapSend.setCommunity(aCommunity);
            return trapSend.sendTrap(aEnterpriseOID, aGenericType, aSpecificType, OIDMessagePairs);
        }
        catch (Exception e) {
            MVDLogger.Log("Failed sending trap: " + e, 7, e);
            return false;
        }
    }

    public static void main(String[] argv) {
        boolean result = MVDLogger.sendTrap("localhost", 162, "public", "1.3.6.1.4.1.9331", 6, 2, "1.3.6.1.4.1.9331.2.89", "Cash-overflow");
        System.out.println(result);
    }

    static {
        mWriteASNFiles = false;
        mMaskFilter = 0;
        mMaskValue = "";
        mAvoidEmptyLog = false;
        mEmptyLogStrings = new Vector();
        mAsnDumpCounter = 0L;
        mLocationMapping = new HashMap();
        mMapMVDLoglevels2SapSeverity = new int[9];
        MVDLogger.mMapMVDLoglevels2SapSeverity[8] = 701;
        MVDLogger.mMapMVDLoglevels2SapSeverity[7] = 500;
        MVDLogger.mMapMVDLoglevels2SapSeverity[6] = 400;
        MVDLogger.mMapMVDLoglevels2SapSeverity[5] = 300;
        MVDLogger.mMapMVDLoglevels2SapSeverity[4] = 300;
        MVDLogger.mMapMVDLoglevels2SapSeverity[3] = 300;
        MVDLogger.mMapMVDLoglevels2SapSeverity[2] = 100;
        MVDLogger.mMapMVDLoglevels2SapSeverity[1] = 100;
        MVDLogger.mMapMVDLoglevels2SapSeverity[0] = 0;
    }
}

