/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDAuthGlobals;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.message.MxContext;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;

public class MVDInternalContext
extends MxContext {
    public MxResponse answerRequest(MxRequest aMxrequest) throws MVDException {
        if (this.mEngine == null) {
            throw new MVDException(-1023, "Engine not initialized");
        }
        try {
            return this.mEngine.internalAnswerRequest(aMxrequest);
        }
        catch (Exception e) {
            throw new MVDException(-1023, e.getMessage());
        }
    }

    public void bind(MVDEngineData aEngData, int aTree) throws MVDException {
        MVDDebitInfo debinfo = aEngData.MvdDebit();
        MVDUserGroup ug = MVDUserGroupList.getUGByID(Integer.MAX_VALUE - aTree);
        MVDUserGroup onbehalfof = aEngData.MvdSessionsUserGroup();
        if (ug == null) {
            throw new MVDException(-1023, "Internal Usergroup not found");
        }
        if (onbehalfof.isInternal() && aEngData.getOnBehalfOf() != null) {
            onbehalfof = aEngData.getOnBehalfOf();
        }
        MVDAuthGlobals authglobals = aEngData.getAuthGlobals();
        this.bind(debinfo.UserName(), debinfo.UserPwd(), ug, debinfo.ClientIPAddress(), onbehalfof, authglobals);
    }

    public void bind(String aUsername, String aPassword, MVDUserGroup aUg, String aClientIP, MVDUserGroup aOnbehalfOf, MVDAuthGlobals aAuthGlobals) throws MVDException {
        if (this.mEngine == null) {
            throw new MVDException(-1023, "Engine not initialized");
        }
        MVDDebitInfo debinfo = this.mEngine.getEngineData().MvdDebit();
        debinfo.SetUserName(aUsername);
        debinfo.SetUserPwd(aPassword);
        debinfo.SetClientIPAddress(aClientIP);
        debinfo.SetUserGroup(aUg.Name());
        this.mEngine.getEngineData().SetMvdSessionsUserGroup(aUg);
        this.mEngine.getEngineData().SetIAmBinded(true);
        this.mEngine.getEngineData().setOnBeHalfOf(aOnbehalfOf);
        this.mEngine.getEngineData().setAuthGlobals(aAuthGlobals);
    }
}

