/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.config.MVDCache;
import com.sap.idm.vds.config.MVDCacheList;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import java.util.HashMap;
import java.util.Vector;

public class MVDCacheUtil {
    private static int nextCacheID = -2;
    private static HashMap localCache = new HashMap();
    public static final String GLOBAL_CACHE = "GLOBAL_CACHE";

    private static boolean add_to_cache_expanded(String datasource, MVDSearchResults entries) {
        if (datasource.equals(GLOBAL_CACHE)) {
            MVDCachePool.instance().addEntriesExpanded(null, entries);
            return true;
        }
        MVDCache cache = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (cache != null) {
            MVDCachePool.instance().addEntriesExpanded(cache, entries);
            return true;
        }
        return false;
    }

    private static boolean add_to_cache_clob(String datasource, MVDSearchResults entries, int typeOfAdd, String keyDn, int opType, String keyFilter) {
        String constructedKey = "";
        if (keyDn == null || keyFilter == null) {
            MVDLogger.Log("Can not construct Cache-key-DN, missing keyDN or keyFilter", 2);
            return false;
        }
        constructedKey = keyDn;
        constructedKey = opType == 1 ? constructedKey + "!!one!!" : constructedKey + "!!sub!!";
        constructedKey = constructedKey + keyFilter;
        if (datasource.equals(GLOBAL_CACHE)) {
            MVDCachePool.instance().addEntriesClob(null, entries, constructedKey);
            return true;
        }
        MVDCache cache = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (cache != null) {
            MVDCachePool.instance().addEntriesClob(cache, entries, constructedKey);
            return true;
        }
        return false;
    }

    public static boolean addToCache(String datasource, MVDSearchResults entries) {
        return MVDCacheUtil.add_to_cache_expanded(datasource, entries);
    }

    public static boolean addToCache(String datasource, MVDSearchResults entries, int typeOfAdd, String keyDn, int opType, String keyFilter) {
        boolean b = true;
        if (typeOfAdd == 3) {
            b = MVDCacheUtil.add_to_cache_expanded(datasource, entries);
        }
        if (typeOfAdd == 2 && b) {
            return MVDCacheUtil.add_to_cache_clob(datasource, entries, typeOfAdd, keyDn, opType, keyFilter);
        }
        return b;
    }

    public static MVDSearchResults getFromCache(String datasource, String dn, Vector requestedAttributes) {
        if (datasource.equals(GLOBAL_CACHE)) {
            return MVDCachePool.instance().getEntry(null, dn, requestedAttributes, 0, null);
        }
        MVDCache cache = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (cache != null) {
            return MVDCachePool.instance().getEntry(cache, dn, requestedAttributes, 0, null);
        }
        return null;
    }

    public static MVDSearchResults getFromCache(String datasource, String dn, Vector requestedAttributes, int operation, String urlfilter) {
        String constructedKey = dn;
        constructedKey = operation == 1 ? constructedKey + "!!one!!" : constructedKey + "!!sub!!";
        constructedKey = constructedKey + urlfilter;
        if (datasource.equals(GLOBAL_CACHE)) {
            return MVDCachePool.instance().getEntry(null, constructedKey, requestedAttributes, operation, null);
        }
        MVDCache cache = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (cache != null) {
            return MVDCachePool.instance().getEntry(cache, constructedKey, requestedAttributes, operation, null);
        }
        return null;
    }

    public static void deleteFromCache(String datasource, String dn) {
        MVDCache cache;
        if (datasource.equals(GLOBAL_CACHE)) {
            MVDCachePool.instance().deleteFromCache(dn, -1);
        }
        if ((cache = MVDCacheUtil.mapDSNameToConfig(datasource)) != null) {
            MVDCachePool.instance().deleteFromCache(dn, cache.DataSource());
        }
    }

    public static void deleteFromCache(String datasource, String dn, int operation, String urlfilter) {
        MVDCache cache;
        String constructedKey = dn;
        constructedKey = operation == 1 ? constructedKey + "!!one!!" : constructedKey + "!!sub!!";
        constructedKey = constructedKey + urlfilter;
        if (datasource.equals(GLOBAL_CACHE)) {
            MVDCachePool.instance().deleteFromCache(constructedKey, -1);
        }
        if ((cache = MVDCacheUtil.mapDSNameToConfig(datasource)) != null) {
            MVDCachePool.instance().deleteFromCache(constructedKey, cache.DataSource());
        }
    }

    public static boolean createCache(String datasource, int ttl, boolean extendBase, boolean extendSubOne) {
        MVDCache test = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (test != null) {
            return false;
        }
        int cacheid = nextCacheID--;
        MVDCache mvdc = new MVDCache();
        mvdc.SetOverride_attrs(extendBase);
        mvdc.SetCacheOne_Sub(extendSubOne);
        mvdc.setEnabled(true);
        mvdc.SetTTL(ttl);
        mvdc.SetDataSource(cacheid);
        localCache.put(datasource, mvdc);
        MVDCachePool.instance().userCreateCache(cacheid, datasource, ttl);
        return true;
    }

    public static boolean removeCache(String datasource) {
        MVDCache cache = (MVDCache)localCache.remove(datasource);
        if (cache != null) {
            MVDCachePool.instance().userRemoveCache(cache.DataSource());
            return true;
        }
        return false;
    }

    public static boolean cleanAllEntries(String datasource) {
        if (datasource.equals(GLOBAL_CACHE)) {
            return MVDCachePool.instance().cleanAllEntries(-1);
        }
        MVDCache cache = MVDCacheUtil.mapDSNameToConfig(datasource);
        if (cache != null) {
            return MVDCachePool.instance().cleanAllEntries(cache.DataSource());
        }
        return false;
    }

    private static MVDCache mapDSNameToConfig(String dsname) {
        MVDDataSource ds = MVDDataSourceList.getDSByName(dsname);
        if (ds == null) {
            MVDCache config = (MVDCache)localCache.get(dsname);
            return config;
        }
        MVDCache conf = MVDCacheList.getCacheByDSID(ds.IID());
        return conf;
    }

    public static long getCacheHits() {
        return MVDCachePool.instance().getCacheHits();
    }

    public static long getCacheReadOperations() {
        return MVDCachePool.instance().getCacheReadOperations();
    }

    public static int getCacheSize() {
        return MVDCachePool.instance().getCacheSize();
    }

    public static long getCacheWrites() {
        return MVDCachePool.instance().getCacheWrites();
    }

    public static void runGarbageCollector() {
        MVDCachePool.instance().runGarbageCollector();
    }
}

