/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.util.Base64;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class MCHandler {
    private Connection mConnection = null;
    private String mDriverName = null;
    private String mDatabaseURL = null;
    private String mCfgName = "";
    private static String sJobDefinitionField = "CFG_DEFINITION";
    private static String sJobNameField = "CFG_NAME";

    public MCHandler(String aDbURL) throws SQLException {
        try {
            this.mDatabaseURL = this.parseDatabaseURL(aDbURL);
            this.mConnection = DriverManager.getConnection(this.mDatabaseURL);
            this.mCfgName = "";
        }
        catch (Exception e) {
            int y = 2;
            int z = 3;
            MVDError.ConfigError("Error when getting connection: " + this.mDatabaseURL);
            boolean x = true;
        }
    }

    private String parseDatabaseURL(String aDbURL) {
        String test = aDbURL.toLowerCase().trim();
        String result = aDbURL;
        if (test.startsWith("dsn=")) {
            result = "jdbc:odbc:" + aDbURL.substring(4);
        } else if (!test.startsWith("jdbc:")) {
            result = "jdbc:odbc:" + result;
        }
        return result;
    }

    public String getConfig(String aCfgName) {
        String result = null;
        try {
            Statement statement = this.mConnection.createStatement();
            statement.execute("SELECT CFG_DEFINITION FROM MVD_CFG WHERE CFG_NAME='" + aCfgName + "'");
            ResultSet rs = statement.getResultSet();
            if (rs.next()) {
                ResultSetMetaData metadata = rs.getMetaData();
                if (metadata.getColumnType(1) == 2005) {
                    Clob job = rs.getClob(1);
                    Long l = new Long(job.length());
                    result = job.getSubString(1L, l.intValue());
                } else {
                    result = rs.getString(1);
                }
                if (result.substring(0, 5).equalsIgnoreCase("{B64}")) {
                    String sTemp = result.substring(5);
                    byte[] bTemp = Base64.decode(sTemp);
                    result = new String(bTemp);
                }
                this.mCfgName = aCfgName;
            }
            statement.close();
        }
        catch (Exception e) {
            MVDLogger.Log("Exception getting " + sJobDefinitionField + ":" + e, 8);
            result = null;
        }
        return result;
    }
}

