/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.ReloadableClassLoader;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.queue.MVDPriorityQueue;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

public class Globals {
    public static final String VDS_PRODUCT_NAME = "Virtual Directory Server";
    public static final String MVD_PRODUCT_NAME = "MaXware Virtual Directory";
    public static final String FED_PRODUCT_NAME = "Federation Server";
    private static String mDebitDelimiter = "_|_";
    private static String mStatisticsDelimiter = "_|_";
    private static Vector mExtendedSetForCaching = new Vector();
    private static Vector mOperationalAttributes = new Vector();
    private static Vector mJNDIOriginalBinaryAttr = new Vector();
    private static String mWorkArea;
    private static long ReceivedReqCnt;
    private static long ErrorReqCnt;
    private static long TimeOutErrorReqCnt;
    private static MVDPriorityQueue globalPriorityQueue;
    public static MVDHashMap mStartUpHash;
    public static boolean bLimitMinNrOfEngines;
    public static boolean bLimitMaxNrOfEngines;
    private static Vector mUniqueEngineIds;
    public static final int MSGH_COMMON_ID = -9999;
    public static final int MAX_NUMBER_ENGINES = 8000;
    public static final int NODE_TYPE_ROOTDSE = 11;
    public static final int NODE_TYPE_STATIC = 22;
    public static final int NODE_TYPE_VIRTUAL = 33;
    public static final int NODE_TYPE_CANDIDATE_FETCHED_FROM_CACHE = 111;
    public static final int NODE_TYPE_CANDIDATE_INVALIDATED_BY_FETCHING_FROM_CACHE = 222;
    public static final int NODE_TYPE_MVD_STATISTIC = 44;
    public static final int NODE_PREPARATION_OK = -1;
    public static final String IGNORED_FILTER = "(IGNOREDFILTER)";
    public static final String IGNORED_ATTR = "IGNOREDATTR";
    public static final String INVALID_FILTER = "(INVALIDFILTER)";
    public static final String INVALID_ATTR = "INVALIDATTR";
    public static final String FILTER_PASS_THROUGH = "(objectclass=*)";
    public static final String STR_BASE = "o=sap";
    public static final String CREDENTIALS = "";
    public static final Boolean bTrue;
    public static final Boolean bFalse;
    public static final String[] SearchTypeOperations;
    private static ReloadableClassLoader activeLoader;
    private static ReloadableClassLoader newLoader;
    private static URLClassLoader urlLoader;

    public static void blownAwayByThrowable(Throwable vte) {
        System.out.println("Throwable:" + vte);
        MVDLogger.Log("Throwable:" + vte, 7);
        System.out.println("FATAL error - shutting down");
        MVDLogger.Log("FATAL error - shutting down", 7);
        System.exit(1);
    }

    public static String getDebitDelimiter() {
        return mDebitDelimiter;
    }

    public static void setDebitDelimiter(String s) {
        mDebitDelimiter = s;
    }

    public static String getStatisticsDelimiter() {
        return mStatisticsDelimiter;
    }

    public static void setStatisticsDelimiter(String s) {
        mStatisticsDelimiter = s;
    }

    public static synchronized void IncErrorReqCount() {
        ++ErrorReqCnt;
    }

    public static synchronized void IncTimeOutErrorReqCount() {
        ++TimeOutErrorReqCnt;
    }

    public static long ErrorReqCount() {
        return ErrorReqCnt;
    }

    public static long TimeOutErrorReqCount() {
        return TimeOutErrorReqCnt;
    }

    public static MVDPriorityQueue getPriorityQueue() {
        return globalPriorityQueue;
    }

    public static void setPriorityQueue(MVDPriorityQueue aQ) {
        globalPriorityQueue = aQ;
    }

    public static Vector JNDIOriginalBinaryAttr() {
        return mJNDIOriginalBinaryAttr;
    }

    public static MVDHashMap StartUpHash() {
        return mStartUpHash;
    }

    public static Vector UniqueEngineIds() {
        return mUniqueEngineIds;
    }

    public static int GetUniqueEngineId() {
        if (mUniqueEngineIds.size() > 0) {
            return (Integer)mUniqueEngineIds.remove(0);
        }
        return -9999;
    }

    public static Vector getExtendedSetForCaching() {
        return mExtendedSetForCaching;
    }

    public static void setExtendedSetForCaching(Vector v) {
        mExtendedSetForCaching = v;
    }

    public static void setExtendedSetForCaching(String s) {
        Vector v = null;
        v = s.length() == 0 ? new Vector() : MVDUtil.splitString(s, ",");
        Globals.setExtendedSetForCaching(v);
    }

    public static Vector getOperationalAttributes() {
        return mOperationalAttributes;
    }

    public static void setOperationalAttributes(Vector v) {
        mOperationalAttributes = v;
    }

    public static void setOperationalAttributes(String s) {
        Vector v = null;
        v = s.length() == 0 ? new Vector() : MVDUtil.splitString(s, ",");
        Globals.setOperationalAttributes(v);
        Vector<String> e = new Vector<String>(v);
        e.add(0, "*");
        Globals.setExtendedSetForCaching(e);
    }

    public static String getWorkArea() {
        return mWorkArea;
    }

    public Globals(String aWorkarea) {
        mWorkArea = aWorkarea;
        mStartUpHash = new MVDHashMap();
        mUniqueEngineIds = new Vector(8000, 50);
        for (int i = 1; i <= 8000; ++i) {
            mUniqueEngineIds.add(new Integer(i));
        }
        bLimitMinNrOfEngines = true;
        bLimitMaxNrOfEngines = false;
        mJNDIOriginalBinaryAttr.add("photo");
        mJNDIOriginalBinaryAttr.add("personalsignature");
        mJNDIOriginalBinaryAttr.add("audio");
        mJNDIOriginalBinaryAttr.add("jpegphoto");
        mJNDIOriginalBinaryAttr.add("javaserializeddata");
        mJNDIOriginalBinaryAttr.add("thumbnailphoto");
        mJNDIOriginalBinaryAttr.add("thumbnaillogo");
        mJNDIOriginalBinaryAttr.add("userpassword");
        mJNDIOriginalBinaryAttr.add("usercertificate");
        mJNDIOriginalBinaryAttr.add("cacertificate");
        mJNDIOriginalBinaryAttr.add("authorityrevocationlist");
        mJNDIOriginalBinaryAttr.add("certificaterevocationlist");
        mJNDIOriginalBinaryAttr.add("crosscertificatepair");
        mJNDIOriginalBinaryAttr.add("x500uniqueidentifier");
    }

    public static Object GetExternalClass(String external) {
        try {
            return activeLoader.loadDaClass(external, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String AddExternalClass(String strVal) throws MVDConfigException {
        if (strVal.equalsIgnoreCase("As defined for data source") || strVal.equalsIgnoreCase("none")) {
            return "None";
        }
        try {
            String res = newLoader.loadDaClass(strVal, true) != null ? strVal : null;
            MVDLogger.Log("Loaded External: " + strVal, 1);
            return res;
        }
        catch (ClassNotFoundException e) {
            throw new MVDConfigException("Could not load external '" + strVal + "' or one of its referenced classes ");
        }
    }

    public static void initReload() {
        if (urlLoader == null) {
            File dir = mWorkArea != null ? new File(mWorkArea) : new File(".");
            FilenameFilter jarzipFilter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
                }
            };
            String[] children = dir.list(jarzipFilter);
            URL[] urls = new URL[children.length];
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    String filename = children[i];
                    try {
                        urls[i] = new File(mWorkArea, filename).toURL();
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            urlLoader = new URLClassLoader(urls);
        }
        newLoader = new ReloadableClassLoader(mWorkArea, urlLoader);
    }

    public static void applyReload() {
        activeLoader = newLoader;
    }

    static {
        ReceivedReqCnt = 0L;
        ErrorReqCnt = 0L;
        TimeOutErrorReqCnt = 0L;
        bTrue = Boolean.valueOf("true");
        bFalse = Boolean.valueOf("false");
        SearchTypeOperations = new String[]{"base", "one-level", "sub"};
        urlLoader = null;
    }
}

