/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.EngineCleaner;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDProxy;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import netscape.ldap.LDAPConnection;

public class EnginePool {
    private static long co = 0L;
    private static long cfh = 0L;
    private static long cfnew = 0L;
    private static long cntalrem = 0L;
    private static long cntnxtelem = 0L;
    private static long cleancollision = 0L;
    private long minFreeEngines = MVDProxy.Engines();
    private long maxFreeTime = MVDProxy.KeepEngine() > 0 ? (long)(MVDProxy.KeepEngine() * 1000) : 20000L;
    private long maxBusyTime = 600000L;
    private static Hashtable busyEngines;
    private static Hashtable freeEngines;
    private EngineCleaner cleaner;

    public EnginePool() {
        busyEngines = new Hashtable(100);
        freeEngines = new Hashtable(100);
        this.cleaner = new EngineCleaner(this, this.maxFreeTime);
        this.cleaner.start();
    }

    public static Engine create() throws Exception {
        return new Engine();
    }

    public static void checkIn(Engine o) {
        MVDLogger.Log("EnginePool: Check in engine id=" + o.SerialId(), 0);
        if (o != null) {
            long t = System.currentTimeMillis();
            MVDLogger.Log("EnginePool: Engine id=" + o.SerialId() + " lasted " + (t - (Long)busyEngines.get(o)), 0);
            busyEngines.remove(o);
            o.getEngineData().reset();
            freeEngines.put(o, new Long(t));
        }
    }

    public static Engine checkOut() throws Exception {
        ++co;
        MVDLogger.Log("EnginePool: Fetching one engine (new or existing) ", 0);
        Engine o = EnginePool.Synch_RemoveFromFree_PutInBusy();
        if (o == null) {
            ++cfnew;
            MVDLogger.Log("EnginePool: No free engines available", 0);
            o = EnginePool.create();
            busyEngines.put(o, new Long(System.currentTimeMillis()));
            MVDLogger.Log("EnginePool: Created engine id=" + o.SerialId(), 0);
        }
        return o;
    }

    private static synchronized Engine Synch_RemoveFromFree_PutInBusy() throws Exception {
        try {
            if (freeEngines.size() > 0) {
                Engine o = (Engine)freeEngines.keys().nextElement();
                Long t = (Long)freeEngines.remove(o);
                if (t != null) {
                    ++cfh;
                    busyEngines.put(o, new Long(System.currentTimeMillis()));
                    MVDLogger.Log("EnginePool: Checked out engine id=" + o.SerialId(), 0);
                    return o;
                }
                ++cntalrem;
                return null;
            }
            return null;
        }
        catch (Exception e) {
            ++cntnxtelem;
            return null;
        }
    }

    public void shutdown() {
        this.cleaner.shutdown();
    }

    public void cleanUpFreeEngines() {
        if (Globals.bLimitMinNrOfEngines && (long)freeEngines.size() <= this.minFreeEngines) {
            return;
        }
        long now = System.currentTimeMillis();
        Enumeration e = freeEngines.keys();
        while (e.hasMoreElements()) {
            try {
                Long t;
                Engine o = (Engine)e.nextElement();
                if (now - (Long)freeEngines.get(o) <= this.maxFreeTime || (t = (Long)freeEngines.remove(o)) == null) continue;
                int i = o.SerialId();
                this.clearEngineGlobals(o.getEngineGs());
                MVDLogger.Log("EnginePool: Cleaned and released id=" + i, 0);
                if (i != -9999) {
                    Globals.UniqueEngineIds().add(1, new Integer(i));
                }
                o = null;
                if (!Globals.bLimitMinNrOfEngines || (long)freeEngines.size() > this.minFreeEngines) continue;
                return;
            }
            catch (Exception de) {
                ++cleancollision;
            }
        }
    }

    public static int getFreeEnginesCount() {
        return freeEngines.size();
    }

    public static int getBusyEnginesCount() {
        return busyEngines.size();
    }

    private void clearEngineGlobals(MVDHashMap h) {
        Iterator it = h.keySet().iterator();
        while (it.hasNext()) {
            String aKeyName = (String)it.next();
            Object lctx = h.get(aKeyName);
            if (lctx == null) continue;
            try {
                if (lctx instanceof Context) {
                    ((Context)lctx).close();
                } else if (lctx instanceof Statement) {
                    ((Statement)lctx).close();
                }
                if (!(lctx instanceof LDAPConnection)) continue;
                LDAPConnection conn = (LDAPConnection)lctx;
                conn.disconnect();
            }
            catch (Exception e) {}
        }
        h.clear();
    }
}

