/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds;

import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import java.util.HashMap;

public abstract class AbstractAuthentication {
    protected String mUserName = null;
    protected String mPassword = null;
    protected String mClientIP = null;
    protected String mCertificate = null;
    protected String mUserGroup = null;
    protected String mListenerPort = null;
    protected MVDEngineData mEngineData = null;
    protected MVDHashMap mEngineGs = null;
    protected static final String REALDN = "REALDN";
    protected static final String DSUNIQNAME = "DSUNIQNAME";
    protected HashMap mSubResults = new HashMap();
    protected MVDHashMap mSessionGlobals = null;
    protected MVDHashMap mEngineGlobals = null;

    public void init(MVDHashMap sessionGlob, MVDHashMap engineGlob) {
        this.mSessionGlobals = sessionGlob;
        this.mEngineGlobals = engineGlob;
    }

    protected void getCommonParams(MVDHashMap aParams) {
        this.mUserName = (String)aParams.getLdapMandatoryParameter("USERNAME");
        MVDLogger.Debug("Received: " + this.mUserName + "/******");
        this.mPassword = (String)aParams.getLdapMandatoryParameter("USERPWD");
        this.mClientIP = (String)aParams.getLdapMandatoryParameter("CLIENTIP");
        this.mUserGroup = (String)aParams.getLdapMandatoryParameter("USERGROUP");
        this.mCertificate = (String)aParams.getLdapParameter("CERTIFICATE", null);
        this.mListenerPort = (String)this.mSessionGlobals.get("LISTENER_PORT");
        this.mEngineData = (MVDEngineData)aParams.get("ENGINE_DATA");
        this.mEngineGs = (MVDHashMap)aParams.get("ENGINE_GS");
    }

    public abstract String bind(MVDHashMap var1);

    protected String getSubResultRealDN() {
        return (String)this.mSubResults.get(REALDN);
    }

    protected void setSubResultDSUniqueName(String aDSUniqueName) {
        this.mSubResults.put(REALDN, aDSUniqueName);
    }

    protected String getSubResultDSUniqueName() {
        return (String)this.mSubResults.get(DSUNIQNAME);
    }

    protected void setSubResults(String aTree, String aUserName) {
        String dsUniqueName = MVDUtil.getUniqueDSNameByDN(aTree, aUserName);
        MVDLogger.Debug("The obtained unique datasource name is '" + dsUniqueName + "'");
        this.mSubResults.put(DSUNIQNAME, dsUniqueName);
        String realDN = MVDUtil.getProperDN(aTree, aUserName);
        MVDLogger.Debug("The obtained real DN is '" + realDN + "'");
        this.mSubResults.put(REALDN, realDN);
    }
}

