/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.connector.samplefile.impl;

import com.sap.idm.vds.connector.samplefile.impl.FileBasicOperations;
import com.sap.idm.vds.connector.samplefile.impl.FileFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class FileSearch {
    HashMap searchResult = new HashMap();
    HashMap attrList = null;

    public HashMap getSearchResult() {
        return this.searchResult;
    }

    public int search(String path, String filter, int option, boolean isDNDirectory) {
        File file = new File(path);
        if (!file.exists()) {
            return 3;
        }
        if (file.isDirectory() != isDNDirectory) {
            return 4;
        }
        this.searchResult.clear();
        if (option == 0) {
            return this.searchBase(path, filter);
        }
        if (option == 1) {
            return this.searchDeeper(path, filter, 1);
        }
        if (option == 2) {
            return this.searchDeeper(path, filter, 2);
        }
        return 1;
    }

    private int searchBase(String path, String filter) {
        File file = new File(path);
        if (!file.exists()) {
            return 3;
        }
        int code = this.makeFileAttrList(file);
        if (code != 0) {
            return code;
        }
        FileFilter fileFilter = new FileFilter();
        if (fileFilter.accept(this.attrList, filter)) {
            this.searchResult = this.attrList;
        }
        return 0;
    }

    private int searchDeeper(String dirPath, String filter, int option) {
        File file = new File(dirPath);
        if (!file.exists()) {
            return 3;
        }
        if (!file.isDirectory()) {
            return 8;
        }
        File[] files = file.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            if (files[i] != null && this.makeFileAttrList(files[i]) == 0) {
                FileFilter fileFilter = new FileFilter();
                if (fileFilter.accept(this.attrList, filter)) {
                    this.searchResult.put(files[i].getPath(), this.attrList);
                }
                if (option != 1 && files[i].isDirectory()) {
                    this.searchDeeper(files[i].getPath(), filter, option);
                }
            }
            ++i;
        }
        return 0;
    }

    private int makeFileAttrList(File file) {
        try {
            HashMap<String, String> attrList = new HashMap<String, String>();
            if (file.isDirectory()) {
                attrList.put("objectclass", "directory");
                attrList.put("dir", file.getName());
            } else {
                RandomAccessFile fileRA = new RandomAccessFile(file.getAbsolutePath(), "rw");
                FileBasicOperations operations = new FileBasicOperations(fileRA);
                attrList.put("content", operations.getContent((int)file.length()));
                attrList.put("objectclass", "file");
                fileRA.close();
                attrList.put("file", file.getName());
            }
            attrList.put("hidden", file.isHidden() ? "yes" : "no");
            attrList.put("permits", String.valueOf(file.canRead() ? "r" : "") + (file.canWrite() ? "w" : ""));
            attrList.put("path", file.getPath());
            this.attrList = attrList;
            return 0;
        }
        catch (FileNotFoundException fne) {
            return 3;
        }
        catch (IOException ioe) {
            return 9;
        }
    }

    public static void main(String[] args) {
        FileSearch fs = new FileSearch();
        fs.search("C:\\usr\\sap\\IdM\\Identity Center", "(objectclass=*)", 1, true);
        int x = 6;
    }
}

