/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.connector.samplefile.impl;

import java.io.IOException;
import java.io.RandomAccessFile;

public class FileBasicOperations {
    private static final int MAX_N_CHARS_TO_READ = 1000;
    private String str = null;
    private RandomAccessFile file = null;

    public FileBasicOperations(RandomAccessFile file) {
        this.file = file;
    }

    public FileBasicOperations(RandomAccessFile file, String newStr) {
        this.file = file;
        this.str = newStr;
    }

    void setFile(RandomAccessFile newFile) {
        this.file = newFile;
    }

    void setStr(String newStr) {
        this.str = newStr;
    }

    int addAtEnd() throws IOException {
        return this.addAtPosition((int)this.file.length(), this.str);
    }

    int addAtBeginning() throws IOException {
        return this.addAtPosition(0, this.str);
    }

    int addAtPosition(int pos) throws IOException {
        return this.addAtPosition(pos, this.str);
    }

    int addAtEnd(String newStr) throws IOException {
        return this.addAtPosition((int)this.file.length(), newStr);
    }

    int addAtBeginning(String newStr) throws IOException {
        return this.addAtPosition(0, newStr);
    }

    int addAtPosition(int pos, String newStr) throws IOException {
        if (newStr == null) {
            return 10;
        }
        this.str = newStr;
        if ((long)pos < this.file.length()) {
            this.file.seek(pos);
            String x = this.readChars();
            this.file.seek(pos);
            this.file.writeChars(this.str);
            this.file.seek(pos + this.str.length() * 2);
            this.file.writeChars(x);
        } else {
            if ((long)pos > this.file.length()) {
                pos = (int)this.file.length();
            }
            this.file.seek(pos);
            this.file.writeChars(this.str);
        }
        return 0;
    }

    public String readChars() {
        StringBuffer bs = new StringBuffer();
        int k = 0;
        while (k++ < 1000) {
            try {
                bs.append(this.file.readChar());
            }
            catch (Exception e) {
                break;
            }
        }
        return new String(bs);
    }

    String getContent(int nBytes) throws IOException {
        this.file.seek(0L);
        String res = this.readChars();
        return res.substring(0, Math.min(nBytes, res.length()));
    }

    void clean() {
        try {
            this.file.setLength(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

