/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.connector.samplefile.impl;

import com.sap.idm.vds.connector.samplefile.impl.GenericOperations;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterComplex;
import com.sap.idm.vds.filter.MVDFilterSimple;
import com.sap.idm.vds.filter.MVDFilterUtilities;
import java.util.Vector;
import java.util.regex.Pattern;

public class AcceptFilter {
    public boolean accept(String filter, String[] names, String[] values) {
        MVDFilter mFilter = MVDFilterUtilities.constructFilter((String)filter);
        return this.toFilter(mFilter, names, values);
    }

    private boolean internAccept(String filter, String[] names, String[] values) {
        String[] filterSplitted;
        filter = GenericOperations.cleanTrailingAndLeadingSpaces(filter);
        filter = GenericOperations.cleanParenthesis(filter);
        if ((filter = GenericOperations.cleanTrailingAndLeadingSpaces(filter)).length() == 0) {
            filter = "*=*";
        }
        if ((filterSplitted = filter.split("=")).length < 2) {
            return false;
        }
        String filterName = filterSplitted[0];
        String filterValue = filterSplitted[1];
        int i = 2;
        while (i < filterSplitted.length) {
            filterValue = String.valueOf(filterValue) + "=" + filterSplitted[i];
            ++i;
        }
        i = 0;
        while (i < names.length) {
            if (this.stringFilter(names[i], filterName) && this.stringFilter(values[i], filterValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean stringFilter(String str, String filter) {
        Pattern pattern = Pattern.compile("\\*");
        filter = pattern.matcher(filter).replaceAll(".*");
        return Pattern.matches(filter, str);
    }

    private boolean toFilter(MVDFilter aMVDFilter, String[] names, String[] values) {
        if (aMVDFilter instanceof MVDFilterSimple) {
            return this.toFilter((MVDFilterSimple)aMVDFilter, names, values);
        }
        return this.toFilter((MVDFilterComplex)aMVDFilter, names, values);
    }

    private boolean toFilter(MVDFilterSimple aMVDFilter, String[] names, String[] values) {
        String opstr = "";
        String value = null;
        String mAttrname = aMVDFilter.getAttrName();
        String mAttrvalue = aMVDFilter.getAttrValue();
        int mOptype = aMVDFilter.getOpType();
        if (mAttrname.equals("MVD_CLEANED")) {
            return false;
        }
        if (mAttrname.equals("MVD_IGNORED")) {
            return true;
        }
        value = mAttrvalue == null ? "*" : mAttrvalue;
        if (mOptype == 0 || mOptype == 1000) {
            opstr = "=";
        } else if (mOptype == 2) {
            opstr = ">";
        } else if (mOptype == 3) {
            opstr = "=";
        } else if (mOptype == 1) {
            opstr = "<";
        } else if (mOptype == 4) {
            opstr = "=";
        }
        String filter = "(" + mAttrname + opstr + value + ")";
        return this.internAccept(filter, names, values);
    }

    private boolean toFilter(MVDFilterComplex aMVDFilter, String[] names, String[] values) {
        int mFilterOpType = aMVDFilter.getFilterOpType();
        Vector mFilters = aMVDFilter.getFilters();
        MVDFilter mOne = (MVDFilter)mFilters.elementAt(0);
        if (mOne != null) {
            if (mFilterOpType == 13) {
                boolean tmp = mOne instanceof MVDFilterComplex ? this.toFilter((MVDFilterComplex)mOne, names, values) : this.toFilter((MVDFilterSimple)mOne, names, values);
                return !tmp;
            }
            if (mFilters.size() > 1) {
                if (mFilterOpType == 11) {
                    int x = 0;
                    while (x < mFilters.size()) {
                        boolean tmp;
                        if (mFilters.elementAt(x) instanceof MVDFilterComplex ? !(tmp = this.toFilter((MVDFilterComplex)mFilters.elementAt(x), names, values)) : !(tmp = this.toFilter((MVDFilterSimple)mFilters.elementAt(x), names, values))) {
                            return false;
                        }
                        ++x;
                    }
                    return true;
                }
                if (mFilterOpType == 12) {
                    int x = 0;
                    while (x < mFilters.size()) {
                        boolean tmp;
                        if (mFilters.elementAt(x) instanceof MVDFilterComplex ? (tmp = this.toFilter((MVDFilterComplex)mFilters.elementAt(x), names, values)) : (tmp = this.toFilter((MVDFilterSimple)mFilters.elementAt(x), names, values))) {
                            return true;
                        }
                        ++x;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        String[] names = new String[]{"firstname", "surname", "middelname", "personal email", "company email", "address", "fix phone", "mobile phone", "fax"};
        String[] values = new String[]{"emilio", "garcia tormo", "jose", "emilio@gemilio.com", "numberemilio@company.com", "downtown street, 20 A", "+47 12345678", "+47 22335588", "+47 12333321"};
        String[] filters = new String[]{"(*name*=emilio)", "(surname=emilio)", "(*phone=*12345678)", "(email=emilio*)", "(*email*=emilio*)", "*=*20*", "(&(*name*=emilio)(*phone=*8)(*name*=jose))", "(&(*name*=emilio)(*phone=*7))", "(|(*name*=emilio)(*phone=*7))", "(!(*name*=emilio))", "(!(firstname=emilio))", "(!(firstname=adsf))"};
        AcceptFilter af = new AcceptFilter();
        System.out.println("List of attributes\n--------------------");
        int i = 0;
        while (i < names.length) {
            System.out.println(String.valueOf(names[i]) + " --> " + values[i]);
            ++i;
        }
        System.out.println("\nResults of filtering\n-------------------");
        i = 0;
        while (i < filters.length) {
            System.out.println(String.valueOf(filters[i]) + (af.accept(filters[i], names, values) ? " is" : " is NOT") + " accepted");
            ++i;
        }
    }
}

