/*
 * Decompiled with CFR 0.152.
 */
import com.sap.idm.vds.AbstractOperation;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.connector.samplefile.impl.FileAdd;
import com.sap.idm.vds.connector.samplefile.impl.FileConstants;
import com.sap.idm.vds.connector.samplefile.impl.FileDelete;
import com.sap.idm.vds.connector.samplefile.impl.FileModify;
import com.sap.idm.vds.connector.samplefile.impl.FileSearch;
import com.sap.idm.vds.connector.samplefile.impl.GenericOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FileBrowserConnector
extends AbstractOperation {
    private final int ROOT_NAME = 0;
    private final int PATH = 1;
    private final int FILE_TYPE = 2;
    private final int FILE_NAME = 3;
    private final int ROOT_VALUE = 4;
    private final int PATH_UNTIL_FILE = 5;
    private final int NUMBER_OF_FIELDS = 6;
    private final int BASE_SEARCH = 0;
    private final int DELETE_OPTION_MODIFY = 1;

    private Vector DNtoOS(String dn, boolean searchOperation, String dn_dir, String dn_file) {
        String[] tokenizer = dn.split(",");
        ArrayList<String> list = new ArrayList<String>();
        Vector<String> res = new Vector<String>();
        String[] strs = new String[6];
        int i = 0;
        while (i < 6) {
            strs[i] = "";
            ++i;
        }
        if (!searchOperation && tokenizer.length == 1) {
            return null;
        }
        i = 0;
        while (i < tokenizer.length) {
            String[] aux;
            String token = tokenizer[i];
            if (token.indexOf("=") >= 0) {
                aux = token.split("=");
                if (i < tokenizer.length - 1 && !aux[0].equalsIgnoreCase(dn_file) && !aux[0].equalsIgnoreCase(dn_dir)) {
                    return null;
                }
                if (i > 0 && aux[0].equalsIgnoreCase(dn_file)) {
                    return null;
                }
                if (aux[0].equalsIgnoreCase(dn_file)) {
                    strs[2] = dn_file;
                }
                if (i == tokenizer.length - 1) {
                    strs[0] = aux[0];
                    strs[4] = aux[1];
                }
                if (i == 0) {
                    strs[3] = aux[1];
                }
            } else {
                return null;
            }
            list.add(aux[1]);
            ++i;
        }
        String path = list.get(list.size() - 1) + ":\\";
        int i2 = list.size() - 2;
        while (i2 >= 0) {
            if (i2 < list.size() - 2) {
                path = String.valueOf(path) + "\\";
            }
            if (i2 == 0) {
                strs[5] = path;
            }
            path = String.valueOf(path) + list.get(i2);
            --i2;
        }
        strs[1] = path;
        i2 = 0;
        while (i2 < 6) {
            res.add(strs[i2]);
            ++i2;
        }
        return res;
    }

    private String OStoDN(String path, String aType, String root, String dn_dir, String dn_file) {
        String[] tokenizer = path.split("\\\\");
        String dn = "";
        if (tokenizer.length > 1) {
            dn = aType.equalsIgnoreCase("directory") ? String.valueOf(dn) + dn_dir + "=" + tokenizer[tokenizer.length - 1] + "," : String.valueOf(dn) + dn_file + "=" + tokenizer[tokenizer.length - 1] + ",";
        }
        int i = tokenizer.length - 2;
        while (i >= 1) {
            dn = String.valueOf(dn) + dn_dir + "=" + tokenizer[i] + ",";
            --i;
        }
        dn = String.valueOf(dn) + root + "=" + tokenizer[0].split(":")[0];
        return dn;
    }

    private Vector searchAttrByName(Vector v, String name) {
        MVDModAttrValues res = new MVDModAttrValues();
        int i = 0;
        while (i < v.size()) {
            String attrName = ((MVDModAttrValues)v.get(i)).getAttrName();
            if (attrName.equalsIgnoreCase(name)) {
                res.add(v.get(i));
            }
            ++i;
        }
        if (res.size() > 0) {
            return res;
        }
        return null;
    }

    public MVDOperationResult bind(MVDHashMap param) {
        MVDOperationResult result = new MVDOperationResult();
        return result;
    }

    public MVDSearchResults search(MVDHashMap param) {
        MVDSearchResults result = new MVDSearchResults();
        String dn_dir = (String)param.getDSMandatoryParameter("DN_DIRECTORY");
        String dn_file = (String)param.getDSMandatoryParameter("DN_FILE");
        String aSp = (String)param.getLdapMandatoryParameter("STARTINGPOINT");
        int searchOpt = (Integer)param.getLdapMandatoryParameter("OPSUBTYPE");
        String filter = (String)param.getLdapMandatoryParameter("URLFILTER");
        String checkFilter = GenericOperations.cleanTrailingAndLeadingSpaces(filter);
        if (!checkFilter.endsWith(")") || !checkFilter.startsWith("(") || checkFilter.indexOf("=") < 0) {
            result.set(87, (Object)"Invalid filter format");
            return result;
        }
        Vector v = this.DNtoOS(aSp, true, dn_dir, dn_file);
        if (v == null) {
            result.setError(34, "Error in DN format for this operation");
            return result;
        }
        String path = (String)v.get(1);
        if (path == null) {
            result.setError(21, "Null Path");
            return result;
        }
        boolean isDNDirectory = !((String)v.get(2)).equalsIgnoreCase(dn_file);
        String root_name = (String)v.get(0);
        FileSearch fs = new FileSearch();
        int resCode = fs.search(path, filter, searchOpt, isDNDirectory);
        if (resCode != 0) {
            result.setError(FileConstants.LDAP_CODES[resCode], FileConstants.MESSAGES[resCode]);
            return result;
        }
        if (!isDNDirectory && searchOpt != 0) {
            result.setError(21, "This search operation is only possible for directories");
            return result;
        }
        HashMap res = fs.getSearchResult();
        if (searchOpt == 0) {
            if (res.size() > 0) {
                MVDSearchResultEntry e = new MVDSearchResultEntry();
                e.setDn(aSp);
                Iterator it = res.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String val = (String)res.get(key);
                    e.setAttrValue(key, true, val);
                }
                result.add((Object)e);
            }
        } else {
            Iterator it = res.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                HashMap aType = (HashMap)res.get(key);
                MVDSearchResultEntry e = new MVDSearchResultEntry();
                String fileType = (String)aType.get("objectclass");
                e.setDn(this.OStoDN(key, fileType, root_name, dn_dir, dn_file));
                e.setAttrValue("objectclass", true, (String)aType.get("objectclass"));
                String ident = null;
                ident = aType.containsKey(dn_dir) ? dn_dir : dn_file;
                e.setAttrValue(ident, true, (String)aType.get(ident));
                result.add((Object)e);
            }
        }
        result.setOK();
        return result;
    }

    public MVDOperationResult modify(MVDHashMap param) {
        FileModify fileMod;
        int resCode;
        boolean isDNDirectory;
        MVDOperationResult result = new MVDOperationResult();
        String dn_dir = (String)param.getGlobalMandatoryParameter("DN_DIRECTORY");
        String dn_file = (String)param.getGlobalMandatoryParameter("DN_FILE");
        String dn = (String)param.getLdapMandatoryParameter("DN");
        Vector v = this.DNtoOS(dn, false, dn_dir, dn_file);
        if (v == null) {
            result.setError(34, "Error in DN format for this operation");
            return result;
        }
        String path = (String)v.get(1);
        boolean bl = isDNDirectory = !((String)v.get(2)).equalsIgnoreCase(dn_file);
        if (isDNDirectory) {
            result.setError(34, "This operation is not allowed of this type of entries");
            return result;
        }
        Vector vData = (Vector)param.getLdapMandatoryParameter("DATA");
        Vector attrs = this.searchAttrByName(vData, "content");
        String content = "";
        int modType = -1;
        if (attrs != null && attrs.size() > 0) {
            modType = ((MVDModAttrValues)attrs.firstElement()).getModType();
            if (modType == 1) {
                result.setError(21, "Delete option is not permitted for modify operations");
                return result;
            }
            if (attrs.size() > 1) {
                result.setError(21, "The attribute does not allow multivalue data " + vData);
                return result;
            }
            if (((MVDModAttrValues)attrs.firstElement()).size() > 0) {
                content = (String)((MVDModAttrValues)attrs.firstElement()).firstElement();
            }
        }
        if ((resCode = (fileMod = new FileModify()).modify(path, content, modType, isDNDirectory)) != 0) {
            result.setError(FileConstants.LDAP_CODES[resCode], FileConstants.MESSAGES[resCode]);
            return result;
        }
        result.setOK();
        return result;
    }

    public MVDOperationResult add(MVDHashMap param) {
        FileAdd file;
        int resCode;
        MVDOperationResult result = new MVDOperationResult();
        String dn_dir = (String)param.getGlobalMandatoryParameter("DN_DIRECTORY");
        String dn_file = (String)param.getGlobalMandatoryParameter("DN_FILE");
        String dn = (String)param.getLdapMandatoryParameter("DN");
        Vector v = this.DNtoOS(dn, false, dn_dir, dn_file);
        if (v == null) {
            result.setError(34, "Error in DN format for this operation");
            return result;
        }
        String path_until_file = (String)v.get(5);
        String fileName = (String)v.get(3);
        boolean isDNDirectory = !((String)v.get(2)).equalsIgnoreCase(dn_file);
        Object oData = param.getLdapMandatoryParameter("DATA");
        HashMap hData = null;
        hData = oData == null ? new HashMap() : (HashMap)oData;
        String content = "";
        if (!isDNDirectory) {
            Vector vContent;
            if (!hData.containsKey("file")) {
                result.setError(22, "Missed the mandatory attribute with name \"file\" " + hData);
                return result;
            }
            Vector vFile = (Vector)hData.get("file");
            if (vFile.size() != 1) {
                result.setError(21, "The attribute \"file\" must be a single attribute " + hData);
                return result;
            }
            String fileNameAtt = (String)vFile.get(0);
            if (!fileNameAtt.equalsIgnoreCase(fileName)) {
                result.setError(21, "The attribute \"file\" must have the same value as the related part in the DN " + hData);
                return result;
            }
            if (hData.size() == 2) {
                if (!hData.containsKey("content")) {
                    result.setError(21, "Only two attributes are accepted for this type of entry: \"file\" and \"content\" " + hData);
                    return result;
                }
            } else if (hData.size() < 1 || hData.size() > 2) {
                result.setError(21, "Only two attributes are accepted for this type of entry: \"file\" and \"content\" " + hData);
                return result;
            }
            if ((vContent = (Vector)hData.get("content")) != null) {
                if (vContent.size() != 1) {
                    result.setError(21, "The attribute \"content\" can only have one value " + vContent);
                    return result;
                }
                content = (String)vContent.get(0);
            }
        } else {
            if (!hData.containsKey("dir")) {
                result.setError(22, "Missed the mandatory attribute with name \"dir\" " + hData);
                return result;
            }
            Vector vDir = (Vector)hData.get("dir");
            if (vDir.size() != 1) {
                result.setError(21, "The attribute \"dir\" must be a single attribute " + hData);
                return result;
            }
            String dirNameAtt = (String)vDir.get(0);
            if (!dirNameAtt.equalsIgnoreCase(fileName)) {
                result.setError(21, "The attribute \"dir\" must have the same value as the related part in the DN " + hData);
                return result;
            }
            if (hData.size() != 1) {
                result.setError(21, "Only one attribute is accepted for this type of entry: \"dir\" " + hData);
                return result;
            }
        }
        if ((resCode = (file = new FileAdd()).add(path_until_file, fileName, content, isDNDirectory)) != 0) {
            result.setError(FileConstants.LDAP_CODES[resCode], FileConstants.MESSAGES[resCode]);
            return result;
        }
        result.setOK();
        return result;
    }

    public MVDOperationResult delete(MVDHashMap param) {
        boolean isDNDirectory;
        MVDOperationResult result = new MVDOperationResult();
        String dn_dir = (String)param.getGlobalMandatoryParameter("DN_DIRECTORY");
        String dn_file = (String)param.getGlobalMandatoryParameter("DN_FILE");
        String dn = (String)param.getLdapMandatoryParameter("DN");
        Vector v = this.DNtoOS(dn, false, dn_dir, dn_file);
        if (v == null) {
            result.setError(34, "Error in DN format for this operation");
            return result;
        }
        FileDelete fileDelete = new FileDelete();
        String path = (String)v.get(1);
        int resCode = fileDelete.delete(path, isDNDirectory = !((String)v.get(2)).equalsIgnoreCase(dn_file));
        if (resCode != 0) {
            result.setError(FileConstants.LDAP_CODES[resCode], FileConstants.MESSAGES[resCode]);
            return result;
        }
        result.setOK();
        return result;
    }

    public MVDOperationResult compare(MVDHashMap param) {
        MVDOperationResult result = new MVDOperationResult();
        return result;
    }

    public MVDOperationResult initialize(MVDHashMap param) {
        MVDOperationResult result = new MVDOperationResult();
        return result;
    }

    public MVDOperationResult terminate(MVDHashMap param) {
        MVDOperationResult result = new MVDOperationResult();
        return result;
    }
}

