/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Inv2i;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import com.sun.electric.tool.generator.layout.gates.WellTie;
import java.util.ArrayList;

public class Nand2PHfk {
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    public static Cell makePart(double sz, StdCellParams stdCell) {
        String nm = "nand2PHfk";
        sz = stdCell.roundSize(sz);
        Cell nand = stdCell.findPart(nm, sz = stdCell.checkMinStrength(sz, 1.0, nm));
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        String vddName = stdCell.getVddExportName();
        String gndName = stdCell.getGndExportName();
        PortCharacteristic vddRole = stdCell.getVddExportRole();
        PortCharacteristic gndRole = stdCell.getGndExportRole();
        NodeInst inv2i = LayoutLib.newNodeInst(Inv2i.makePart(sz, stdCell), 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        NodeInst pms1 = LayoutLib.newNodeInst(Pms1.makePart(sz, stdCell), 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        NodeInst invK = LayoutLib.newNodeInst(Inv.makePart(sz / 10.0, stdCell), 0.0, 0.0, -1.0, 1.0, 0.0, nand);
        NodeInst inv1 = LayoutLib.newNodeInst(Inv.makePart(1.0, stdCell), 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        ArrayList<NodeInst> l = new ArrayList<NodeInst>();
        l.add(inv2i);
        l.add(pms1);
        l.add(invK);
        l.add(inv1);
        LayoutLib.abutLeftRight(l);
        Cell tieCell = WellTie.makePart(true, false, pms1.getBounds().getWidth(), stdCell);
        NodeInst tie = LayoutLib.newNodeInst(tieCell, 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        LayoutLib.abutLeftRight(inv2i, tie);
        l.add(tie);
        TrackRouterH vdd = new TrackRouterH(Tech.m2(), 10.0, nand);
        vdd.connect(l, vddName);
        TrackRouterH gnd = new TrackRouterH(Tech.m2(), 10.0, nand);
        gnd.connect(l, gndName);
        TrackRouterH out = new TrackRouterH(Tech.m2(), 4.0, 11.0, nand);
        out.connect(new PortInst[]{inv2i.findPortInst("out"), pms1.findPortInst("d"), invK.findPortInst("out"), inv1.findPortInst("in")});
        TrackRouterH k = new TrackRouterH(Tech.m2(), 4.0, -11.0, nand);
        k.connect(new PortInst[]{invK.findPortInst("in"), inv1.findPortInst("out")});
        Export.newInstance(nand, inv2i.findPortInst("in[p]"), "inb").setCharacteristic(PortCharacteristic.IN);
        Export.newInstance(nand, inv2i.findPortInst("in[n]"), "resetN").setCharacteristic(PortCharacteristic.IN);
        Export.newInstance(nand, pms1.findPortInst("g"), "ina").setCharacteristic(PortCharacteristic.IN);
        Export.newInstance(nand, inv2i.findPortInst("out"), "out").setCharacteristic(PortCharacteristic.OUT);
        Export.newInstance(nand, inv2i.findPortInst(vddName), vddName).setCharacteristic(vddRole);
        Export.newInstance(nand, inv2i.findPortInst(gndName), gndName).setCharacteristic(gndRole);
        stdCell.addEssentialBounds(0.0, inv1.getBounds().getMaxX(), nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

