/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.Main;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class EDialog
extends JDialog {
    private static HashMap locations = new HashMap();
    private static HashMap sizes = new HashMap();
    private Class thisClass;
    public static DialogFocusHandler dialogFocusHandler = new DialogFocusHandler();
    public static TextBoxFocusListener textBoxFocusListener = new TextBoxFocusListener();

    protected EDialog(Frame parent, boolean modal) {
        super(parent, modal);
        if (Main.BATCHMODE) {
            return;
        }
        this.thisClass = this.getClass();
        Point pt = (Point)locations.get(this.thisClass);
        if (pt == null) {
            pt = new Point(100, 50);
        }
        this.setLocation(pt.x, pt.y);
        this.addComponentListener(new MoveComponentListener());
        String CANCEL_DIALOG = "cancel-dialog";
        KeyStroke accel = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(accel, "cancel-dialog");
        this.getRootPane().getActionMap().put("cancel-dialog", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                EDialog.this.escapePressed();
            }
        });
        if (parent == null && !TopLevel.isMDIMode()) {
            dialogFocusHandler.addEDialog(this);
        }
    }

    protected void finishInitialization() {
        Point sz = (Point)sizes.get(this.thisClass);
        if (sz != null) {
            this.setSize(sz.x, sz.y);
        }
    }

    protected void escapePressed() {
    }

    protected void focusClearOnTextField(JTextComponent textComponent) {
        textComponent.setSelectionStart(0);
        textComponent.setSelectionEnd(0);
    }

    protected void focusOnTextField(JTextComponent textComponent) {
        textComponent.setSelectionStart(0);
        textComponent.setSelectionEnd(textComponent.getDocument().getLength());
    }

    protected void centerSelection(JList list) {
        int listSize;
        int curIndex = list.getSelectedIndex();
        int lowIndexToEnsure = curIndex - (listSize = list.getLastVisibleIndex() - list.getFirstVisibleIndex()) / 2 + 1;
        if (lowIndexToEnsure < 0) {
            lowIndexToEnsure = 0;
        }
        list.ensureIndexIsVisible(lowIndexToEnsure);
        int highIndexToEnsure = curIndex + listSize / 2 - 1;
        if (highIndexToEnsure >= list.getModel().getSize()) {
            highIndexToEnsure = list.getModel().getSize() - 1;
        }
        list.ensureIndexIsVisible(highIndexToEnsure);
    }

    private static class DialogFocusHandler
    implements WindowFocusListener {
        private List dialogs = new ArrayList();

        private DialogFocusHandler() {
        }

        public synchronized void addEDialog(EDialog dialog) {
            this.dialogs.add(dialog);
        }

        public synchronized void windowGainedFocus(WindowEvent e) {
            for (int i = 0; i < this.dialogs.size(); ++i) {
                EDialog eDialog = (EDialog)this.dialogs.get(i);
            }
        }

        public void windowLostFocus(WindowEvent e) {
        }
    }

    private static class MoveComponentListener
    implements ComponentListener {
        private MoveComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Class<?> cls = e.getSource().getClass();
            Rectangle bound = ((JDialog)e.getSource()).getBounds();
            int x = bound.width;
            int y = bound.height;
            sizes.put(cls, new Point(x, y));
        }

        public void componentMoved(ComponentEvent e) {
            Class<?> cls = e.getSource().getClass();
            Rectangle bound = ((JDialog)e.getSource()).getBounds();
            int x = (int)bound.getMinX();
            int y = (int)bound.getMinY();
            locations.put(cls, new Point(x, y));
        }
    }

    private static class TextBoxFocusListener
    implements FocusListener {
        private TextBoxFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            JTextField textField;
            Component source = e.getComponent();
            if (source instanceof JTextField && (textField = (JTextField)source).isEnabled() && textField.isEditable()) {
                int len = textField.getDocument().getLength();
                textField.setSelectionStart(0);
                textField.setSelectionEnd(len);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

