/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StratPreanalysisReport
extends Strategy {
    private static final NetObject.Type PART = NetObject.Type.PART;
    private static final NetObject.Type PORT = NetObject.Type.PORT;
    List mismatched = new ArrayList();

    private StratPreanalysisReport(NccGlobals globals) {
        super(globals);
    }

    private boolean doYourJob2(NccGlobals globals) {
        this.doFor(globals.getRoot());
        this.summary();
        return this.mismatched.size() == 0;
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void printCircuitContents(Circuit ckt, int cktNdx, String t) {
        String cktName = this.globals.getRootCellNames()[cktNdx];
        int numNetObjs = ckt.numNetObjs();
        this.prln("      " + cktName + " has " + numNetObjs + " of these " + t + ":");
        int maxPrint = this.globals.getOptions().maxEquivRecMembersToPrint;
        if (ckt.numNetObjs() > maxPrint) {
            this.prln("        Too many " + t + "! I'll only print the first " + maxPrint);
        }
        Iterator it = ckt.getNetObjs();
        for (int numPrint = 0; it.hasNext() && numPrint <= maxPrint; ++numPrint) {
            NetObject o = (NetObject)it.next();
            this.prln("        " + o.fullDescription());
        }
    }

    private void printMismatchedRecord(EquivRecord r) {
        String t = r.getNetObjType() == PART ? "parts" : "wires";
        this.prln("    The " + t + " in this equivalence class share the following characteristics:");
        List reasons = r.getPartitionReasonsFromRootToMe();
        Iterator it = reasons.iterator();
        while (it.hasNext()) {
            this.prln("      " + it.next());
        }
        int cktNdx = 0;
        Iterator it2 = r.getCircuits();
        while (it2.hasNext()) {
            Circuit ckt = (Circuit)it2.next();
            this.printCircuitContents(ckt, cktNdx, t);
            ++cktNdx;
        }
    }

    private void summary() {
        if (this.mismatched.size() != 0) {
            this.prln("\n  Mismatches found during local partitioning:\n");
        }
        Iterator it = this.mismatched.iterator();
        while (it.hasNext()) {
            EquivRecord r = (EquivRecord)it.next();
            this.printMismatchedRecord(r);
        }
    }

    public LeafList doFor(EquivRecord g) {
        if (g.isLeaf()) {
            if (g.isMismatched() && g.getNetObjType() != PORT) {
                this.mismatched.add(g);
            }
            return new LeafList();
        }
        return super.doFor(g);
    }

    public static boolean doYourJob(NccGlobals globals) {
        StratPreanalysisReport wp = new StratPreanalysisReport(globals);
        return wp.doYourJob2(globals);
    }
}

