/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nor2kresetV {
    private static final double wellOverhangDiff = 6.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double wirePitch = 7.0;
    private static final double wireWithPolyPitch = 8.0;
    private static final double pmosBot = 8.5;
    private static final double nmosTop = -8.5;
    private static final double inaY = -4.0;
    private static final double inbLoY = 4.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        int i2;
        int i3;
        double totWid;
        String nm = "nor2kresetV";
        sz = stdCell.roundSize(sz);
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        int nbSeriesP = 2;
        double spaceAvail = stdCell.getCellTop() - 6.0 - 8.5;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = Math.max(3.0, sz / 10.0 * (double)nbSeriesP * 6.0), 1);
        Nor2kresetV.error(fwP == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -8.5 - (stdCell.getCellBot() + 6.0);
        totWid = Math.max(3.0, sz / 10.0 * 3.0);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nor2kresetV.error(fwN == null, "can't make " + nm + " this small: " + sz);
        totWid = sz * 3.0;
        spaceAvail = -8.5 - (stdCell.getCellBot() + 3.5 + 7.0 - 2.5);
        FoldsAndWidth fwS = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nor2kresetV.error(fwS == null, "can't make " + nm + " this small: " + sz);
        Cell nor = stdCell.findPart(nm, sz);
        if (nor != null) {
            return nor;
        }
        nor = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double inaX = inbX + 7.0;
        double jogX = inaX + 7.0;
        double pmosX = jogX + 7.0;
        double pmosY = 8.5 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(pmosX, pmosY, fwP.nbFolds, nbSeriesP, fwP.gateWid, nor, stdCell);
        double nmosX = pmosX + 5.0;
        double nmosY = -8.5 - fwN.physWid / 2.0;
        FoldedMos[] nmoss = new FoldedMos[(fwN.nbFolds + 1) / 2];
        for (int nbFoldsN = 0; nbFoldsN < fwN.nbFolds; nbFoldsN += 2) {
            double nmosPitch = 26.0;
            double x = nmosX + (double)(nbFoldsN / 2) * nmosPitch;
            int nbFolds = Math.min(2, fwN.nbFolds - nbFoldsN);
            FoldedNmos nmos = new FoldedNmos(x, nmosY, nbFolds, 1, fwN.gateWid, nor, stdCell);
            nmoss[nbFoldsN / 2] = nmos;
        }
        stdCell.fillDiffNotches(nmoss);
        double rightNDiffX = StdCellParams.getRightDiffX(nmoss, nmoss);
        double rightPDiffX = StdCellParams.getRightDiffX(pmos, pmos);
        double bigNmosX = Math.max(rightPDiffX, rightNDiffX + 11.0);
        double bigY = -8.5 - fwS.physWid / 2.0;
        FoldedNmos bigMos = new FoldedNmos(bigNmosX, bigY, fwS.nbFolds, 1, fwS.gateWid, nor, stdCell);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, nor);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, nor);
        double inbHiY = 11.0;
        LayoutLib.newExport(nor, "inb", PortCharacteristic.IN, Tech.m1, 4.0, inbX, inbHiY);
        PortInst jog = LayoutLib.newNodeInst(Tech.m1pin, jogX, inbHiY, 1.0, 1.0, 0.0, nor).getOnlyPortInst();
        TrackRouterH inbHi = new TrackRouterH(Tech.m2, 3.0, inbHiY, nor);
        inbHi.connect(nor.findExport("inb"));
        inbHi.connect(jog);
        TrackRouterH inb = new TrackRouterH(Tech.m1, 3.0, 4.0, nor);
        inb.connect(jog);
        for (i3 = 0; i3 < pmos.nbGates(); i3 += 2) {
            if (i3 / 2 % 2 == 0) {
                ((TrackRouter)inb).connect(pmos.getGate(i3 + 1, 'B'), 4.0, 1.5);
                continue;
            }
            ((TrackRouter)inb).connect(pmos.getGate(i3, 'B'), -4.0, 1.5);
        }
        for (i3 = 0; i3 < nmoss.length; ++i3) {
            FoldedMos mos = nmoss[i3];
            for (int j = 0; j < mos.nbGates(); ++j) {
                ((TrackRouter)inb).connect(mos.getGate(j, 'T'), j % 2 == 0 ? 4.0 : -4.0, -3.5);
            }
        }
        LayoutLib.newExport(nor, "ina", PortCharacteristic.IN, Tech.m1, 4.0, inaX, -4.0);
        TrackRouterH inA = new TrackRouterH(Tech.m1, 3.0, -4.0, nor);
        inA.connect(nor.findExport("ina"));
        for (i2 = 0; i2 < pmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                ((TrackRouter)inA).connect(pmos.getGate(i2, 'B'), -4.0, 1.5);
                continue;
            }
            ((TrackRouter)inA).connect(pmos.getGate(i2 + 1, 'B'), 4.0, 1.5);
        }
        for (i2 = 0; i2 < bigMos.nbGates(); ++i2) {
            ((TrackRouter)inA).connect(bigMos.getGate(i2, 'T'), 0.0, -1.5);
        }
        double resetX = StdCellParams.getRightDiffX(bigMos) + 2.0 + 3.0 + 2.0;
        double resetY = -8.5 - fwS.physWid + 2.5 - 7.0;
        LayoutLib.newExport(nor, "resetV", PortCharacteristic.IN, Tech.m1, 4.0, resetX, resetY);
        TrackRouterH reset = new TrackRouterH(Tech.m1, 3.0, resetY, nor);
        reset.connect(nor.findExport("resetV"));
        for (int i4 = 0; i4 < bigMos.nbSrcDrns(); i4 += 2) {
            reset.connect(bigMos.getSrcDrn(i4));
        }
        double outX = resetX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nor, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, nor);
        outHi.connect(nor.findExport("out"));
        for (int i5 = 1; i5 < pmos.nbSrcDrns(); i5 += 2) {
            outHi.connect(pmos.getSrcDrn(i5));
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nor);
        outLo.connect(nor.findExport("out"));
        for (i = 0; i < nmoss.length; ++i) {
            for (int j = 1; j < nmoss[i].nbSrcDrns(); j += 2) {
                outLo.connect(nmoss[i].getSrcDrn(j));
            }
        }
        for (i = 1; i < bigMos.nbSrcDrns(); i += 2) {
            outLo.connect(bigMos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nor);
        stdCell.addPmosWell(wellMinX, wellMaxX, nor);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nor);
        stdCell.doNCC(nor, nm + "{sch}");
        return nor;
    }
}

