### Name: hdist-class
### Title: Class "hdist" - S4 class to hold distance matrices.
### Aliases: hdist-class hdist is.hdist as.hdist as.hdist,matrix-method
###   as.matrix,hdist-method as.vector,hdist,missing-method [,hdist-method
###   coerce,matrix,hdist-method coerce,hdist,matrix-method
###   dim,hdist-method labels,hdist-method length,hdist-method
###   show,hdist-method
### Keywords: classes

### ** Examples

        showClass("hdist")

        library(hopach) 
        X <- matrix(rnorm(60,mean=10,sd=2),nrow=10,ncol=6,byrow=TRUE)
        dmat <- disscosangle(X) 
        dmat
        str(dmat) 
        
        # Examples where subsetting a hdist object returns a matrix...  
        dmat[c(3,4,5),c(5,6,7,8)]
        dmat[c(TRUE,FALSE),c(FALSE,TRUE)]
        dmat[c(4,5,6), ] 

        # Examples where subsetting a hdist object returns a hdist object...
        dmat[c(3,4,5,6,7),c(3,4,5,6,7)]
        dmat[c(TRUE,FALSE),c(TRUE,FALSE)]
        
        # Expand hdist object to a symmetric matrix...
        as.matrix(dmat)




