### Name: HighlightRegion-class
### Title: Class "HighlightRegion" is used to highlight vertical blocks of
###   genomic regions.
### Aliases: HighlightRegion-class
### Keywords: classes

### ** Examples

if (interactive()) {
data("exampleData", package="GenomeGraphs")

ga <- new("GenomeAxis")
grF <- new("GeneRegion", start = 10000, end = 20000, chromosome = "I", strand = "+", biomart = yeastMart)
grR <- new("GeneRegion", start = 10000, end = 20000, chromosome = "I", strand = "-", biomart = yeastMart)
bt <- new("BaseTrack", base = yeastCons1[,1], value = yeastCons1[,2])
hr1 <- new("HighlightRegion", start = 11000, end = 13000,
           dp = DisplayPars(alpha = 1, color = "red", lty = "dashed", lwd = 3))
hr2 <- new("HighlightRegion", start = 15900, end = 16500)
          
gdPlot(list(grF, ga, grR, bt), highlightRegions = list(hr1, hr2))
}



