### Name: lattice-methods
### Title: Methods implementing Lattice displays for flow data
### Aliases: qqmath levelplot parallel qqmath,formula,flowSet-method
###   levelplot,formula,flowSet-method parallel,flowFrame,missing-method
###   parallel,formula,flowSet-method
### Keywords: methods dplot

### ** Examples


data(GvHD)

qqmath( ~ `FSC-H` | factor(Patient), GvHD,
       grid = TRUE, type = "l",
       f.value = ppoints(100))

## contourplot of bivariate density:

require(colorspace)
YlOrBr <- c("#FFFFD4", "#FED98E", "#FE9929", "#D95F0E", "#993404")
colori <- colorRampPalette(YlOrBr)
levelplot(asinh(`SSC-H`) ~ asinh(`FSC-H`) | Visit + Patient, GvHD, n = 20,
          col.regions = colori(50), main = "Contour Plot")


## parallel coordinate plots

parallel(GvHD[["s6a01"]])

## Not run: 
##D 
##D ## try with PDF device
##D parallel(GvHD[["s7a01"]], alpha = 0.01)
##D 
## End(Not run)




