### Name: sim-methods
### Title: Method for simulating data from a mutagenetic trees mixture
###   model
### Aliases: sim sim-methods sim,RtreemixModel,missing,missing-method
###   sim,RtreemixModel,character,numeric-method
### Keywords: methods misc

### ** Examples

## Create a random RtreemixModel object with 3 branchings and 9 genetic events.
rand.mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))

## Draw 300 samples from the randomly generated model rand.mod 
data <- sim(model = rand.mod, no.draws = 300)
show(data)

## Create an RtreemixSim object by simulating patterns with their sampling and waiting times from a given mixture model.
sim.data <- sim(model = rand.mod, sampling.mode = "exponential", sampling.param = 1, no.sim = 100)
show(sim.data)
WaitingTimes(sim.data)
SamplingTimes(sim.data)



