### Name: sdf.visualize
### Title: Subset a SDF and visualize selected compounds in a webpage
### Aliases: sdf.visualize
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# set default browser to firefox
options(browser="firefox")
# select SDF for 1st and 2nd compound in that SDF and visualize it
# url will contain the URL of the page. Your browser will automatically open
# the page, too.
## Not run: url <- sdf.visualize(db, c(1, 2))
# upload first 20 compounds, disable browsing the page automatically
url <- sdf.visualize(db, 1:20, browse=FALSE)
cat(paste("point your browser to ", url, "\n", sep=''))
# upload the first two compounds, with extra description
extra <- c("Mark's compound", "Alan's compound")
names(extra) <- rep("Note", 2)
## Not run: url <- sdf.visualize(db, c(1, 2), extra=extra)
# upload the first two compound, and use an reference compound
reference.cmp <- "http://bioweb.ucr.edu/ChemMineV2/compound/Aurora/b32:NNQS2MBRHAZTI===/sdf"
## Not run: url <- sdf.visualize(db, c(1, 2), extra=extra, reference.sdf=reference.cmp, reference.note='Reference compound from Aurora library')



