### Name: cmp.search
### Title: Search a descriptor database for compounds similar to query
###   compound
### Aliases: cmp.search
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# (optinally) save the db for future use
save(db, file="db.rda", compress=TRUE)
# load SDF of query struture from web
url <- "http://bioweb.ucr.edu/ChemMineV2/compound/Aurora/b32:NNQS2MBRHAZTI===/sdf"
query <- cmp.parse1(url)
# search for similar compounds using similarity cutoff
cmp.search(db, query, cutoff=0.4)
# search for similar compounds using similarity cutoff; request to return scores
cmp.search(db, query, cutoff=0.4, return.score=TRUE)
# search for similar compounds using return-the-top-N style
cmp.search(db, query, cutoff=10, return.score=TRUE)

# you may visualize the search result in ChemMine
cmp.search(db, query, cutoff=10, visualize=TRUE, visualize.browse=FALSE, visualize.query=url)

## in the next session, you may use load a saved db and do the search:
load("db.rda")
cmp.search(db, query, cutoff=3)
## you may also use the loaded db to do clustering:
cmp.cluster(db, cutoff=0.35)



