###################################################
### chunk number 1: setup
###################################################
library("Rgraphviz")
data("integrinMediatedCellAdhesion")
IMCAGraph


###################################################
### chunk number 2: initial
###################################################
plot(IMCAGraph, attrs=list(graph=list(rankdir="LR")))


###################################################
### chunk number 3: nodeAttrs
###################################################
IMCAAttrs$nodeAttrs$shape
IMCAAttrs$nodeAttrs$width
IMCAAttrs$nodeAttrs$height
IMCAAttrs$nodeAttrs$fillcolor[1:10]


###################################################
### chunk number 4: plotWNodeAttrs
###################################################
plot(IMCAGraph, attrs=IMCAAttrs$defAttrs,
     nodeAttrs=IMCAAttrs$nodeAttrs)


###################################################
### chunk number 5: subgraphs
###################################################
nodes <- nodes(IMCAGraph)

sg1 <- subGraph(nodes[c(2,1,3,4)], IMCAGraph)
sg2 <- subGraph(c(nodes[5:14], nodes[19:48], nodes[52]), IMCAGraph)
sg3 <- subGraph(nodes[49:51], IMCAGraph)
sg4 <- subGraph(nodes[15:18], IMCAGraph)


###################################################
### chunk number 6: subGList
###################################################
IMCAAttrs$subGList


###################################################
### chunk number 7: plotSubgraph
###################################################
plot(IMCAGraph, attrs=IMCAAttrs$defAttrs,
     nodeAttrs=IMCAAttrs$nodeAttrs, subGList=IMCAAttrs$subGList)


###################################################
### chunk number 8: expressionGraph
###################################################
require("geneplotter")
require("fibroEset")
require("hgu95av2.db")
data("fibroEset")
plotExpressionGraph(IMCAGraph, IMCAAttrs$LocusLink,
exprs(fibroEset)[,1], hgu95av2ENTREZID, attrs=IMCAAttrs$defAttrs,
subGList=IMCAAttrs$subGList, nodeAttrs=IMCAAttrs$nodeAttrs)


###################################################
### chunk number 9: VJCGraph
###################################################
z <- IMCAGraph
nodes(z)[39] <- c("phosphati.\nsign. sys.")
nag <- agopen(z, name="nag",
attrs= list(node=list(color="white",
fontcolor="white"), edge=list(arrowsize=2.8, minlen=3)))
nagxy <- getNodeXY( nag )


###################################################
### chunk number 10: VJCfig
###################################################
plot( nag )
text( nagxy, label=nodes(z), cex=.8 )


###################################################
### chunk number 11: 
###################################################
sessionInfo()


###################################################
### chunk number 12: 
###################################################
graphvizVersion()


