### Name: injectSNPs
### Title: injectSNPs
### Aliases: injectSNPs available.SNPs
### Keywords: manip

### ** Examples

  ## Look at the SNP locations packages currently available:
  available.SNPs()

  if (interactive()) {
    ## Make your choice and install with:
    source("http://bioconductor.org/biocLite.R")
    biocLite("SNPlocs.Hsapiens.dbSNP.20071016")

    ## Inject into the Human genome:
    library(BSgenome.Hsapiens.UCSC.hg18)
    Hsapiens
    HsWithSNPs <- injectSNPs(Hsapiens, "SNPlocs.Hsapiens.dbSNP.20071016")
    HsWithSNPs
    alphabetFrequency(Hsapiens$chr1)
    alphabetFrequency(HsWithSNPs$chr1)
  }



