### Name: writeReport
### Title: Create a directory with HTML pages of linked tables and plots
###   documenting the contents of a cellHTS experiment
### Aliases: writeReport
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    pCtrls <- c("pos") 
    nCtrls <- c("neg") 
## Not run: 
##D     ## or for safety reasons (not a problem for the current well annotation, however) 
##D      pCtrls <- c("^pos$") 
##D      nCtrls <- c("^neg$")
##D     writeReport(list("raw"=KcViabSmall), posControls=pCtrls, negControls=nCtrls)
##D     ## same as 
##D     ## writeReport(list("raw"=KcViabSmall))
##D     xn <- normalizePlates(KcViabSmall, scale="multiplicative", log=FALSE, method="median")
##D     xsc <- scoreReplicates(xn, sign="-", method="zscore")
##D     xsc <- summarizeReplicates(xsc, summary="min")
##D     ## to turn on the tooltips in the plate plots and in the image screen plot:
##D     writeReport(cellHTSlist=list("raw"=KcViabSmall, "normalized"=xn, "scored"=xsc), force=TRUE, map=TRUE, plotPlateArgs = TRUE, imageScreenArgs=list(zrange=c(-4,4)))
##D     
## End(Not run)



