### Name: sliding.median
### Title: Compute median score over a running window
### Aliases: sliding.median slidingmedian
### Keywords: manip

### ** Examples

  sampleSize <- 1000
  ap <- cumsum(1+round(runif(sampleSize)*10))
  as <- c(rnorm(floor(sampleSize/3)),
          rnorm(ceiling(sampleSize/3),mean=1.5),
          rnorm(floor(sampleSize/3)))
  arm <- sliding.median(ap, as, 20)
  plot(ap, as, pch=20, xlab="position",ylab="level")
  points(ap, arm[,1], type="l", col="red", lwd=2)



