### Name: computeRunningMedians
### Title: Function to compute running medians on a tiling expression set
### Aliases: computeRunningMedians
### Keywords: manip

### ** Examples

  current.dir <- getwd()
  setwd(system.file("exData",package="Ringo"))
  load("exampleProbeAnno.rda")
  load("exampleX.rda")
  setwd(current.dir)
  smoothX = computeRunningMedians(exampleX, probeAnno=exProbeAnno,
modColumn = "Cy5", allChr = c("8"), winHalfSize = 400, verbose = TRUE)
  par(mfrow=c(1,1))
  chipAlongChrom(exampleX, chrom="8", xlim=c(60208000,60216000),
                 ylim=c(-1,6), probeAnno=exProbeAnno, gff=exGFF)  
  chipAlongChrom(smoothX, chrom="8", xlim=c(60208000,60216000),
                 ylim=c(-1,6), probeAnno=exProbeAnno, gff=exGFF,
                 itype="l", ilwd=3, add=TRUE)

  ## combine over replicates:
  smoothX2 = computeRunningMedians(exampleX, probeAnno=exProbeAnno,
       modColumn = "Cy5", allChr = c("8"), winHalfSize = 400,
       combineReplicates=TRUE, verbose = TRUE)
  chipAlongChrom(exampleX, chrom="8", xlim=c(60208000,60216000),
                 ylim=c(-1,6), probeAnno=exProbeAnno, gff=exGFF)  
  chipAlongChrom(smoothX2, chrom="8", xlim=c(60208000,60216000),
                 ylim=c(-1,6), probeAnno=exProbeAnno, gff=exGFF,
                 itype="l", ilwd=3, paletteName="Spectral", add=TRUE)



