### Name: cytoFrame-class
### Title: 'cytoFrame': a class for storing observed quantitative
###   properties from a population of cells, most likely from a FACS run
###   or, alternatively, from automated microscopy
### Aliases: cytoFrame-class cytoFrame [,cytoFrame-method
###   description,cytoFrame-method description<-,cytoFrame,character-method
###   exprs,cytoFrame-method exprs<-,cytoFrame,matrix-method
###   colnames,cytoFrame-method colnames<-,cytoFrame-method
###   show,cytoFrame-method plot,cytoFrame,missing-method $.cytoFrame
###   gate,cytoFrame-method gate<-,cytoFrame,gate-method
###   gate<-,cytoFrame,gateSet-method drawGate,cytoFrame-method
###   drawGate,cytoFrame-method drawGate,matrix-method
###   appendGates,cytoFrame-method ncol,cytoFrame-method
###   nrow,cytoFrame-method applyGate,cytoFrame,gate-method
###   applyGate,cytoFrame,gateSet-method
###   applyGate,cytoFrame,character-method
###   applyGate,cytoFrame,numeric-method applyGate,cytoFrame,logical-method
### Keywords: classes

### ** Examples

intens <- matrix(runif(100), ncol=4)
colnames(intens) <- c("FL1-H", "FL2-H", "FL3-H", "FL4-H")

a <- new("cytoFrame",
          exprs=intens,
          description=c(name="example data", date=date()))

description(a)
dim(exprs(a))           

a[1:3, -4]

plot(a)
## Not run: 
##D g1 <- drawGate(a, name="Gate1")
## End(Not run)



