### Name: robust.g.test
### Title: Robust g Test for Multiple (Genetic) Time Series
### Aliases: robust.g.test g.statistic robust.spectrum
### Keywords: htest

### ** Examples

## Not run: 
##D 
##D # load GeneTS library
##D library("GeneTS")
##D 
##D # load data set
##D data(caulobacter)
##D 
##D # how many samples and and how many genes?
##D dim(caulobacter)
##D 
##D # robust, rank-based spectral estimator applied to first 5 genes
##D spe5 <- robust.spectrum(caulobacter[,1:5])
##D 
##D # g statistics computed from the spectrum
##D g.statistic(spe5)
##D 
##D # robust p-values
##D pval <- robust.g.test(spe5)  # generates a file with the name "g_pop_length_11.txt"
##D pval <- robust.g.test(spe5)  # second call: much faster..
##D 
##D pval
##D 
##D # delete the external file 
##D unlink("g_pop_length_11.txt") 
##D 
## End(Not run)



