### Name: density.pr
### Title: Density Estimation Via Poisson Regression
### Aliases: density.pr
### Keywords: univar

### ** Examples

# load GeneTS library
library("GeneTS")

# load data 
data(faithful)
z <- faithful[,1]
rz <- range(z)

# estimate density 
d1a <- density.pr(z, plot=TRUE)
d1a

# discretization is not critical in this algorithm
d1b <- density.pr(z, plot=TRUE, ncells=80)
d1c <- density.pr(z, plot=TRUE, ncells=40)

plot(d1a, col=2)
lines(d1b, col=2)
lines(d1c, col=2)

# comparison with kernel density estimate
d2a <- density(z, from=rz[1], to=rz[2])
d2b <- density(z, from=rz[1], to=rz[2], bw="bcv")

plot(d1a, col=2, xlim=rz)
lines(d2a)
lines(d2b)



