###################################################
### chunk number 1: 
###################################################
library(ACME)


###################################################
### chunk number 2: 
###################################################
datdir <- system.file('extdata',package='ACME')
fnames <- dir(datdir)
example.agff <- read.resultsGFF(fnames,path=datdir)
example.agff


###################################################
### chunk number 3: 
###################################################
calc <- do.aGFF.calc(example.agff,window=1000,thresh=0.95)


###################################################
### chunk number 4: 
###################################################
plot(calc,chrom='chr1',sample=1)


###################################################
### chunk number 5: 
###################################################
regs <- findRegions(calc)
regs[1:5,]


###################################################
### chunk number 6: 
###################################################
# write both calculated values and raw data
write.sgr(calc)
# OR write only calculated data
write.sgr(calc,raw=FALSE)


