/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.TemplatesHandlerImpl;
import org.apache.xalan.xsltc.trax.TemplatesImpl;
import org.apache.xalan.xsltc.trax.TrAXFilter;
import org.apache.xalan.xsltc.trax.TransformerHandlerImpl;
import org.apache.xalan.xsltc.trax.TransformerImpl;
import org.apache.xalan.xsltc.trax.Util;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements SourceLoader,
ErrorListener {
    private ErrorListener _errorListener = this;
    private URIResolver _uriResolver = null;
    protected static String DEFAULT_TRANSLET_NAME = "GregorSamsa";
    private String _transletName = DEFAULT_TRANSLET_NAME;
    private String _destinationDirectory = null;
    private String _packageName = null;
    private String _jarFileName = null;
    private Hashtable _piParams = null;
    static ThreadLocal _xmlReader = new ThreadLocal();
    private boolean _debug = false;
    private boolean _enableInlining = false;
    private boolean _generateTranslet = false;
    private boolean _autoTranslet = false;
    private int _indentNumber = -1;
    private SAXParserFactory _parserFactory = null;

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            ErrorMsg err = new ErrorMsg(59, "TransformerFactory");
            throw new IllegalArgumentException(err.toString());
        }
        this._errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name.equals("translet-name")) {
            return this._transletName;
        }
        if (name.equals("generate-translet")) {
            return new Boolean(this._generateTranslet);
        }
        if (name.equals("auto-translet")) {
            return new Boolean(this._autoTranslet);
        }
        ErrorMsg err = new ErrorMsg(63, name);
        throw new IllegalArgumentException(err.toString());
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("translet-name") && value instanceof String) {
            this._transletName = (String)value;
            return;
        }
        if (name.equals("destination-directory") && value instanceof String) {
            this._destinationDirectory = (String)value;
            return;
        }
        if (name.equals("package-name") && value instanceof String) {
            this._packageName = (String)value;
            return;
        }
        if (name.equals("jar-name") && value instanceof String) {
            this._jarFileName = (String)value;
            return;
        }
        if (name.equals("generate-translet")) {
            if (value instanceof Boolean) {
                this._generateTranslet = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._generateTranslet = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("auto-translet")) {
            if (value instanceof Boolean) {
                this._autoTranslet = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._autoTranslet = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("debug")) {
            if (value instanceof Boolean) {
                this._debug = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._debug = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("enable-inlining")) {
            if (value instanceof Boolean) {
                this._enableInlining = (Boolean)value;
                return;
            }
            if (value instanceof String) {
                this._enableInlining = ((String)value).equalsIgnoreCase("true");
                return;
            }
        } else if (name.equals("indent-number")) {
            if (value instanceof String) {
                try {
                    this._indentNumber = Integer.parseInt((String)value);
                    return;
                }
                catch (NumberFormatException e) {}
            } else if (value instanceof Integer) {
                this._indentNumber = (Integer)value;
                return;
            }
        }
        ErrorMsg err = new ErrorMsg(63, name);
        throw new IllegalArgumentException(err.toString());
    }

    public boolean getFeature(String name) {
        String[] features = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature"};
        int i = 0;
        while (i < features.length) {
            if (name.equals(features[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        if (this._piParams == null) {
            this._piParams = new Hashtable();
        }
        this._piParams.put(source, new PIParamWrapper(media, title, charset));
        return source;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl result = new TransformerImpl(new Properties(), this._indentNumber, this);
        if (this._uriResolver != null) {
            result.setURIResolver(this._uriResolver);
        }
        return result;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return transformer;
    }

    private void passWarningsToListener(Vector messages) throws TransformerException {
        if (this._errorListener == null || messages == null) {
            return;
        }
        int count = messages.size();
        int pos = 0;
        while (pos < count) {
            String message = messages.elementAt(pos).toString();
            this._errorListener.error(new TransformerConfigurationException(message));
            ++pos;
        }
    }

    private void passErrorsToListener(Vector messages) {
        try {
            if (this._errorListener == null || messages == null) {
                return;
            }
            int count = messages.size();
            int pos = 0;
            while (pos < count) {
                String message = messages.elementAt(pos).toString();
                this._errorListener.error(new TransformerException(message));
                ++pos;
            }
        }
        catch (TransformerException e) {}
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PIParamWrapper p;
        if (this._autoTranslet) {
            byte[][] bytecodes = null;
            String transletClassName = this.getTransletClassName(source);
            bytecodes = this._jarFileName != null ? this.getBytecodesFromJar(source, transletClassName) : this.getBytecodesFromClasses(source, transletClassName);
            if (bytecodes != null) {
                if (this._debug) {
                    if (this._jarFileName != null) {
                        System.err.println(new ErrorMsg(90, (Object)transletClassName, (Object)this._jarFileName));
                    } else {
                        System.err.println(new ErrorMsg(89, transletClassName));
                    }
                }
                this.resetTransientAttributes();
                return new TemplatesImpl(bytecodes, transletClassName, null, this._indentNumber, this);
            }
        }
        XSLTC xsltc = new XSLTC();
        if (this._debug) {
            xsltc.setDebug(true);
        }
        if (this._enableInlining) {
            xsltc.setTemplateInlining(true);
        }
        xsltc.init();
        if (this._uriResolver != null) {
            xsltc.setSourceLoader(this);
        }
        if (this._piParams != null && this._piParams.get(source) != null && (p = (PIParamWrapper)this._piParams.get(source)) != null) {
            xsltc.setPIParameters(p._media, p._title, p._charset);
        }
        int outputType = 2;
        if (this._generateTranslet || this._autoTranslet) {
            if (!this._transletName.equals(DEFAULT_TRANSLET_NAME)) {
                xsltc.setClassName(this._transletName);
            }
            if (this._destinationDirectory != null) {
                xsltc.setDestDirectory(this._destinationDirectory);
            } else {
                File xslFile;
                String xslDir;
                String xslName = this.getStylesheetFileName(source);
                if (xslName != null && (xslDir = (xslFile = new File(xslName)).getParent()) != null) {
                    xsltc.setDestDirectory(xslDir);
                }
            }
            if (this._packageName != null) {
                xsltc.setPackageName(this._packageName);
            }
            if (this._jarFileName != null) {
                xsltc.setJarFileName(this._jarFileName);
                outputType = 5;
            } else {
                outputType = 4;
            }
        }
        InputSource input = Util.getInputSource(xsltc, source);
        byte[][] bytecodes = xsltc.compile(null, input, outputType);
        String transletName = xsltc.getClassName();
        if ((this._generateTranslet || this._autoTranslet) && bytecodes != null && this._jarFileName != null) {
            try {
                xsltc.outputToJar();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.resetTransientAttributes();
        if (this._errorListener != this) {
            try {
                this.passWarningsToListener(xsltc.getWarnings());
            }
            catch (TransformerException e) {
                throw new TransformerConfigurationException(e);
            }
        } else {
            xsltc.printWarnings();
        }
        if (bytecodes == null) {
            if (this._errorListener != null) {
                this.passErrorsToListener(xsltc.getErrors());
            } else {
                xsltc.printErrors();
            }
            ErrorMsg err = new ErrorMsg(62);
            throw new TransformerConfigurationException(err.toString());
        }
        return new TemplatesImpl(bytecodes, transletName, xsltc.getOutputProperties(), this._indentNumber, this);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        TemplatesHandlerImpl handler = new TemplatesHandlerImpl(this._indentNumber, this);
        if (this._uriResolver != null) {
            handler.setURIResolver(this._uriResolver);
        }
        return handler;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(src);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl internal = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(internal);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException e1) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(e1);
                    return null;
                }
                catch (TransformerException e2) {
                    new TransformerConfigurationException(e2);
                }
            }
            throw e1;
        }
    }

    public void error(TransformerException e) throws TransformerException {
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println(new ErrorMsg(87, (Object)e.getMessageAndLocation(), (Object)wrapped.getMessage()));
        } else {
            System.err.println(new ErrorMsg(88, e.getMessageAndLocation()));
        }
        throw e;
    }

    public void fatalError(TransformerException e) throws TransformerException {
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println(new ErrorMsg(85, (Object)e.getMessageAndLocation(), (Object)wrapped.getMessage()));
        } else {
            System.err.println(new ErrorMsg(86, e.getMessageAndLocation()));
        }
        throw e;
    }

    public void warning(TransformerException e) throws TransformerException {
        Throwable wrapped = e.getException();
        if (wrapped != null) {
            System.err.println(new ErrorMsg(83, (Object)e.getMessageAndLocation(), (Object)wrapped.getMessage()));
        } else {
            System.err.println(new ErrorMsg(84, e.getMessageAndLocation()));
        }
    }

    public InputSource loadSource(String href, String context, XSLTC xsltc) {
        try {
            Source source;
            if (this._uriResolver != null && (source = this._uriResolver.resolve(href, context)) != null) {
                return Util.getInputSource(xsltc, source);
            }
        }
        catch (TransformerException e) {}
        return null;
    }

    public synchronized XMLReader getXMLReader() throws Exception {
        XMLReader result;
        if (this._parserFactory == null) {
            this._parserFactory = SAXParserFactory.newInstance();
            this._parserFactory.setNamespaceAware(true);
        }
        if ((result = (XMLReader)_xmlReader.get()) == null) {
            result = this._parserFactory.newSAXParser().getXMLReader();
            _xmlReader.set(result);
        }
        return result;
    }

    private void resetTransientAttributes() {
        this._transletName = DEFAULT_TRANSLET_NAME;
        this._destinationDirectory = null;
        this._packageName = null;
        this._jarFileName = null;
    }

    private byte[][] getBytecodesFromClasses(Source source, String fullClassName) {
        byte[] bytes;
        int lastDotIndex;
        if (fullClassName == null) {
            return null;
        }
        String xslFileName = this.getStylesheetFileName(source);
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        String transletName = (lastDotIndex = fullClassName.lastIndexOf(46)) > 0 ? fullClassName.substring(lastDotIndex + 1) : fullClassName;
        String transletPath = fullClassName.replace('.', '/');
        transletPath = this._destinationDirectory != null ? this._destinationDirectory + "/" + transletPath + ".class" : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + transletPath + ".class" : transletPath + ".class");
        File transletFile = new File(transletPath);
        if (!transletFile.exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = transletFile.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        Vector<byte[]> bytecodes = new Vector<byte[]>();
        int fileLength = (int)transletFile.length();
        if (fileLength > 0) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(transletFile);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            bytes = new byte[fileLength];
            try {
                this.readFromInputStream(bytes, input, fileLength);
                input.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
        bytecodes.addElement(bytes);
        String transletParentDir = transletFile.getParent();
        if (transletParentDir == null) {
            transletParentDir = System.getProperty("user.dir");
        }
        File transletParentFile = new File(transletParentDir);
        final String transletAuxPrefix = transletName + "$";
        File[] auxfiles = transletParentFile.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class") && name.startsWith(transletAuxPrefix);
            }
        });
        int i = 0;
        while (i < auxfiles.length) {
            block19: {
                File auxfile = auxfiles[i];
                int auxlength = (int)auxfile.length();
                if (auxlength > 0) {
                    FileInputStream auxinput = null;
                    try {
                        auxinput = new FileInputStream(auxfile);
                    }
                    catch (FileNotFoundException e) {
                        break block19;
                    }
                    byte[] bytes2 = new byte[auxlength];
                    try {
                        this.readFromInputStream(bytes2, auxinput, auxlength);
                        auxinput.close();
                    }
                    catch (IOException e) {
                        break block19;
                    }
                    bytecodes.addElement(bytes2);
                }
            }
            ++i;
        }
        int count = bytecodes.size();
        if (count > 0) {
            byte[][] result = new byte[count][1];
            int i2 = 0;
            while (i2 < count) {
                result[i2] = (byte[])bytecodes.elementAt(i2);
                ++i2;
            }
            return result;
        }
        return null;
    }

    private byte[][] getBytecodesFromJar(Source source, String fullClassName) {
        String xslFileName = this.getStylesheetFileName(source);
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        String jarPath = null;
        jarPath = this._destinationDirectory != null ? this._destinationDirectory + "/" + this._jarFileName : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + this._jarFileName : this._jarFileName);
        File file = new File(jarPath);
        if (!file.exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = file.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        ZipFile jarFile = null;
        try {
            jarFile = new ZipFile(file);
        }
        catch (IOException e) {
            return null;
        }
        String transletPath = fullClassName.replace('.', '/');
        String transletAuxPrefix = transletPath + "$";
        String transletFullName = transletPath + ".class";
        Vector<byte[]> bytecodes = new Vector<byte[]>();
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entry.getSize() <= 0L || !entryName.equals(transletFullName) && (!entryName.endsWith(".class") || !entryName.startsWith(transletAuxPrefix))) continue;
            try {
                InputStream input = jarFile.getInputStream(entry);
                int size = (int)entry.getSize();
                byte[] bytes = new byte[size];
                this.readFromInputStream(bytes, input, size);
                input.close();
                bytecodes.addElement(bytes);
            }
            catch (IOException e) {
                return null;
            }
        }
        int count = bytecodes.size();
        if (count > 0) {
            byte[][] result = new byte[count][1];
            int i = 0;
            while (i < count) {
                result[i] = (byte[])bytecodes.elementAt(i);
                ++i;
            }
            return result;
        }
        return null;
    }

    private void readFromInputStream(byte[] bytes, InputStream input, int size) throws IOException {
        int n = 0;
        int offset = 0;
        int length = size;
        while (length > 0 && (n = input.read(bytes, offset, length)) > 0) {
            offset += n;
            length -= n;
        }
    }

    private String getTransletClassName(Source source) {
        String transletBaseName = null;
        if (!this._transletName.equals(DEFAULT_TRANSLET_NAME)) {
            transletBaseName = this._transletName;
        } else {
            String baseName;
            String systemId = source.getSystemId();
            if (systemId != null && (baseName = Util.baseName(systemId)) != null) {
                transletBaseName = Util.noExtName(baseName);
            }
        }
        if (transletBaseName == null) {
            transletBaseName = DEFAULT_TRANSLET_NAME;
        }
        if (this._packageName != null) {
            return this._packageName + "." + transletBaseName;
        }
        return transletBaseName;
    }

    private String getStylesheetFileName(Source source) {
        String systemId = source.getSystemId();
        if (systemId != null) {
            File file = new File(systemId);
            if (file.exists()) {
                return systemId;
            }
            URL url = null;
            try {
                url = new URL(systemId);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if ("file".equals(url.getProtocol())) {
                return url.getFile();
            }
            return null;
        }
        return null;
    }

    private static class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String media, String title, String charset) {
            this._media = media;
            this._title = title;
            this._charset = charset;
        }
    }
}

