/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.KeyIndex;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.util.IntegerArray;

public final class DupFilterIterator
extends NodeIteratorBase {
    private NodeIterator _source;
    private IntegerArray _nodes = new IntegerArray();
    private int _current = 0;
    private int _nodesSize = 0;
    private int _lastNext = 0;

    public DupFilterIterator(NodeIterator source) {
        this._source = source;
        if (source instanceof KeyIndex) {
            this.setStartNode(1);
        }
    }

    public NodeIterator setStartNode(int node) {
        if (this._isRestartable) {
            if (this._source instanceof KeyIndex && this._startNode == 1) {
                return this;
            }
            if (node != this._startNode) {
                this._startNode = node;
                this._source.setStartNode(this._startNode);
                this._nodes.clear();
                while ((node = this._source.next()) != 0) {
                    this._nodes.add(node);
                }
                this._nodes.sort();
                this._nodesSize = this._nodes.cardinality();
                this._current = 0;
                this._lastNext = 0;
                this.resetPosition();
            }
        }
        return this;
    }

    public int next() {
        while (this._current < this._nodesSize) {
            int next;
            if ((next = this._nodes.at(this._current++)) == this._lastNext) continue;
            this._lastNext = next;
            return this.returnNode(this._lastNext);
        }
        return 0;
    }

    public NodeIterator cloneIterator() {
        try {
            DupFilterIterator clone = (DupFilterIterator)super.clone();
            clone._nodes = (IntegerArray)this._nodes.clone();
            clone._source = this._source.cloneIterator();
            clone._isRestartable = false;
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError(7, e.toString());
            return null;
        }
    }

    public void setRestartable(boolean isRestartable) {
        this._isRestartable = isRestartable;
        this._source.setRestartable(isRestartable);
    }

    public void setMark() {
        this._markedNode = this._current;
    }

    public void gotoMark() {
        this._current = this._markedNode;
    }

    public NodeIterator reset() {
        this._current = 0;
        this._lastNext = 0;
        return this.resetPosition();
    }
}

