/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.xmlutils;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.biomage.Common.MAGEJava;
import org.biomage.tools.helpers.StringOutputHelpers;
import org.biomage.tools.xmlutils.MAGEContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImportExportTest {
    public static void main(String[] asArg) {
        StringOutputHelpers.setVerbose(0);
        if (asArg.length == 0) {
            System.out.println("\n\nUsage: java org.biomage.tools.xmlutils.ImportExportTest <MAGE-ML Filename>\n\n");
            System.exit(0);
        }
        System.out.println(asArg[0]);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            MAGEContentHandler cHandler = new MAGEContentHandler();
            parser.setContentHandler(cHandler);
            parser.parse(asArg[0]);
            MAGEJava mageJava = cHandler.getMAGEJava();
            if (mageJava != null) {
                StringOutputHelpers.writeOutput("DEBUG: Writing back out the MAGEML", 1);
                FileWriter tmpFile = new FileWriter("raw.xml");
                mageJava.writeMAGEML(tmpFile);
                tmpFile.flush();
                tmpFile.close();
                OutputFormat xmlFormat = new OutputFormat("xml", "utf-8", true);
                xmlFormat.setLineWidth(60);
                xmlFormat.setLineSeparator("\n");
                PrintWriter screenWriter = new PrintWriter(System.out, true);
                XMLSerializer xmlWriterDocHndler = new XMLSerializer((Writer)screenWriter, xmlFormat);
                XMLReader xmlWriterParser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                xmlWriterParser.setContentHandler((ContentHandler)xmlWriterDocHndler);
                xmlWriterParser.parse(new InputSource(new FileReader("raw.xml")));
                screenWriter.flush();
                screenWriter.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (SAXException exception) {
            exception.printStackTrace();
        }
    }
}

