/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.generate_er;

import java.io.FileWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.biomage.tools.generate_classes.CreateFile;
import org.biomage.tools.generate_er.AssociationColumn;
import org.biomage.tools.generate_er.DataColumn;
import org.biomage.tools.generate_er.ForeignKey;
import org.biomage.tools.generate_er.Index;
import org.biomage.tools.generate_er.LinkingKey;
import org.biomage.tools.generate_er.PrimaryKey;
import org.biomage.tools.generate_er.Table;
import org.biomage.tools.generate_er.Unique;
import org.biomage.tools.helpers.StringOutputHelpers;

public class CreateMageER {
    public static final String NEWLINE = StringOutputHelpers.NEWLINE;
    public static final String oneIndent = StringOutputHelpers.oneIndent;
    public static final String INDENT = "      ";
    public static final String HALF_INDENT = "  ";
    public static final String aLine = "--------------------";
    public static final String FOREIGNKEY = "_fk";
    public static final String ID = "ID";
    public static final String SERIAL = "Serial";
    public static final String PRIMARY_KEY = "Primary Key";
    public static final String NOT_NULL = "true";
    public static final String NULL = "false";
    public static final String ABSTRACT = "true";
    public static final String NOT_ABSTRACT = "false";
    public static final String NO_BASE_CLASS = "none";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String INTEGER = "int";
    public static final String DATA = "&data_table;";
    public static final String VALIDATION = "&validation_table;";
    public static final String LINKING = "&linking_table;";
    public static final String VIEW = "&view;";
    public static final String SUBSET = "&subset_table;";
    public static final String ONE_TO_ONE = "&fkey_oto;";
    public static final String ONE_TO_MANY = "&fkey_otm;";
    public static final String LINKING_FKEY = "&fkey_mtm;";
    public static final String LOOKUP_FKEY = "&fkey_lookup;";
    public static final String FIRSTLINE = "<?xml version=\"1.0\" standalone=\"no\"?>";
    public static final String SECONDLINE = "<!DOCTYPE table SYSTEM \"table.dtd\">";
    Map tableMap = new HashMap(200);

    public void buildTables(String outputDir, Vector classes) throws Exception {
        int i = -1;
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            CreateFile createFile = (CreateFile)iter.next();
            if (2 != createFile.getFileType()) continue;
            Table myTable = (Table)this.tableMap.get(createFile.getClassFileName());
            String className = createFile.getClassFileName();
            Table table = myTable == null ? new Table() : myTable;
            if (createFile.getClassFileName().equals("Ontology")) {
                table.setType(VALIDATION);
            } else {
                table.setType(DATA);
            }
            String outputFile = outputDir + "/" + className + ".xml";
            FileWriter f3 = new FileWriter(outputFile);
            this.writeTableName(createFile, table);
            this.writeBaseClassName(createFile, table);
            this.writeAbstractInfo(createFile, table);
            this.writeAttrInfo(createFile, table);
            this.tableMap.put(table.getName(), table);
            HashMap<String, Table> tempMap = new HashMap<String, Table>();
            tempMap.put(table.getName(), table);
            this.WriteMAGEER(tempMap, f3, null);
        }
    }

    public void writeTableName(CreateFile createFile, Table table) throws Exception {
        String name = createFile.getClassFileName();
        table.setName(name);
        DataColumn pkColumn = new DataColumn();
        pkColumn.setName(ID);
        pkColumn.setType(SERIAL);
        pkColumn.setFullName(PRIMARY_KEY);
        pkColumn.setCanBeNull("true");
        table.setData(pkColumn);
        PrimaryKey pk = new PrimaryKey(pkColumn);
        table.setPK(pk);
    }

    public void writeAttrInfo(CreateFile createFile, Table table) throws Exception {
        String dataType = "";
        Vector attrVector = createFile.getAttrInfo();
        if (attrVector != null) {
            int i = 0;
            while (i < attrVector.size()) {
                DataColumn data = new DataColumn();
                CreateFile.AttrInformation attr = (CreateFile.AttrInformation)attrVector.elementAt(i);
                String name = attr.getName();
                data.setName(name);
                String fullName = this.getFullName(name);
                data.setFullName(fullName);
                if (attr.isEnum()) {
                    dataType = "Enumeration";
                    Vector enumVec = attr.getEnumValues();
                    data.setEnumVector(enumVec);
                } else {
                    dataType = this.getDatatype(attr);
                }
                data.setType(dataType);
                String comment = attr.getComment();
                data.setComment(comment);
                data.setCanBeNull("false");
                table.setData(data);
                ++i;
            }
        }
    }

    protected String getDatatype(CreateFile.AttrInformation attr) throws Exception {
        String datatype = attr.getDatatype();
        if (-1 != datatype.indexOf("any")) {
            datatype = "Object" + datatype.substring(3);
        }
        return datatype;
    }

    protected String getFullName(String name) throws Exception {
        String firstLetter = name.substring(0, 1);
        String subsequent = name.substring(1, name.length());
        firstLetter = firstLetter.toUpperCase();
        StringBuffer buffer1 = new StringBuffer(firstLetter);
        StringBuffer buffer2 = new StringBuffer();
        buffer2 = buffer1.append(subsequent);
        int k = 0;
        String newName = buffer2.toString();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < newName.length()) {
            String temp = newName.substring(i, i + 1);
            String cap = temp.toUpperCase();
            if (cap.equals(temp)) {
                String subString = newName.substring(k, i);
                buffer = buffer.append(" " + subString);
                k = i;
            }
            if (i == newName.length() - 1) {
                String finalString = newName.substring(k);
                buffer = buffer.append(" " + finalString);
            }
            ++i;
        }
        String myName = buffer.toString();
        int n = 0;
        if (myName.length() >= 1 && myName.charAt(0) == ' ') {
            while (n <= myName.length() - 1 && myName.charAt(n) == ' ') {
                ++n;
            }
            int position = n;
            myName = myName.substring(position);
        }
        return myName;
    }

    public void writeBaseClassName(CreateFile createFile, Table table) throws Exception {
        String name = createFile.getBaseClassFileName();
        if (name == null) {
            table.setBaseClass(NO_BASE_CLASS);
        } else {
            table.setBaseClass(name);
        }
    }

    public void writeAbstractInfo(CreateFile createFile, Table table) throws Exception {
        boolean isAbstract = createFile.isAbstract();
        if (isAbstract) {
            table.setIsAbstract("true");
        } else {
            table.setIsAbstract("false");
        }
    }

    public void writeAssociationInfo(CreateFile createFile, Table table, FileWriter w) throws Exception {
        int minCard = -99;
        int maxCard = -99;
        int thisMinCard = -99;
        int thisMaxCard = -99;
        Vector otmVector = new Vector();
        boolean flag = false;
        Vector assoVector = createFile.getAssociationInfo();
        if (assoVector != null) {
            int i = 0;
            while (i < assoVector.size()) {
                AssociationColumn column = new AssociationColumn();
                CreateFile.AssociationAttrInformation attr = (CreateFile.AssociationAttrInformation)assoVector.elementAt(i);
                String ignore = attr.getOriginalType();
                if (!(ignore.equals("BioDataValues") || ignore.equals("BioDataCube") || ignore.equals("BioDataTuples") || ignore.equals("BioAssayDatum"))) {
                    minCard = attr.getMinCard();
                    maxCard = attr.getMaxCard();
                    thisMinCard = attr.getThisMinCard();
                    thisMaxCard = attr.getThisMaxCard();
                    if (!(minCard != 1 && minCard != 0 || maxCard != 1 || thisMinCard != 1 && thisMinCard != 0 || thisMaxCard != 1)) {
                        this.OneToOne(table, column, createFile, attr);
                    } else if (!(maxCard != -1 && maxCard <= 1 || thisMaxCard != -1 && thisMaxCard <= 1)) {
                        this.ManyToMany(createFile, attr.getOriginalType());
                    } else if (!(maxCard != -1 && maxCard <= 1 || thisMinCard != 1 && thisMinCard != 0)) {
                        boolean checkResult = this.CheckRelationship(otmVector, attr.getOriginalType(), attr.isOwner());
                        if (checkResult) {
                            System.out.println("Error " + attr.getOriginalType());
                        } else {
                            this.OneToMany(table, column, createFile, attr);
                        }
                    } else if (!(minCard != 1 && minCard != 0 || maxCard != 1 || thisMaxCard <= 1 && thisMaxCard != -1)) {
                        this.ManyToOne(table, column, createFile, attr, w);
                    }
                }
                ++i;
            }
        }
    }

    protected void OneToOne(Table table, AssociationColumn column, CreateFile createFile, CreateFile.AssociationAttrInformation attr) throws Exception {
        String name = attr.getName();
        String oriType = attr.getOriginalType();
        boolean owner = attr.isOwner();
        String columnName = name + FOREIGNKEY;
        column.setName(columnName);
        column.setFullName(this.getFullName(name) + " fk");
        column.setType(INTEGER);
        String comment = attr.getComment();
        column.setComment(comment);
        column.setCanBeNull("false");
        ForeignKey fkoto = new ForeignKey();
        fkoto.setColumnId(columnName);
        fkoto.setForeignTable(oriType);
        fkoto.setForeignTablePrimaryKey(ID);
        fkoto.setForeignKeyType(ONE_TO_ONE);
        if (owner) {
            fkoto.setCascade("true");
        } else {
            fkoto.setCascade("false");
        }
        column.setForeignKey(fkoto);
        table.setAsso(column);
    }

    protected void ManyToMany(CreateFile createFile, String oriType) throws Exception {
        Table linkingTable = this.createLinkingTable(createFile, oriType);
        AssociationColumn link1 = this.createLinkColumn(createFile.getClassFileName());
        linkingTable.setAsso(link1);
        AssociationColumn link2 = this.createLinkColumn(oriType);
        linkingTable.setAsso(link2);
        LinkingKey lk = this.createLinkingKey(link1, link2);
        linkingTable.setLinkingKey(lk);
        Index index1 = this.createIndex(link1, linkingTable.getName(), link1.getName());
        Index index2 = this.createIndex(link2, linkingTable.getName(), link2.getName());
        linkingTable.setIndex(index1);
        linkingTable.setIndex(index2);
        this.tableMap.put(linkingTable.getName(), linkingTable);
    }

    protected boolean CheckRelationship(Vector otmVector, String oriType, boolean owner) {
        boolean flag = false;
        if (otmVector.size() == 0) {
            otmVector.addElement(oriType);
        } else {
            int k = 0;
            while (k < otmVector.size()) {
                if (otmVector.elementAt(k).equals(oriType)) {
                    flag = true;
                }
                ++k;
            }
            if (!flag) {
                otmVector.addElement(oriType);
            } else {
                System.out.println("Error " + oriType);
            }
        }
        return flag;
    }

    protected void OneToMany(Table table, AssociationColumn column, CreateFile createFile, CreateFile.AssociationAttrInformation attr) throws Exception {
        String name = attr.getName();
        String oriType = attr.getOriginalType();
        boolean owner = attr.isOwner();
        String newName1 = this.lowerCaseFirstLetter(createFile.getClassFileName());
        String columnName = newName1 + FOREIGNKEY;
        column.setName(columnName);
        column.setFullName(this.getFullName(newName1) + " fk");
        column.setType(INTEGER);
        String comment = attr.getComment();
        column.setComment(comment);
        column.setCanBeNull("false");
        ForeignKey fkotm = new ForeignKey();
        fkotm.setColumnId(columnName);
        fkotm.setForeignTable(createFile.getClassFileName());
        fkotm.setForeignTablePrimaryKey(ID);
        fkotm.setForeignKeyType(ONE_TO_MANY);
        if (owner) {
            fkotm.setCascade("true");
        } else {
            fkotm.setCascade("false");
        }
        column.setForeignKey(fkotm);
        Table otherTable = (Table)this.tableMap.get(oriType);
        if (otherTable != null) {
            otherTable.setAsso(column);
            Index index = this.createIndex(column, table.getName(), columnName);
            otherTable.setIndex(index);
        } else {
            Table newTable = new Table();
            newTable.setAsso(column);
            Index index = this.createIndex(column, table.getName(), columnName);
            newTable.setIndex(index);
            this.tableMap.put(oriType, newTable);
        }
    }

    protected void ManyToOne(Table table, AssociationColumn column, CreateFile createFile, CreateFile.AssociationAttrInformation attr, FileWriter w) throws Exception {
        boolean thisNav = attr.getThisNav();
        boolean otherNav = attr.getOtherNav();
        if (thisNav && otherNav) {
            w.write(createFile.getClassFileName() + NEWLINE);
            w.write(attr.getOriginalType() + NEWLINE);
            w.write("%%%%%%%%%%%%*************both navigable" + NEWLINE);
        } else {
            this.OneToOne(table, column, createFile, attr);
            w.write("++++++++++++++++++++++++++++" + NEWLINE);
            w.write(createFile.getClassFileName() + NEWLINE);
            w.write(attr.getOriginalType() + NEWLINE);
            w.write("+++++++++++++++++++not both navigable" + NEWLINE);
        }
    }

    protected String alphabetLinkingTabelName(String string1, String string2) {
        String finalString = "";
        finalString = string1.compareTo(string2) <= 0 ? string1 + "_link_" + string2 : string2 + "_link_" + string1;
        return finalString;
    }

    protected Table createLinkingTable(CreateFile createFile, String oriType) {
        Table linkingTable = new Table();
        String thisTableName = createFile.getClassFileName();
        String linkingName = this.alphabetLinkingTabelName(thisTableName, oriType);
        linkingTable.setName(linkingName);
        linkingTable.setType(LINKING);
        linkingTable.setBaseClass(NO_BASE_CLASS);
        linkingTable.setIsAbstract("false");
        return linkingTable;
    }

    protected String lowerCaseFirstLetter(String name) {
        String firstLetter = name.substring(0, 1);
        String subsequent = name.substring(1, name.length());
        firstLetter = firstLetter.toLowerCase();
        return firstLetter + subsequent;
    }

    protected AssociationColumn createLinkColumn(String className) {
        AssociationColumn link = new AssociationColumn();
        String columnName = this.lowerCaseFirstLetter(className + FOREIGNKEY);
        link.setName(columnName);
        link.setFullName(className + " fk");
        link.setType(INTEGER);
        link.setCanBeNull("true");
        link.setMinCard("1");
        link.setMaxCard("-1");
        link.setThisMinCard("1");
        link.setThisMaxCard("1");
        link.setOwner("false");
        ForeignKey fk = new ForeignKey();
        fk.setColumnId(columnName);
        fk.setForeignTable(className);
        fk.setForeignTablePrimaryKey(ID);
        fk.setForeignKeyType(LINKING_FKEY);
        fk.setCascade("false");
        link.setForeignKey(fk);
        return link;
    }

    protected LinkingKey createLinkingKey(AssociationColumn link1, AssociationColumn link2) {
        LinkingKey lk = new LinkingKey();
        lk.setLinkOne(link1);
        lk.setLinkTwo(link2);
        return lk;
    }

    protected Unique createUnique(Vector uniqueVector) {
        Unique unique = new Unique();
        unique.setUniqueVector(uniqueVector);
        return unique;
    }

    protected Index createIndex(AssociationColumn column, String tableName, String columnName) {
        Index index = new Index();
        index.setName(tableName + "_" + columnName);
        index.setIndexColumn(column);
        return index;
    }

    protected void WriteMAGEER(Map tableMap, FileWriter f3, FileWriter w) throws Exception {
        f3.write(FIRSTLINE + NEWLINE);
        f3.write(SECONDLINE + NEWLINE);
        Enumeration e = Collections.enumeration(tableMap.values());
        while (e.hasMoreElements()) {
            Table t = (Table)e.nextElement();
            this.WriteOneTable(t, f3);
        }
        f3.close();
    }

    protected void WriteOneTable(Table table, FileWriter f3) throws Exception {
        f3.write("<table name=\"" + table.getName() + "\"" + NEWLINE);
        f3.write("      type=\"" + table.getType() + "\"" + NEWLINE);
        f3.write("      inherits_from=\"" + table.getBaseClass() + "\"" + NEWLINE);
        f3.write("      is_abstract=\"" + table.getIsAbstract() + "\">" + NEWLINE);
        PrimaryKey pk = table.getPK();
        if (pk != null) {
            f3.write("  <primary_key column_id=\"" + pk.getColumnID() + "\"/>" + NEWLINE);
        }
        Vector simpleColumns = table.getDataColumnVector();
        int i = 0;
        while (i < simpleColumns.size()) {
            DataColumn oneColumn = (DataColumn)simpleColumns.elementAt(i);
            f3.write("  <column name=\"" + oneColumn.getName() + "\"" + NEWLINE);
            f3.write("      full_name=\"" + oneColumn.getFullName() + "\"" + NEWLINE);
            if (oneColumn.getType().equals("Enumeration")) {
                f3.write("      type=\"" + oneColumn.getType() + "{");
                Vector enumVec = oneColumn.getEnumVector();
                int k = 0;
                while (k < enumVec.size()) {
                    if (k != enumVec.size() - 1) {
                        f3.write(enumVec.elementAt(k) + ", ");
                    } else {
                        f3.write(enumVec.elementAt(k) + "");
                    }
                    ++k;
                }
                f3.write("}\"" + NEWLINE);
            } else {
                f3.write("      type=\"" + oneColumn.getType() + "\"" + NEWLINE);
            }
            f3.write("      comment=\"" + oneColumn.getComment() + "\"" + NEWLINE);
            f3.write("      not_null=\"" + oneColumn.getCanBeNull() + "\"");
            f3.write("/>" + NEWLINE);
            ++i;
        }
        Vector assoColumns = table.getAssoColumnVector();
        int i2 = 0;
        while (i2 < assoColumns.size()) {
            AssociationColumn oneColumn = (AssociationColumn)assoColumns.elementAt(i2);
            f3.write("  <column name=\"" + oneColumn.getName() + "\"" + NEWLINE);
            f3.write("      full_name=\"" + oneColumn.getFullName() + "\"" + NEWLINE);
            f3.write("      type=\"" + oneColumn.getType() + "\"" + NEWLINE);
            f3.write("      comment=\"" + oneColumn.getComment() + "\"" + NEWLINE);
            f3.write("      not_null=\"" + oneColumn.getCanBeNull() + "\"");
            f3.write("/>" + NEWLINE);
            ForeignKey fk = oneColumn.getForeignKey();
            f3.write("  <foreign_key column_id=\"" + fk.getColumnId() + "\"" + NEWLINE);
            f3.write("      foreign_table=\"" + fk.getForeignTable() + "\"" + NEWLINE);
            f3.write("      foreign_table_pkey=\"" + fk.getForeignTablePrimaryKey() + "\"" + NEWLINE);
            f3.write("      fkey_type=\"" + fk.getForeignKeyType() + "\"" + NEWLINE);
            f3.write("      can_cascade=\"" + fk.getCascade() + "\"");
            f3.write("/>" + NEWLINE);
            ++i2;
        }
        LinkingKey lk = table.getLinkingKey();
        if (lk != null) {
            f3.write("  <linking_key link1=\"" + lk.getLinkOneId() + "\"" + NEWLINE);
            f3.write("      link2=\"" + lk.getLinkTwoId() + "\"");
            f3.write("/>" + NEWLINE);
        }
        Vector indexVec = table.getIndexVector();
        int i3 = 0;
        while (i3 < indexVec.size()) {
            Index oneIndex = (Index)indexVec.elementAt(i3);
            f3.write("  <index name=\"" + oneIndex.getName() + "\"" + NEWLINE);
            f3.write("      column_id=\"" + oneIndex.getColumnId() + "\"");
            f3.write("/>" + NEWLINE);
            ++i3;
        }
        f3.write("</table>" + NEWLINE);
    }

    static {
        INDENT = INDENT;
        HALF_INDENT = HALF_INDENT;
        aLine = aLine;
        FOREIGNKEY = FOREIGNKEY;
        ID = ID;
        SERIAL = SERIAL;
        PRIMARY_KEY = PRIMARY_KEY;
        NOT_NULL = "true";
        NULL = "false";
        ABSTRACT = "true";
        NOT_ABSTRACT = "false";
        NO_BASE_CLASS = NO_BASE_CLASS;
        TRUE = "true";
        FALSE = "false";
        INTEGER = INTEGER;
        DATA = DATA;
        VALIDATION = VALIDATION;
        LINKING = LINKING;
        VIEW = VIEW;
        SUBSET = SUBSET;
        ONE_TO_ONE = ONE_TO_ONE;
        ONE_TO_MANY = ONE_TO_MANY;
        LINKING_FKEY = LINKING_FKEY;
        LOOKUP_FKEY = LOOKUP_FKEY;
        FIRSTLINE = FIRSTLINE;
        SECONDLINE = SECONDLINE;
    }
}

