/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasHardware;
import org.biomage.Interface.HasSoftwareManufacturers;
import org.biomage.Interface.HasSoftwares;
import org.biomage.Interface.HasType;
import org.biomage.Protocol.Hardware;
import org.biomage.Protocol.Parameterizable;
import org.xml.sax.Attributes;

public class Software
extends Parameterizable
implements Serializable,
HasSoftwareManufacturers,
HasHardware,
HasSoftwares,
HasType {
    protected OntologyEntry type;
    protected Hardware hardware;
    protected HasSoftwares.Softwares_list softwares = new HasSoftwares.Softwares_list();
    protected HasSoftwareManufacturers.SoftwareManufacturers_list softwareManufacturers = new HasSoftwareManufacturers.SoftwareManufacturers_list();

    public Software() {
    }

    public Software(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Software");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Software>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.type != null) {
            out.write("<Type_assn>");
            this.type.writeMAGEML(out);
            out.write("</Type_assn>");
        }
        if (this.hardware != null) {
            out.write("<Hardware_assnref>");
            out.write("<" + this.hardware.getModelClassName() + "_ref identifier=\"" + this.hardware.getIdentifier() + "\"/>");
            out.write("</Hardware_assnref>");
        }
        if (this.softwares.size() > 0) {
            out.write("<Softwares_assnreflist>");
            for (i = 0; i < this.softwares.size(); ++i) {
                modelClassName = ((Software)this.softwares.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Software)this.softwares.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Softwares_assnreflist>");
        }
        if (this.softwareManufacturers.size() > 0) {
            out.write("<SoftwareManufacturers_assnreflist>");
            for (i = 0; i < this.softwareManufacturers.size(); ++i) {
                modelClassName = ((Contact)this.softwareManufacturers.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.softwareManufacturers.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</SoftwareManufacturers_assnreflist>");
        }
    }

    public String getModelClassName() {
        return new String("Software");
    }

    public void setType(OntologyEntry type) {
        this.type = type;
    }

    public OntologyEntry getType() {
        return this.type;
    }

    public void setHardware(Hardware hardware) {
        this.hardware = hardware;
    }

    public Hardware getHardware() {
        return this.hardware;
    }

    public void setSoftwares(HasSoftwares.Softwares_list softwares) {
        this.softwares = softwares;
    }

    public HasSoftwares.Softwares_list getSoftwares() {
        return this.softwares;
    }

    public void addToSoftwares(Software software) {
        this.softwares.add(software);
    }

    public void addToSoftwares(int position, Software software) {
        this.softwares.add(position, software);
    }

    public Software getFromSoftwares(int position) {
        return (Software)this.softwares.get(position);
    }

    public void removeElementAtFromSoftwares(int position) {
        this.softwares.removeElementAt(position);
    }

    public void removeFromSoftwares(Software software) {
        this.softwares.remove(software);
    }

    public void setSoftwareManufacturers(HasSoftwareManufacturers.SoftwareManufacturers_list softwareManufacturers) {
        this.softwareManufacturers = softwareManufacturers;
    }

    public HasSoftwareManufacturers.SoftwareManufacturers_list getSoftwareManufacturers() {
        return this.softwareManufacturers;
    }

    public void addToSoftwareManufacturers(Contact contact) {
        this.softwareManufacturers.add(contact);
    }

    public void addToSoftwareManufacturers(int position, Contact contact) {
        this.softwareManufacturers.add(position, contact);
    }

    public Contact getFromSoftwareManufacturers(int position) {
        return (Contact)this.softwareManufacturers.get(position);
    }

    public void removeElementAtFromSoftwareManufacturers(int position) {
        this.softwareManufacturers.removeElementAt(position);
    }

    public void removeFromSoftwareManufacturers(Contact contact) {
        this.softwareManufacturers.remove(contact);
    }
}

