/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Measurement;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import org.biomage.Common.Extendable;
import org.biomage.Interface.HasUnit;
import org.biomage.Measurement.Unit;
import org.xml.sax.Attributes;

public class Measurement
extends Extendable
implements Serializable,
HasUnit {
    Type type = new Type();
    Object value;
    KindCV kindCV = new KindCV();
    String otherKind;
    protected Unit unit;

    public Measurement() {
    }

    public Measurement(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "type");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.type.setValueByName(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "value")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.value = new String(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "kindCV")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.kindCV.setValueByName(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "otherKind")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.otherKind = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Measurement");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Measurement>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.type != null) {
            out.write(" type=\"" + this.type + "\"");
        }
        if (this.value != null) {
            out.write(" value=\"" + this.value + "\"");
        }
        if (this.kindCV != null) {
            out.write(" kindCV=\"" + this.kindCV + "\"");
        }
        if (this.otherKind != null) {
            out.write(" otherKind=\"" + this.otherKind + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.unit != null) {
            out.write("<Unit_assn>");
            this.unit.writeMAGEML(out);
            out.write("</Unit_assn>");
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String setNameByValueType(int val) {
        return this.getType().setNameByValue(val);
    }

    public int setValueByNameType(String name) {
        return this.getType().setValueByName(name);
    }

    public String getNameByValueType(int val) {
        return this.getType().getNameByValue(val);
    }

    public int getValueByNameType(String name) {
        return this.getType().getValueByName(name);
    }

    public String getNameType() {
        return this.getType().getName();
    }

    public int getValueType() {
        return this.getType().getValue();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setKindCV(KindCV kindCV) {
        this.kindCV = kindCV;
    }

    public KindCV getKindCV() {
        return this.kindCV;
    }

    public String setNameByValueKindCV(int val) {
        return this.getKindCV().setNameByValue(val);
    }

    public int setValueByNameKindCV(String name) {
        return this.getKindCV().setValueByName(name);
    }

    public String getNameByValueKindCV(int val) {
        return this.getKindCV().getNameByValue(val);
    }

    public int getValueByNameKindCV(String name) {
        return this.getKindCV().getValueByName(name);
    }

    public String getNameKindCV() {
        return this.getKindCV().getName();
    }

    public int getValueKindCV() {
        return this.getKindCV().getValue();
    }

    public void setOtherKind(String otherKind) {
        this.otherKind = otherKind;
    }

    public String getOtherKind() {
        return this.otherKind;
    }

    public String getModelClassName() {
        return new String("Measurement");
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public class KindCV {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(8);
        private HashMap valueToName = new HashMap(8);
        public final int time = 0;
        public final int distance = 1;
        public final int temperature = 2;
        public final int quantity = 3;
        public final int mass = 4;
        public final int volume = 5;
        public final int concentration = 6;
        public final int other = 7;

        KindCV() {
            this.nameToValue.put("time", new Integer(0));
            this.valueToName.put(new Integer(0), "time");
            this.nameToValue.put("distance", new Integer(1));
            this.valueToName.put(new Integer(1), "distance");
            this.nameToValue.put("temperature", new Integer(2));
            this.valueToName.put(new Integer(2), "temperature");
            this.nameToValue.put("quantity", new Integer(3));
            this.valueToName.put(new Integer(3), "quantity");
            this.nameToValue.put("mass", new Integer(4));
            this.valueToName.put(new Integer(4), "mass");
            this.nameToValue.put("volume", new Integer(5));
            this.valueToName.put(new Integer(5), "volume");
            this.nameToValue.put("concentration", new Integer(6));
            this.valueToName.put(new Integer(6), "concentration");
            this.nameToValue.put("other", new Integer(7));
            this.valueToName.put(new Integer(7), "other");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }

    public class Type {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(2);
        private HashMap valueToName = new HashMap(2);
        public final int absolute = 0;
        public final int change = 1;

        Type() {
            this.nameToValue.put("absolute", new Integer(0));
            this.valueToName.put(new Integer(0), "absolute");
            this.nameToValue.put("change", new Integer(1));
            this.valueToName.put(new Integer(1), "change");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }
}

