/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioSequence;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioSequence.SeqFeature;
import org.biomage.Common.Identifiable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasOntologyEntries;
import org.biomage.Interface.HasPolymerType;
import org.biomage.Interface.HasSeqFeatures;
import org.biomage.Interface.HasSequenceDatabases;
import org.biomage.Interface.HasSpecies;
import org.biomage.Interface.HasType;
import org.xml.sax.Attributes;

public class BioSequence
extends Identifiable
implements Serializable,
HasSequenceDatabases,
HasOntologyEntries,
HasPolymerType,
HasType,
HasSpecies,
HasSeqFeatures {
    Integer length;
    Boolean isApproximateLength;
    Boolean isCircular;
    String sequence;
    protected HasSequenceDatabases.SequenceDatabases_list sequenceDatabases = new HasSequenceDatabases.SequenceDatabases_list();
    protected HasOntologyEntries.OntologyEntries_list ontologyEntries = new HasOntologyEntries.OntologyEntries_list();
    protected OntologyEntry polymerType;
    protected OntologyEntry type;
    protected OntologyEntry species;
    protected HasSeqFeatures.SeqFeatures_list seqFeatures = new HasSeqFeatures.SeqFeatures_list();

    public BioSequence() {
    }

    public BioSequence(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "length");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.length = new Integer(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "isApproximateLength")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.isApproximateLength = new Boolean(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "isCircular")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.isCircular = new Boolean(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "sequence")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.sequence = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<BioSequence");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</BioSequence>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.length != null) {
            out.write(" length=\"" + this.length + "\"");
        }
        if (this.isApproximateLength != null) {
            out.write(" isApproximateLength=\"" + this.isApproximateLength + "\"");
        }
        if (this.isCircular != null) {
            out.write(" isCircular=\"" + this.isCircular + "\"");
        }
        if (this.sequence != null) {
            out.write(" sequence=\"" + this.sequence + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.sequenceDatabases.size() > 0) {
            out.write("<SequenceDatabases_assnlist>");
            for (i = 0; i < this.sequenceDatabases.size(); ++i) {
                ((DatabaseEntry)this.sequenceDatabases.elementAt(i)).writeMAGEML(out);
            }
            out.write("</SequenceDatabases_assnlist>");
        }
        if (this.ontologyEntries.size() > 0) {
            out.write("<OntologyEntries_assnlist>");
            for (i = 0; i < this.ontologyEntries.size(); ++i) {
                ((OntologyEntry)this.ontologyEntries.elementAt(i)).writeMAGEML(out);
            }
            out.write("</OntologyEntries_assnlist>");
        }
        if (this.polymerType != null) {
            out.write("<PolymerType_assn>");
            this.polymerType.writeMAGEML(out);
            out.write("</PolymerType_assn>");
        }
        if (this.type != null) {
            out.write("<Type_assn>");
            this.type.writeMAGEML(out);
            out.write("</Type_assn>");
        }
        if (this.species != null) {
            out.write("<Species_assn>");
            this.species.writeMAGEML(out);
            out.write("</Species_assn>");
        }
        if (this.seqFeatures.size() > 0) {
            out.write("<SeqFeatures_assnlist>");
            for (i = 0; i < this.seqFeatures.size(); ++i) {
                ((SeqFeature)this.seqFeatures.elementAt(i)).writeMAGEML(out);
            }
            out.write("</SeqFeatures_assnlist>");
        }
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setIsApproximateLength(Boolean isApproximateLength) {
        this.isApproximateLength = isApproximateLength;
    }

    public Boolean getIsApproximateLength() {
        return this.isApproximateLength;
    }

    public void setIsCircular(Boolean isCircular) {
        this.isCircular = isCircular;
    }

    public Boolean getIsCircular() {
        return this.isCircular;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getModelClassName() {
        return new String("BioSequence");
    }

    public void setSequenceDatabases(HasSequenceDatabases.SequenceDatabases_list sequenceDatabases) {
        this.sequenceDatabases = sequenceDatabases;
    }

    public HasSequenceDatabases.SequenceDatabases_list getSequenceDatabases() {
        return this.sequenceDatabases;
    }

    public void addToSequenceDatabases(DatabaseEntry databaseEntry) {
        this.sequenceDatabases.add(databaseEntry);
    }

    public void addToSequenceDatabases(int position, DatabaseEntry databaseEntry) {
        this.sequenceDatabases.add(position, databaseEntry);
    }

    public DatabaseEntry getFromSequenceDatabases(int position) {
        return (DatabaseEntry)this.sequenceDatabases.get(position);
    }

    public void removeElementAtFromSequenceDatabases(int position) {
        this.sequenceDatabases.removeElementAt(position);
    }

    public void removeFromSequenceDatabases(DatabaseEntry databaseEntry) {
        this.sequenceDatabases.remove(databaseEntry);
    }

    public void setOntologyEntries(HasOntologyEntries.OntologyEntries_list ontologyEntries) {
        this.ontologyEntries = ontologyEntries;
    }

    public HasOntologyEntries.OntologyEntries_list getOntologyEntries() {
        return this.ontologyEntries;
    }

    public void addToOntologyEntries(OntologyEntry ontologyEntry) {
        this.ontologyEntries.add(ontologyEntry);
    }

    public void addToOntologyEntries(int position, OntologyEntry ontologyEntry) {
        this.ontologyEntries.add(position, ontologyEntry);
    }

    public OntologyEntry getFromOntologyEntries(int position) {
        return (OntologyEntry)this.ontologyEntries.get(position);
    }

    public void removeElementAtFromOntologyEntries(int position) {
        this.ontologyEntries.removeElementAt(position);
    }

    public void removeFromOntologyEntries(OntologyEntry ontologyEntry) {
        this.ontologyEntries.remove(ontologyEntry);
    }

    public void setPolymerType(OntologyEntry polymerType) {
        this.polymerType = polymerType;
    }

    public OntologyEntry getPolymerType() {
        return this.polymerType;
    }

    public void setType(OntologyEntry type) {
        this.type = type;
    }

    public OntologyEntry getType() {
        return this.type;
    }

    public void setSpecies(OntologyEntry species) {
        this.species = species;
    }

    public OntologyEntry getSpecies() {
        return this.species;
    }

    public void setSeqFeatures(HasSeqFeatures.SeqFeatures_list seqFeatures) {
        this.seqFeatures = seqFeatures;
    }

    public HasSeqFeatures.SeqFeatures_list getSeqFeatures() {
        return this.seqFeatures;
    }

    public void addToSeqFeatures(SeqFeature seqFeature) {
        this.seqFeatures.add(seqFeature);
    }

    public void addToSeqFeatures(int position, SeqFeature seqFeature) {
        this.seqFeatures.add(position, seqFeature);
    }

    public SeqFeature getFromSeqFeatures(int position) {
        return (SeqFeature)this.seqFeatures.get(position);
    }

    public void removeElementAtFromSeqFeatures(int position) {
        this.seqFeatures.removeElementAt(position);
    }

    public void removeFromSeqFeatures(SeqFeature seqFeature) {
        this.seqFeatures.remove(seqFeature);
    }
}

