/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioAssayData;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import org.biomage.BioAssayData.BioDataValues;
import org.biomage.BioAssayData.DataExternal;
import org.biomage.BioAssayData.DataInternal;
import org.xml.sax.Attributes;

public class BioDataCube
extends BioDataValues
implements Serializable {
    Order order = new Order();
    private DataInternal dataInternal;
    private DataExternal dataExternal;

    public BioDataCube() {
    }

    public BioDataCube(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "order");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.order.setValueByName(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<BioDataCube");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</BioDataCube>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.order != null) {
            out.write(" order=\"" + this.order + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.dataInternal != null) {
            out.write("<DataInternal_assn>");
            this.dataInternal.writeMAGEML(out);
            out.write("</DataInternal_assn>");
        }
        if (this.dataExternal != null) {
            out.write("<DataExternal_assn>");
            this.dataExternal.writeMAGEML(out);
            out.write("</DataExternal_assn>");
        }
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }

    public String setNameByValueOrder(int val) {
        return this.getOrder().setNameByValue(val);
    }

    public int setValueByNameOrder(String name) {
        return this.getOrder().setValueByName(name);
    }

    public String getNameByValueOrder(int val) {
        return this.getOrder().getNameByValue(val);
    }

    public int getValueByNameOrder(String name) {
        return this.getOrder().getValueByName(name);
    }

    public String getNameOrder() {
        return this.getOrder().getName();
    }

    public int getValueOrder() {
        return this.getOrder().getValue();
    }

    public String getModelClassName() {
        return new String("BioDataCube");
    }

    public void setDataInternal(DataInternal dataInternal) {
        this.dataInternal = dataInternal;
    }

    public DataInternal getDataInternal() {
        return this.dataInternal;
    }

    public void setDataExternal(DataExternal dataExternal) {
        this.dataExternal = dataExternal;
    }

    public DataExternal getDataExternal() {
        return this.dataExternal;
    }

    public class Order {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(6);
        private HashMap valueToName = new HashMap(6);
        public final int BDQ = 0;
        public final int BQD = 1;
        public final int DBQ = 2;
        public final int DQB = 3;
        public final int QBD = 4;
        public final int QDB = 5;

        Order() {
            this.nameToValue.put("BDQ", new Integer(0));
            this.valueToName.put(new Integer(0), "BDQ");
            this.nameToValue.put("BQD", new Integer(1));
            this.valueToName.put(new Integer(1), "BQD");
            this.nameToValue.put("DBQ", new Integer(2));
            this.valueToName.put(new Integer(2), "DBQ");
            this.nameToValue.put("DQB", new Integer(3));
            this.valueToName.put(new Integer(3), "DQB");
            this.nameToValue.put("QBD", new Integer(4));
            this.valueToName.put(new Integer(4), "QBD");
            this.nameToValue.put("QDB", new Integer(5));
            this.valueToName.put(new Integer(5), "QDB");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }
}

