/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.AuditAndSecurity;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.AuditAndSecurity.SecurityGroup;
import org.biomage.Common.Identifiable;
import org.biomage.Interface.HasOwner;
import org.biomage.Interface.HasSecurityGroups;
import org.xml.sax.Attributes;

public class Security
extends Identifiable
implements Serializable,
HasSecurityGroups,
HasOwner {
    protected HasOwner.Owner_list owner = new HasOwner.Owner_list();
    protected HasSecurityGroups.SecurityGroups_list securityGroups = new HasSecurityGroups.SecurityGroups_list();

    public Security() {
    }

    public Security(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Security");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Security>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.owner.size() > 0) {
            out.write("<Owner_assnreflist>");
            for (i = 0; i < this.owner.size(); ++i) {
                modelClassName = ((Contact)this.owner.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.owner.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Owner_assnreflist>");
        }
        if (this.securityGroups.size() > 0) {
            out.write("<SecurityGroups_assnreflist>");
            for (i = 0; i < this.securityGroups.size(); ++i) {
                modelClassName = ((SecurityGroup)this.securityGroups.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((SecurityGroup)this.securityGroups.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</SecurityGroups_assnreflist>");
        }
    }

    public String getModelClassName() {
        return new String("Security");
    }

    public void setOwner(HasOwner.Owner_list owner) {
        this.owner = owner;
    }

    public HasOwner.Owner_list getOwner() {
        return this.owner;
    }

    public void addToOwner(Contact contact) {
        this.owner.add(contact);
    }

    public void addToOwner(int position, Contact contact) {
        this.owner.add(position, contact);
    }

    public Contact getFromOwner(int position) {
        return (Contact)this.owner.get(position);
    }

    public void removeElementAtFromOwner(int position) {
        this.owner.removeElementAt(position);
    }

    public void removeFromOwner(Contact contact) {
        this.owner.remove(contact);
    }

    public void setSecurityGroups(HasSecurityGroups.SecurityGroups_list securityGroups) {
        this.securityGroups = securityGroups;
    }

    public HasSecurityGroups.SecurityGroups_list getSecurityGroups() {
        return this.securityGroups;
    }

    public void addToSecurityGroups(SecurityGroup securityGroup) {
        this.securityGroups.add(securityGroup);
    }

    public void addToSecurityGroups(int position, SecurityGroup securityGroup) {
        this.securityGroups.add(position, securityGroup);
    }

    public SecurityGroup getFromSecurityGroups(int position) {
        return (SecurityGroup)this.securityGroups.get(position);
    }

    public void removeElementAtFromSecurityGroups(int position) {
        this.securityGroups.removeElementAt(position);
    }

    public void removeFromSecurityGroups(SecurityGroup securityGroup) {
        this.securityGroups.remove(securityGroup);
    }
}

