/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Array;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Array.ArrayGroup;
import org.biomage.Array.ArrayManufacture;
import org.biomage.Array.ArrayManufactureDeviation;
import org.biomage.ArrayDesign.ArrayDesign;
import org.biomage.Common.Identifiable;
import org.biomage.Interface.HasArrayDesign;
import org.biomage.Interface.HasArrayGroup;
import org.biomage.Interface.HasArrayManufactureDeviations;
import org.biomage.Interface.HasInformation;
import org.xml.sax.Attributes;

public class Array
extends Identifiable
implements Serializable,
HasArrayDesign,
HasArrayGroup,
HasInformation,
HasArrayManufactureDeviations {
    String arrayIdentifier;
    Float arrayXOrigin;
    Float arrayYOrigin;
    String originRelativeTo;
    protected ArrayDesign arrayDesign;
    protected ArrayManufacture information;
    protected ArrayGroup arrayGroup;
    protected HasArrayManufactureDeviations.ArrayManufactureDeviations_list arrayManufactureDeviations = new HasArrayManufactureDeviations.ArrayManufactureDeviations_list();

    public Array() {
    }

    public Array(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "arrayIdentifier");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.arrayIdentifier = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "arrayXOrigin")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.arrayXOrigin = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "arrayYOrigin")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.arrayYOrigin = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "originRelativeTo")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.originRelativeTo = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Array");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Array>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.arrayIdentifier != null) {
            out.write(" arrayIdentifier=\"" + this.arrayIdentifier + "\"");
        }
        if (this.arrayXOrigin != null) {
            out.write(" arrayXOrigin=\"" + this.arrayXOrigin + "\"");
        }
        if (this.arrayYOrigin != null) {
            out.write(" arrayYOrigin=\"" + this.arrayYOrigin + "\"");
        }
        if (this.originRelativeTo != null) {
            out.write(" originRelativeTo=\"" + this.originRelativeTo + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.arrayDesign != null) {
            out.write("<ArrayDesign_assnref>");
            out.write("<" + this.arrayDesign.getModelClassName() + "_ref identifier=\"" + this.arrayDesign.getIdentifier() + "\"/>");
            out.write("</ArrayDesign_assnref>");
        }
        if (this.information != null) {
            out.write("<Information_assnref>");
            out.write("<" + this.information.getModelClassName() + "_ref identifier=\"" + this.information.getIdentifier() + "\"/>");
            out.write("</Information_assnref>");
        }
        if (this.arrayGroup != null) {
            out.write("<ArrayGroup_assnref>");
            out.write("<" + this.arrayGroup.getModelClassName() + "_ref identifier=\"" + this.arrayGroup.getIdentifier() + "\"/>");
            out.write("</ArrayGroup_assnref>");
        }
        if (this.arrayManufactureDeviations.size() > 0) {
            out.write("<ArrayManufactureDeviations_assnlist>");
            for (int i = 0; i < this.arrayManufactureDeviations.size(); ++i) {
                ((ArrayManufactureDeviation)this.arrayManufactureDeviations.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ArrayManufactureDeviations_assnlist>");
        }
    }

    public void setArrayIdentifier(String arrayIdentifier) {
        this.arrayIdentifier = arrayIdentifier;
    }

    public String getArrayIdentifier() {
        return this.arrayIdentifier;
    }

    public void setArrayXOrigin(Float arrayXOrigin) {
        this.arrayXOrigin = arrayXOrigin;
    }

    public Float getArrayXOrigin() {
        return this.arrayXOrigin;
    }

    public void setArrayYOrigin(Float arrayYOrigin) {
        this.arrayYOrigin = arrayYOrigin;
    }

    public Float getArrayYOrigin() {
        return this.arrayYOrigin;
    }

    public void setOriginRelativeTo(String originRelativeTo) {
        this.originRelativeTo = originRelativeTo;
    }

    public String getOriginRelativeTo() {
        return this.originRelativeTo;
    }

    public String getModelClassName() {
        return new String("Array");
    }

    public void setArrayDesign(ArrayDesign arrayDesign) {
        this.arrayDesign = arrayDesign;
    }

    public ArrayDesign getArrayDesign() {
        return this.arrayDesign;
    }

    public void setInformation(ArrayManufacture information) {
        this.information = information;
    }

    public ArrayManufacture getInformation() {
        return this.information;
    }

    public void setArrayGroup(ArrayGroup arrayGroup) {
        this.arrayGroup = arrayGroup;
    }

    public ArrayGroup getArrayGroup() {
        return this.arrayGroup;
    }

    public void setArrayManufactureDeviations(HasArrayManufactureDeviations.ArrayManufactureDeviations_list arrayManufactureDeviations) {
        this.arrayManufactureDeviations = arrayManufactureDeviations;
    }

    public HasArrayManufactureDeviations.ArrayManufactureDeviations_list getArrayManufactureDeviations() {
        return this.arrayManufactureDeviations;
    }

    public void addToArrayManufactureDeviations(ArrayManufactureDeviation arrayManufactureDeviation) {
        this.arrayManufactureDeviations.add(arrayManufactureDeviation);
    }

    public void addToArrayManufactureDeviations(int position, ArrayManufactureDeviation arrayManufactureDeviation) {
        this.arrayManufactureDeviations.add(position, arrayManufactureDeviation);
    }

    public ArrayManufactureDeviation getFromArrayManufactureDeviations(int position) {
        return (ArrayManufactureDeviation)this.arrayManufactureDeviations.get(position);
    }

    public void removeElementAtFromArrayManufactureDeviations(int position) {
        this.arrayManufactureDeviations.removeElementAt(position);
    }

    public void removeFromArrayManufactureDeviations(ArrayManufactureDeviation arrayManufactureDeviation) {
        this.arrayManufactureDeviations.remove(arrayManufactureDeviation);
    }
}

