/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.ls.DOMEntityResolver;

public class DOMConfigurationImpl
extends ParserConfigurationSettings
implements XMLParserConfiguration,
DOMConfiguration {
    protected static final String XERCES_VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String XERCES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String SCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SEND_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String XML_STRING = "http://xml.org/sax/properties/xml-string";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    XMLDocumentHandler fDocumentHandler;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short DTNORMALIZATION = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short SPLITCDATA = 16;
    protected static final short COMMENTS = 32;
    protected static final short VALIDATE = 64;
    protected static final short PSVI = 128;
    protected SymbolTable fSymbolTable;
    protected Vector fComponents;
    protected ValidationManager fValidationManager;
    protected Locale fLocale;
    protected XMLErrorReporter fErrorReporter;
    protected final DOMErrorHandlerWrapper fErrorHandlerWrapper = new DOMErrorHandlerWrapper();

    protected DOMConfigurationImpl() {
        this(null, null);
    }

    protected void reset() throws XNIException {
        if (this.fValidationManager != null) {
            this.fValidationManager.reset();
        }
        int count = this.fComponents.size();
        int i = 0;
        while (i < count) {
            XMLComponent c = (XMLComponent)this.fComponents.elementAt(i);
            c.reset(this);
            ++i;
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        String property;
        if (propertyId.startsWith("http://xml.org/sax/properties/") && (property = propertyId.substring("http://xml.org/sax/properties/".length())).equals("xml-string")) {
            short type = 1;
            throw new XMLConfigurationException(type, propertyId);
        }
        super.checkProperty(propertyId);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        super.setFeature(featureId, state);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setLocale(Locale locale) throws XNIException {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    protected ValidationManager createValidationManager() {
        return new ValidationManager();
    }

    protected DOMConfigurationImpl(SymbolTable symbolTable) {
        this(symbolTable, null);
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return null;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler handler) {
    }

    public XMLDTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(XMLDTDHandler dtdHandler) {
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    protected void addComponent(XMLComponent component) {
        if (this.fComponents.contains(component)) {
            return;
        }
        this.fComponents.addElement(component);
        String[] recognizedFeatures = component.getRecognizedFeatures();
        this.addRecognizedFeatures(recognizedFeatures);
        String[] recognizedProperties = component.getRecognizedProperties();
        this.addRecognizedProperties(recognizedProperties);
    }

    public XMLEntityResolver getEntityResolver() {
        return (XMLEntityResolver)this.fProperties.get(ENTITY_RESOLVER);
    }

    public void setEntityResolver(XMLEntityResolver resolver) {
        if (resolver != null) {
            this.fProperties.put(ENTITY_RESOLVER, resolver);
        }
    }

    public XMLErrorHandler getErrorHandler() {
        return (XMLErrorHandler)this.fProperties.get(ERROR_HANDLER);
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.fProperties.put(ERROR_HANDLER, errorHandler);
        }
    }

    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("comments")) {
            return (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespaces")) {
            return (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("datatype-normalization")) {
            return (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("cdata-sections")) {
            return (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("entities")) {
            return (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("split-cdata-sections")) {
            return (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("validate")) {
            return (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate-if-schema")) {
            return Boolean.FALSE;
        }
        if (name.equals(SEND_PSVI)) {
            return Boolean.TRUE;
        }
        if (name.equals("psvi")) {
            return (this.features & 0x80) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content")) {
            return Boolean.TRUE;
        }
        if (name.equals("error-handler")) {
            return this.fErrorHandlerWrapper.getErrorHandler();
        }
        if (name.equals("entity-resolver")) {
            XMLEntityResolver entityResolver = this.getEntityResolver();
            if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                return ((DOMEntityResolverWrapper)entityResolver).getEntityResolver();
            }
            return null;
        }
        if (name.equals("schema-type")) {
            return this.getProperty(JAXP_SCHEMA_LANGUAGE);
        }
        if (name.equals("schema-location")) {
            return this.getProperty(JAXP_SCHEMA_SOURCE);
        }
        if (name.equals(SYMBOL_TABLE)) {
            return this.getProperty(SYMBOL_TABLE);
        }
        if (name.equals(GRAMMAR_POOL)) {
            return this.getProperty(GRAMMAR_POOL);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value == Boolean.TRUE || value == Boolean.FALSE) {
            boolean state;
            boolean bl = state = value == Boolean.TRUE;
            if (name.equals("comments")) {
                this.features = (short)(state ? this.features | 0x20 : this.features & 0xFFFFFFDF);
                return;
            }
            if (name.equals("datatype-normalization")) {
                this.setFeature(NORMALIZE_DATA, state);
                this.features = (short)(state ? this.features | 2 : this.features & 0xFFFFFFFD);
                return;
            }
            if (name.equals("namespaces")) {
                this.features = (short)(state ? this.features | 1 : this.features & 0xFFFFFFFE);
                return;
            }
            if (name.equals("cdata-sections")) {
                this.features = (short)(state ? this.features | 8 : this.features & 0xFFFFFFF7);
                return;
            }
            if (name.equals("entities")) {
                this.features = (short)(state ? this.features | 4 : this.features & 0xFFFFFFFB);
                return;
            }
            if (name.equals("split-cdata-sections")) {
                this.features = (short)(state ? this.features | 0x10 : this.features & 0xFFFFFFEF);
                return;
            }
            if (name.equals("validate")) {
                this.features = (short)(state ? this.features | 0x40 : this.features & 0xFFFFFFBF);
                return;
            }
            if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate-if-schema")) {
                if (!state) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content")) {
                if (state) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (name.equals(SEND_PSVI)) {
                if (state) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (!name.equals("psvi")) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(8, msg);
            }
            this.features = (short)(state ? this.features | 0x80 : this.features & 0xFFFFFF7F);
            return;
        }
        if (name.equals("error-handler")) {
            if (value instanceof DOMErrorHandler) {
                this.fErrorHandlerWrapper.setErrorHandler((DOMErrorHandler)value);
                this.setErrorHandler(this.fErrorHandlerWrapper);
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("entity-resolver")) {
            if (!(value instanceof DOMEntityResolver)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            try {
                this.setEntityResolver(new DOMEntityResolverWrapper((DOMEntityResolver)value));
                return;
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equals("schema-location")) {
            if (!(value instanceof String)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            try {
                String schemaType = (String)this.getProperty(JAXP_SCHEMA_LANGUAGE);
                if (schemaType == Constants.NS_XMLSCHEMA) {
                    this.setProperty(JAXP_SCHEMA_SOURCE, value);
                    return;
                }
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equals("schema-type")) {
            if (!(value instanceof String)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            try {
                if (value.equals(Constants.NS_XMLSCHEMA)) {
                    this.setProperty(JAXP_SCHEMA_LANGUAGE, Constants.NS_XMLSCHEMA);
                    return;
                }
                if (!value.equals(Constants.NS_DTD)) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            catch (XMLConfigurationException e) {
                return;
            }
        }
        if (name.equals(SYMBOL_TABLE)) {
            if (value instanceof SymbolTable) {
                this.setProperty(SYMBOL_TABLE, value);
                return;
            }
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (!name.equals(GRAMMAR_POOL)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
            throw new DOMException(8, msg);
        }
        if (value instanceof XMLGrammarPool) {
            this.setProperty(GRAMMAR_POOL, value);
            return;
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
        throw new DOMException(9, msg);
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        super.setProperty(propertyId, value);
    }

    public boolean canSetParameter(String name, Object state) {
        if (name.equals("comments") || name.equals("datatype-normalization") || name.equals("cdata-sections") || name.equals("entities") || name.equals("split-cdata-sections") || name.equals("namespaces") || name.equals("validate")) {
            return state instanceof Boolean;
        }
        if (name.equals("infoset") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate-if-schema")) {
            if (state instanceof Boolean) {
                return state != Boolean.TRUE;
            }
            return false;
        }
        if (name.equals("namespace-declarations") || name.equals("whitespace-in-element-content") || name.equals(SEND_PSVI)) {
            return state == Boolean.TRUE;
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    protected DOMConfigurationImpl(SymbolTable symbolTable, XMLComponentManager parentSettings) {
        super(parentSettings);
        MessageFormatter xmft;
        this.fRecognizedFeatures = new Vector();
        this.fRecognizedProperties = new Vector();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        String[] recognizedFeatures = new String[]{XERCES_VALIDATION, XERCES_NAMESPACES, SCHEMA, DYNAMIC_VALIDATION, NORMALIZE_DATA, SEND_PSVI};
        this.addRecognizedFeatures(recognizedFeatures);
        this.setFeature(XERCES_VALIDATION, false);
        this.setFeature(SCHEMA, false);
        this.setFeature(DYNAMIC_VALIDATION, false);
        this.setFeature(NORMALIZE_DATA, false);
        this.setFeature(XERCES_NAMESPACES, true);
        this.setFeature(SEND_PSVI, true);
        String[] recognizedProperties = new String[]{XML_STRING, SYMBOL_TABLE, ERROR_HANDLER, ENTITY_RESOLVER, ERROR_REPORTER, ENTITY_MANAGER, VALIDATION_MANAGER, GRAMMAR_POOL, JAXP_SCHEMA_SOURCE, JAXP_SCHEMA_LANGUAGE};
        this.addRecognizedProperties(recognizedProperties);
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x20);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
        }
        this.fSymbolTable = symbolTable;
        this.fComponents = new Vector();
        this.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        this.fErrorReporter = new XMLErrorReporter();
        this.setProperty(ERROR_REPORTER, this.fErrorReporter);
        this.addComponent(this.fErrorReporter);
        XMLEntityManager manager = new XMLEntityManager();
        this.setProperty(ENTITY_MANAGER, manager);
        this.addComponent(manager);
        this.fValidationManager = this.createValidationManager();
        this.setProperty(VALIDATION_MANAGER, this.fValidationManager);
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
            xmft = new XMLMessageFormatter();
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", xmft);
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", xmft);
        }
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            xmft = null;
            try {
                xmft = (MessageFormatter)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XSMessageFormatter", ObjectFactory.findClassLoader(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xmft != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
            }
        }
        try {
            this.setLocale(Locale.getDefault());
        }
        catch (XNIException e) {}
    }
}

