### Name: fileMuncher
### Title: Dynamically create a Perl script to parse a source file base on
###   user specifications
### Aliases: fileMuncher mergeRowByKey
### Keywords: manip

### ** Examples

if(interactive()){
path <- file.path(.path.package("AnnBuilder"), "data")
temp <- matrix(c("32469_f_at", "D90278", "32469_at", "L00693", "33825_at",
"X68733", "35730_at", "X03350", "38912_at", "D90042", "38936_at",
"M16652"), ncol = 2, byrow = TRUE)
write.table(temp, "tempBase", sep = "\t", quote = FALSE,
row.names = FALSE, col.names = FALSE)
# Parse a truncated version of LL\_tmpl.gz from Bioconductor
srcFile <-
loadFromUrl("http://www.bioconductor.org/datafiles/wwwsources/Tll_tmpl.gz")  
fileMuncher(outName = "temp", baseFile = "tempBase", dataFile = srcFile,
parser =  file.path(path, "gbLLParser"), isDir = FALSE)
# Show the parsed data
read.table(file = "temp", sep = "\t", header = FALSE)
unlink("tempBase")
unlink("temp")
}



